/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the TextInputComponent component from the concrete toolkit.
 * 
 */
@RealizedType(realizedType="guidancer.abstract.TextInputSupport")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ComponentClassGenerator", 
           date =  "2017-02-20T11:36:04.313Z")
public class TextInputComponent extends org.eclipse.jubula.toolkit.base.internal.impl.TextInputComponent implements org.eclipse.jubula.toolkit.concrete.components.TextInputComponent {
            public TextInputComponent(@NonNull ComponentIdentifier componentIdentifier) {
                super(componentIdentifier);
            }
    
    
        /**
         * 
         * @param text 
         *        the text to use
         * @param index 
         *        the index
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP insertTextAfterIndex(@NonNull String text,@NonNull Integer index
        ) throws IllegalArgumentException {
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            Validate.notNull(index, "Argument 'index' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcInsertText")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(text)
                        .addParameter(index)
                        .build();
        }
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param pattern 
         *        the pattern to use
         * @param operator 
         *        the operator used for comparison
         * @param insertAfterPattern 
         *        insert after pattern
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP insertTextBeforeAfterPattern(@NonNull String text,@NonNull String pattern,@NonNull Operator operator,@NonNull Boolean insertAfterPattern
        ) throws IllegalArgumentException {
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            Validate.notNull(pattern, "Argument 'pattern' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(insertAfterPattern, "Argument 'insertAfterPattern' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcInsertText")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(text)
                        .addParameter(pattern)
                        .addParameter(operator.rcValue())
                        .addParameter(insertAfterPattern)
                        .build();
        }
        
        /**
         * 
         * 
         */
        @NonNull public CAP selectAll(
        )  {
            
            return new CapBuilder("rcSelect")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .build();
        }
        
        /**
         * 
         * @param pattern 
         *        the pattern to use
         * @param operator 
         *        the operator used for comparison
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP selectPattern(@NonNull String pattern,@NonNull Operator operator
        ) throws IllegalArgumentException {
            Validate.notNull(pattern, "Argument 'pattern' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcSelect")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(pattern)
                        .addParameter(operator.rcValue())
                        .build();
        }
        
} 