/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.internal.impl.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Class representing the TabComponentActionHandler component from the concrete toolkit.
 * @since 4.0
 */
@RealizedType(realizedType="guidancer.abstract.Widget")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2017-02-20T11:36:04.292Z")
@Beta
public class TabComponentActionHandler extends org.eclipse.jubula.toolkit.base.internal.impl.handler.GraphicsComponentActionHandler implements org.eclipse.jubula.toolkit.concrete.components.handler.TabComponentActionHandler {
            public TabComponentActionHandler(@NonNull ComponentIdentifier componentIdentifier) {
                super(componentIdentifier);
            }
    
    
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public void checkSelectionOfTabByValue(
            @Nullable String title,
            @Nullable Operator operator,
            @Nullable Boolean selected,
            @Nullable Integer timeoutInMs
        )  {
            if (title == null) return;
            
            if (operator == null) return;
            
            if (selected == null) return;
            
            if (timeoutInMs == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifySelectedTab")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(title)
                            .addParameter(operator.rcValue())
                            .addParameter(selected)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param selected 
         *        whether the component is expected to be selected or not
         * @since 4.1
         */
        public void checkSelectionOfTabByValue(
            @Nullable String title,
            @Nullable Operator operator,
            @Nullable Boolean selected
        )  {
            if (title == null) return;
            
            if (operator == null) return;
            
            if (selected == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifySelectedTab")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(title)
                            .addParameter(operator.rcValue())
                            .addParameter(selected)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * 
         */
        public void selectTabByValue(
            @Nullable String title,
            @Nullable Operator operator
        )  {
            if (title == null) return;
            
            if (operator == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcSelectTab")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(title)
                            .addParameter(operator.rcValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public void checkEnablementOfTabByValue(
            @Nullable String title,
            @Nullable Operator operator,
            @Nullable Boolean enabled,
            @Nullable Integer timeoutInMs
        )  {
            if (title == null) return;
            
            if (operator == null) return;
            
            if (enabled == null) return;
            
            if (timeoutInMs == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyEnabled")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(title)
                            .addParameter(operator.rcValue())
                            .addParameter(enabled)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @since 4.1
         */
        public void checkEnablementOfTabByValue(
            @Nullable String title,
            @Nullable Operator operator,
            @Nullable Boolean enabled
        )  {
            if (title == null) return;
            
            if (operator == null) return;
            
            if (enabled == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyEnabled")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(title)
                            .addParameter(operator.rcValue())
                            .addParameter(enabled)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param index 
         *        the 1-based index
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public void checkSelectionOfTabByIndex(
            @Nullable Integer index,
            @Nullable Boolean selected,
            @Nullable Integer timeoutInMs
        )  {
            if (index == null) return;
            
            if (selected == null) return;
            
            if (timeoutInMs == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifySelectedTabByIndex")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(index)
                            .addParameter(selected)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param index 
         *        the 1-based index
         * @param selected 
         *        whether the component is expected to be selected or not
         * @since 4.1
         */
        public void checkSelectionOfTabByIndex(
            @Nullable Integer index,
            @Nullable Boolean selected
        )  {
            if (index == null) return;
            
            if (selected == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifySelectedTabByIndex")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(index)
                            .addParameter(selected)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param index 
         *        the 1-based index
         * 
         */
        public void selectTabByIndex(
            @Nullable Integer index
        )  {
            if (index == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcSelectTabByIndex")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(index)
                            .build(), null);
        }
        
        /**
         * 
         * @param index 
         *        the 1-based index
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public void checkEnablementOfTabByIndex(
            @Nullable Integer index,
            @Nullable Boolean enabled,
            @Nullable Integer timeoutInMs
        )  {
            if (index == null) return;
            
            if (enabled == null) return;
            
            if (timeoutInMs == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyEnabledByIndex")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(index)
                            .addParameter(enabled)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param index 
         *        the 1-based index
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @since 4.1
         */
        public void checkEnablementOfTabByIndex(
            @Nullable Integer index,
            @Nullable Boolean enabled
        )  {
            if (index == null) return;
            
            if (enabled == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyEnabledByIndex")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(index)
                            .addParameter(enabled)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param index 
         *        the 1-based index
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public void checkTextOfTabByIndex(
            @Nullable Integer index,
            @Nullable String title,
            @Nullable Operator operator,
            @Nullable Integer timeoutInMs
        )  {
            if (index == null) return;
            
            if (title == null) return;
            
            if (operator == null) return;
            
            if (timeoutInMs == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyTextOfTabByIndex")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(index)
                            .addParameter(title)
                            .addParameter(operator.rcValue())
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param index 
         *        the 1-based index
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @since 4.1
         */
        public void checkTextOfTabByIndex(
            @Nullable Integer index,
            @Nullable String title,
            @Nullable Operator operator
        )  {
            if (index == null) return;
            
            if (title == null) return;
            
            if (operator == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyTextOfTabByIndex")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(index)
                            .addParameter(title)
                            .addParameter(operator.rcValue())
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param tab 
         *        the tab
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public void checkExistenceOfTab(
            @Nullable String tab,
            @Nullable Operator operator,
            @Nullable Boolean exists,
            @Nullable Integer timeoutInMs
        )  {
            if (tab == null) return;
            
            if (operator == null) return;
            
            if (exists == null) return;
            
            if (timeoutInMs == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyExistenceOfTab")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(tab)
                            .addParameter(operator.rcValue())
                            .addParameter(exists)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param tab 
         *        the tab
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @since 4.1
         */
        public void checkExistenceOfTab(
            @Nullable String tab,
            @Nullable Operator operator,
            @Nullable Boolean exists
        )  {
            if (tab == null) return;
            
            if (operator == null) return;
            
            if (exists == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyExistenceOfTab")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(tab)
                            .addParameter(operator.rcValue())
                            .addParameter(exists)
                            .addParameter(0)
                            .build(), null);
        }
        
} 