/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.swing;

import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.ToolkitInfo;
import org.eclipse.jubula.toolkit.swing.internal.SwingToolkitInfo;

/**
 * Factory for creating components from the swing toolkit.
 * @noextend This class is not intended to be extended by clients.
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.FactoryGenerator", 
           date =  "2017-02-20T11:36:04.258Z")
public class SwingComponents {
    
    @NonNull private final static ToolkitInfo TOOLKIT_INFORMATION = SwingToolkit.createToolkitInformation();

    private SwingComponents() {
        super();
    }
    
    /** 
     *  @return the toolkit information, not recommended to be modified
     */
    @NonNull public static ToolkitInfo getToolkitInformation() {
        return TOOLKIT_INFORMATION;
    }

    /** create a new representative for a {@link Application} component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.Application createApplication () {
        return new org.eclipse.jubula.toolkit.swing.internal.impl.Application();
    }
    
    /** create a new instance of ApplicationActionHandler 
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ApplicationActionHandler createApplicationActionHandler () {
        return new org.eclipse.jubula.toolkit.swing.internal.impl.handler.ApplicationActionHandler();
    }
    /** create a new representative for a {@link JavaReflection} component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ReflectionComponent createJavaReflection () {
        return new org.eclipse.jubula.toolkit.swing.internal.impl.JavaReflection();
    }
    
    /** create a new instance of JavaReflectionActionHandler 
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ReflectionComponentActionHandler createJavaReflectionActionHandler () {
        return new org.eclipse.jubula.toolkit.swing.internal.impl.handler.JavaReflectionActionHandler();
    }
    /** create a new representative for a {@link javax.swing.AbstractButton} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createAbstractButton (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swing.internal.impl.AbstractButton(componentIdentifier);
    }
    
    /** create a new representative for a {@link javax.swing.AbstractButton} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ButtonComponentActionHandler createAbstractButtonActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swing.internal.impl.handler.AbstractButtonActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link JMenuBar} component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.MenuBarComponent createJMenuBar () {
        return new org.eclipse.jubula.toolkit.swing.internal.impl.JMenuBar();
    }
    
    /** create a new instance of JMenuBarActionHandler 
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.MenuBarComponentActionHandler createJMenuBarActionHandler () {
        return new org.eclipse.jubula.toolkit.swing.internal.impl.handler.JMenuBarActionHandler();
    }
    /** create a new representative for a {@link javax.swing.JComboBox} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ComboComponent createJComboBox (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ComboComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swing.internal.impl.JComboBox(componentIdentifier);
    }
    
    /** create a new representative for a {@link javax.swing.JComboBox} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ComboComponentActionHandler createJComboBoxActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ComboComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swing.internal.impl.handler.JComboBoxActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link javax.swing.JList} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ListComponent createJList (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ListComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swing.internal.impl.JList(componentIdentifier);
    }
    
    /** create a new representative for a {@link javax.swing.JList} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ListComponentActionHandler createJListActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ListComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swing.internal.impl.handler.JListActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link javax.swing.JLabel} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextComponent createJLabel (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swing.internal.impl.JLabel(componentIdentifier);
    }
    
    /** create a new representative for a {@link javax.swing.JLabel} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TextComponentActionHandler createJLabelActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swing.internal.impl.handler.JLabelActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link javax.swing.JTabbedPane} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TabComponent createJTabbedPane (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TabComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swing.internal.impl.JTabbedPane(componentIdentifier);
    }
    
    /** create a new representative for a {@link javax.swing.JTabbedPane} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TabComponentActionHandler createJTabbedPaneActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TabComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swing.internal.impl.handler.JTabbedPaneActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link javax.swing.JTable} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TableComponent createJTable (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TableComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swing.internal.impl.JTable(componentIdentifier);
    }
    
    /** create a new representative for a {@link javax.swing.JTable} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TableComponentActionHandler createJTableActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TableComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swing.internal.impl.handler.JTableActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link javax.swing.text.JTextComponent} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextInputComponent createJTextComponent (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swing.internal.impl.JTextComponent(componentIdentifier);
    }
    
    /** create a new representative for a {@link javax.swing.text.JTextComponent} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TextInputComponentActionHandler createJTextComponentActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swing.internal.impl.handler.JTextComponentActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link javax.swing.JTree} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TreeComponent createJTree (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TreeComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swing.internal.impl.JTree(componentIdentifier);
    }
    
    /** create a new representative for a {@link javax.swing.JTree} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TreeComponentActionHandler createJTreeActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TreeComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swing.internal.impl.handler.JTreeActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link javax.swing.JProgressBar} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.base.components.GraphicsComponent createJProgressBar (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.base.components.GraphicsComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swing.internal.impl.JProgressBar(componentIdentifier);
    }
    
    /** create a new representative for a {@link javax.swing.JProgressBar} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.base.components.handler.GraphicsComponentActionHandler createJProgressBarActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.base.components.GraphicsComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swing.internal.impl.handler.JProgressBarActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link OperatingSystem} component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.OperatingSystemComponent createOperatingSystem () {
        return new org.eclipse.jubula.toolkit.swing.internal.impl.OperatingSystem();
    }
    
    /** create a new instance of OperatingSystemActionHandler 
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.OperatingSystemComponentActionHandler createOperatingSystemActionHandler () {
        return new org.eclipse.jubula.toolkit.swing.internal.impl.handler.OperatingSystemActionHandler();
    }
    /** create a new representative for a {@link javax.swing.JSlider} UI component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.SliderComponent createJSlider (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.SliderComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swing.internal.impl.JSlider(componentIdentifier);
    }
    
    /** create a new representative for a {@link javax.swing.JSlider} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.SliderComponentActionHandler createJSliderActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.SliderComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swing.internal.impl.handler.JSliderActionHandler(componentIdentifier);
    }
}