/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.Query;
import javax.persistence.Transient;
import org.apache.commons.collections.iterators.IteratorChain;
import org.eclipse.jubula.client.core.model.AUTMainPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IControllerPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.NodePO;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.persistence.annotations.BatchFetch;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;

@Entity
@DiscriminatorValue(value="T")
class TestSuitePO
extends NodePO
implements ITestSuitePO,
PersistenceWeaved,
PersistenceObject {
    private transient boolean m_isEditable = true;
    private int m_stepDelay;
    private boolean m_relevant = true;
    private IAUTMainPO m_aut;
    private transient boolean m_isStarted = false;
    private Map<String, Integer> m_defaultEventHandler = new HashMap<String, Integer>(4);
    static final long serialVersionUID = -7110325807052643695L;

    TestSuitePO() {
    }

    TestSuitePO(String testSuiteName, boolean isGenerated) {
        super(testSuiteName, isGenerated);
        this.addTrackedChange("created", false);
        this.init();
    }

    TestSuitePO(String testSuiteName, String guid, boolean isGenerated) {
        super(testSuiteName, guid, isGenerated);
        this.init();
    }

    private void init() {
        Map map = ComponentBuilder.getInstance().getCompSystem().getEventTypes();
        Set mapKeySet = map.keySet();
        for (Object object : mapKeySet) {
            String key = (String)object;
            this.getDefaultEventHandler().put(key, (Integer)map.get(key));
        }
    }

    @Override
    @Basic
    public int getStepDelay() {
        return this.m_stepDelay;
    }

    @Override
    public void setStepDelay(int stepDelay) {
        this.m_stepDelay = stepDelay;
    }

    @Override
    @Basic
    public boolean getRelevant() {
        return this.m_relevant;
    }

    @Override
    public void setRelevant(boolean relevant) {
        this.m_relevant = relevant;
    }

    @Override
    @ManyToOne(fetch=FetchType.EAGER, targetEntity=AUTMainPO.class)
    @JoinColumn(name="AUT")
    @BatchFetch(value=BatchFetchType.JOIN)
    public IAUTMainPO getAut() {
        return this.m_aut;
    }

    @Override
    public void setAut(IAUTMainPO aut) {
        this.m_aut = aut;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TestSuitePO) && !(obj instanceof ITestSuitePO)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    @Transient
    public boolean isStarted() {
        return this.m_isStarted;
    }

    @Override
    public void setStarted(boolean isStarted) {
        this.m_isStarted = isStarted;
    }

    @Override
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="DEF_EVENTH")
    @MapKeyColumn(name="EVENT_TYPE")
    @Column(name="REENTRY")
    public Map<String, Integer> getDefaultEventHandler() {
        return this.m_defaultEventHandler;
    }

    private void removeDefaultEventHandlers(EntityManager sess) {
        Query q = sess.createNativeQuery("delete from DEF_EVENTH where TESTSUITEPO_ID = ?1");
        q.setParameter(1, (Object)this.getId()).executeUpdate();
    }

    @Override
    public void setDefaultEventHandler(Map<String, Integer> defaultEventHandler) {
        if (defaultEventHandler != null) {
            this.m_defaultEventHandler = defaultEventHandler;
        }
    }

    @Override
    @Transient
    public boolean isEditable() {
        return this.m_isEditable;
    }

    @Override
    public void setEditable(boolean editable) {
        this.m_isEditable = editable;
    }

    public int compareTo(Object o) {
        ITestSuitePO ts = (ITestSuitePO)o;
        return this.getName().compareTo(ts.getName());
    }

    @Transient
    public Boolean isReused() {
        return true;
    }

    @Override
    public void goingToBeDeleted(EntityManager sess) {
        super.goingToBeDeleted(sess);
        this.removeDefaultEventHandlers(sess);
    }

    @Override
    @Transient
    public Iterator<INodePO> getAllNodeIter() {
        IteratorChain chain = new IteratorChain();
        chain.addIterator(this.getNodeListIterator());
        for (INodePO node : this.getUnmodifiableNodeList()) {
            if (!(node instanceof IControllerPO)) continue;
            for (INodePO cont : node.getUnmodifiableNodeList()) {
                chain.addIterator(cont.getNodeListIterator());
            }
        }
        return chain;
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new TestSuitePO();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "relevant") {
            return this.relevant;
        }
        if (string == "defaultEventHandler") {
            return this.defaultEventHandler;
        }
        if (string == "aut") {
            return this.aut;
        }
        if (string == "stepDelay") {
            return this.stepDelay;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "relevant") {
            this.relevant = (Boolean)object;
            return;
        }
        if (string == "defaultEventHandler") {
            this.defaultEventHandler = (Map)object;
            return;
        }
        if (string == "aut") {
            this.aut = (IAUTMainPO)object;
            return;
        }
        if (string == "stepDelay") {
            this.stepDelay = (Integer)object;
            return;
        }
        super._persistence_set(string, object);
    }
}

