/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.internal.impl.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Class representing the ListComponentActionHandler component from the concrete toolkit.
 * @since 4.0
 */
@RealizedType(realizedType="guidancer.abstract.TextVerifiable")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2017-09-15T06:49:19.267Z")
public class ListComponentActionHandler extends org.eclipse.jubula.toolkit.base.internal.impl.handler.TextComponentActionHandler implements org.eclipse.jubula.toolkit.concrete.components.handler.ListComponentActionHandler {
            public ListComponentActionHandler(@NonNull ComponentIdentifier componentIdentifier) {
                super(componentIdentifier);
            }
    
    
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkSelectionOfEntryByValue(
            @Nullable String text,
            @Nullable Operator operator,
            @Nullable Boolean selected,
            @Nullable Integer timeoutInMs
        )  {
            if (text == null) return null;
            
            if (operator == null) return null;
            
            if (selected == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifySelectedValue")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(text)
                            .addParameter(operator.rcValue())
                            .addParameter(selected)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param selected 
         *        whether the component is expected to be selected or not
         * @since 4.1
         */
        public Result checkSelectionOfEntryByValue(
            @Nullable String text,
            @Nullable Operator operator,
            @Nullable Boolean selected
        )  {
            if (text == null) return null;
            
            if (operator == null) return null;
            
            if (selected == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifySelectedValue")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(text)
                            .addParameter(operator.rcValue())
                            .addParameter(selected)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkExistenceOfEntryByValue(
            @Nullable String text,
            @Nullable Operator operator,
            @Nullable Boolean exists,
            @Nullable Integer timeoutInMs
        )  {
            if (text == null) return null;
            
            if (operator == null) return null;
            
            if (exists == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyContainsValue")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(text)
                            .addParameter(operator.rcValue())
                            .addParameter(exists)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @since 4.1
         */
        public Result checkExistenceOfEntryByValue(
            @Nullable String text,
            @Nullable Operator operator,
            @Nullable Boolean exists
        )  {
            if (text == null) return null;
            
            if (operator == null) return null;
            
            if (exists == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyContainsValue")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(text)
                            .addParameter(operator.rcValue())
                            .addParameter(exists)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param index 
         *        the index
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkSelectionOfEntryByIndex(
            @Nullable String index,
            @Nullable Boolean selected,
            @Nullable Integer timeoutInMs
        )  {
            if (index == null) return null;
            
            if (selected == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifySelectedIndex")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(index)
                            .addParameter(selected)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param index 
         *        the index
         * @param selected 
         *        whether the component is expected to be selected or not
         * @since 4.1
         */
        public Result checkSelectionOfEntryByIndex(
            @Nullable String index,
            @Nullable Boolean selected
        )  {
            if (index == null) return null;
            
            if (selected == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifySelectedIndex")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(index)
                            .addParameter(selected)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param index 
         *        the index
         * @param extendSelection 
         *        whether to extend the selection or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param numberOfClicks 
         *        the amount of interactions
         * 
         */
        public Result selectEntryByIndexIndices(
            @Nullable String index,
            @Nullable BinaryChoice extendSelection,
            @Nullable InteractionMode mouseButton,
            @Nullable Integer numberOfClicks
        )  {
            if (index == null) return null;
            
            if (extendSelection == null) return null;
            
            if (mouseButton == null) return null;
            
            if (numberOfClicks == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcSelectIndex")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(index)
                            .addParameter(extendSelection.rcValue())
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(numberOfClicks)
                            .build(), null);
        }
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param searchType 
         *        the search type
         * @param extendSelection 
         *        whether to extend the selection or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param numberOfClicks 
         *        the amount of interactions
         * 
         */
        public Result selectEntryByValueS(
            @Nullable String text,
            @Nullable Operator operator,
            @Nullable SearchType searchType,
            @Nullable BinaryChoice extendSelection,
            @Nullable InteractionMode mouseButton,
            @Nullable Integer numberOfClicks
        )  {
            if (text == null) return null;
            
            if (operator == null) return null;
            
            if (searchType == null) return null;
            
            if (extendSelection == null) return null;
            
            if (mouseButton == null) return null;
            
            if (numberOfClicks == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcSelectValue")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(text)
                            .addParameter(operator.rcValue())
                            .addParameter(searchType.rcValue())
                            .addParameter(extendSelection.rcValue())
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(numberOfClicks)
                            .build(), null);
        }
        
        /**
         * 
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param searchType 
         *        the search type
         * 
         */
        public Result dragEntryByValue(
            @Nullable InteractionMode mouseButton,
            @Nullable Modifier[] modifierKeys,
            @Nullable String text,
            @Nullable Operator operator,
            @Nullable SearchType searchType
        )  {
            if (mouseButton == null) return null;
            
            if (modifierKeys == null) return null;
            
            if (text == null) return null;
            
            if (operator == null) return null;
            
            if (searchType == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcDragValue")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(StringUtils.join(modifierKeys, TestDataConstants.COMBI_VALUE_SEPARATOR))
                            .addParameter(text)
                            .addParameter(operator.rcValue())
                            .addParameter(searchType.rcValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param index 
         *        the index
         * 
         */
        public Result dragEntryByIndex(
            @Nullable InteractionMode mouseButton,
            @Nullable Modifier[] modifierKeys,
            @Nullable Integer index
        )  {
            if (mouseButton == null) return null;
            
            if (modifierKeys == null) return null;
            
            if (index == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcDragIndex")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(StringUtils.join(modifierKeys, TestDataConstants.COMBI_VALUE_SEPARATOR))
                            .addParameter(index)
                            .build(), null);
        }
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param searchType 
         *        the search type
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * 
         */
        public Result dropOnEntryByValue(
            @Nullable String text,
            @Nullable Operator operator,
            @Nullable SearchType searchType,
            @Nullable Integer delayBeforeDropMilliseconds
        )  {
            if (text == null) return null;
            
            if (operator == null) return null;
            
            if (searchType == null) return null;
            
            if (delayBeforeDropMilliseconds == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcDropValue")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(text)
                            .addParameter(operator.rcValue())
                            .addParameter(searchType.rcValue())
                            .addParameter(delayBeforeDropMilliseconds)
                            .build(), null);
        }
        
        /**
         * 
         * @param index 
         *        the index
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * 
         */
        public Result dropOnEntryByIndex(
            @Nullable Integer index,
            @Nullable Integer delayBeforeDropMilliseconds
        )  {
            if (index == null) return null;
            
            if (delayBeforeDropMilliseconds == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcDropIndex")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(index)
                            .addParameter(delayBeforeDropMilliseconds)
                            .build(), null);
        }
        
        /**
         * 
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkPropertyAtMousePosition(
            @Nullable String propertyName,
            @Nullable String propertyValue,
            @Nullable Operator operator,
            @Nullable Integer timeoutInMs
        )  {
            if (propertyName == null) return null;
            
            if (propertyValue == null) return null;
            
            if (operator == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCheckPropertyAtMousePosition")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(propertyName)
                            .addParameter(propertyValue)
                            .addParameter(operator.rcValue())
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param operator 
         *        the operator used for comparison
         * @since 4.1
         */
        public Result checkPropertyAtMousePosition(
            @Nullable String propertyName,
            @Nullable String propertyValue,
            @Nullable Operator operator
        )  {
            if (propertyName == null) return null;
            
            if (propertyValue == null) return null;
            
            if (operator == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCheckPropertyAtMousePosition")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(propertyName)
                            .addParameter(propertyValue)
                            .addParameter(operator.rcValue())
                            .addParameter(0)
                            .build(), null);
        }
        
} 