/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.rcp;

import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.ToolkitInfo;
import org.eclipse.jubula.toolkit.rcp.internal.RcpToolkitInfo;

/**
 * Factory for creating components from the rcp toolkit.
 * @noextend This class is not intended to be extended by clients.
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.FactoryGenerator", 
           date =  "2017-09-15T06:49:19.490Z")
public class RcpComponents {
    
    @NonNull private final static ToolkitInfo TOOLKIT_INFORMATION = RcpToolkit.createToolkitInformation();

    private RcpComponents() {
        super();
    }
    
    /** 
     *  @return the toolkit information, not recommended to be modified
     */
    @NonNull public static ToolkitInfo getToolkitInformation() {
        return TOOLKIT_INFORMATION;
    }

    /** create a new representative for a {@link org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyList} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ListComponent createTabbedPropertyList (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ListComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.rcp.internal.impl.TabbedPropertyList(componentIdentifier);
    }
    
    /** create a new representative for a {@link org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyList} UI component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ListComponentActionHandler createTabbedPropertyListActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ListComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.rcp.internal.impl.handler.TabbedPropertyListActionHandler(componentIdentifier);
    }
}