/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.swt.internal.impl.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Class representing the {@link org.eclipse.swt.widgets.ToolItem} component from the swt toolkit.
 * @since 4.0
 */
@RealizedType(realizedType="guidancer.abstract.SwtItem")
@TesterClass(testerClass="org.eclipse.jubula.rc.swt.tester.ToolItemTester")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2017-09-15T06:49:19.456Z")
public class ToolItemActionHandler extends org.eclipse.jubula.toolkit.swt.internal.impl.handler.ItemActionHandler implements org.eclipse.jubula.toolkit.swt.components.handler.ToolItemActionHandler {
            public ToolItemActionHandler(@NonNull ComponentIdentifier componentIdentifier) {
                super(componentIdentifier);
            }
    
    
        /**
         * 
         * @param menupath 
         *        the menupath
         * @param operator 
         *        the operator used for comparison
         * 
         */
        public Result selectMenuEntryByTextpath(
            @Nullable String menupath,
            @Nullable Operator operator
        )  {
            if (menupath == null) return null;
            
            if (operator == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcSelectContextMenuItem")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(menupath)
                            .addParameter(operator.rcValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * 
         */
        public Result selectMenuEntryByIndexpath(
            @Nullable String indexpath
        )  {
            if (indexpath == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcSelectContextMenuItemByIndexpath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(indexpath)
                            .build(), null);
        }
        
        /**
         * 
         * @param menupath 
         *        the menupath
         * @param operator 
         *        the operator used for comparison
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkEnablementOfEntryByTextpath(
            @Nullable String menupath,
            @Nullable Operator operator,
            @Nullable Boolean enabled,
            @Nullable Integer timeoutInMs
        )  {
            if (menupath == null) return null;
            
            if (operator == null) return null;
            
            if (enabled == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyContextMenuEnabled")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(menupath)
                            .addParameter(operator.rcValue())
                            .addParameter(enabled)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param menupath 
         *        the menupath
         * @param operator 
         *        the operator used for comparison
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @since 4.1
         */
        public Result checkEnablementOfEntryByTextpath(
            @Nullable String menupath,
            @Nullable Operator operator,
            @Nullable Boolean enabled
        )  {
            if (menupath == null) return null;
            
            if (operator == null) return null;
            
            if (enabled == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyContextMenuEnabled")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(menupath)
                            .addParameter(operator.rcValue())
                            .addParameter(enabled)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkEnablementOfEntryByIndexpath(
            @Nullable String indexpath,
            @Nullable Boolean enabled,
            @Nullable Integer timeoutInMs
        )  {
            if (indexpath == null) return null;
            
            if (enabled == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyContextMenuEnabledByIndexpath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(indexpath)
                            .addParameter(enabled)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @since 4.1
         */
        public Result checkEnablementOfEntryByIndexpath(
            @Nullable String indexpath,
            @Nullable Boolean enabled
        )  {
            if (indexpath == null) return null;
            
            if (enabled == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyContextMenuEnabledByIndexpath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(indexpath)
                            .addParameter(enabled)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param menupath 
         *        the menupath
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether the component is expected to exist or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkExistenceOfEntryByTextpath(
            @Nullable String menupath,
            @Nullable Operator operator,
            @Nullable Boolean exists,
            @Nullable Integer timeoutInMs
        )  {
            if (menupath == null) return null;
            
            if (operator == null) return null;
            
            if (exists == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyContextMenuExists")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(menupath)
                            .addParameter(operator.rcValue())
                            .addParameter(exists)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param menupath 
         *        the menupath
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether the component is expected to exist or not
         * @since 4.1
         */
        public Result checkExistenceOfEntryByTextpath(
            @Nullable String menupath,
            @Nullable Operator operator,
            @Nullable Boolean exists
        )  {
            if (menupath == null) return null;
            
            if (operator == null) return null;
            
            if (exists == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyContextMenuExists")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(menupath)
                            .addParameter(operator.rcValue())
                            .addParameter(exists)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param exists 
         *        whether the component is expected to exist or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkExistenceOfEntryByIndexpath(
            @Nullable String indexpath,
            @Nullable Boolean exists,
            @Nullable Integer timeoutInMs
        )  {
            if (indexpath == null) return null;
            
            if (exists == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyContextMenuExistsByIndexpath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(indexpath)
                            .addParameter(exists)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param exists 
         *        whether the component is expected to exist or not
         * @since 4.1
         */
        public Result checkExistenceOfEntryByIndexpath(
            @Nullable String indexpath,
            @Nullable Boolean exists
        )  {
            if (indexpath == null) return null;
            
            if (exists == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyContextMenuExistsByIndexpath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(indexpath)
                            .addParameter(exists)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param menupath 
         *        the menupath
         * @param operator 
         *        the operator used for comparison
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkSelectionOfEntryByTextpath(
            @Nullable String menupath,
            @Nullable Operator operator,
            @Nullable Boolean selected,
            @Nullable Integer timeoutInMs
        )  {
            if (menupath == null) return null;
            
            if (operator == null) return null;
            
            if (selected == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyContextMenuSelected")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(menupath)
                            .addParameter(operator.rcValue())
                            .addParameter(selected)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param menupath 
         *        the menupath
         * @param operator 
         *        the operator used for comparison
         * @param selected 
         *        whether the component is expected to be selected or not
         * @since 4.1
         */
        public Result checkSelectionOfEntryByTextpath(
            @Nullable String menupath,
            @Nullable Operator operator,
            @Nullable Boolean selected
        )  {
            if (menupath == null) return null;
            
            if (operator == null) return null;
            
            if (selected == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyContextMenuSelected")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(menupath)
                            .addParameter(operator.rcValue())
                            .addParameter(selected)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkSelectionOfEntryByIndexpath(
            @Nullable String indexpath,
            @Nullable Boolean selected,
            @Nullable Integer timeoutInMs
        )  {
            if (indexpath == null) return null;
            
            if (selected == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyContextMenuSelectedByIndexpath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(indexpath)
                            .addParameter(selected)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param selected 
         *        whether the component is expected to be selected or not
         * @since 4.1
         */
        public Result checkSelectionOfEntryByIndexpath(
            @Nullable String indexpath,
            @Nullable Boolean selected
        )  {
            if (indexpath == null) return null;
            
            if (selected == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyContextMenuSelectedByIndexpath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(indexpath)
                            .addParameter(selected)
                            .addParameter(0)
                            .build(), null);
        }
        
} 