/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.CapBP;
import org.eclipse.jubula.client.core.businessprocess.UsedToolkitBP;
import org.eclipse.jubula.client.core.businessprocess.progress.ProgressMonitorTracker;
import org.eclipse.jubula.client.core.businessprocess.treeoperations.CollectComponentNameUsersOp;
import org.eclipse.jubula.client.core.datastructure.CompNameUsageMap;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.MultipleNodePM;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.TreeTraverser;
import org.eclipse.jubula.client.ui.handlers.AbstractHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.MultipleTCBTracker;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.dialogs.ReusedProjectSelectionDialog;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.rcp.views.TestCaseBrowser;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.toolkit.common.businessprocess.ToolkitSupportBP;
import org.eclipse.jubula.toolkit.common.exception.ToolkitPluginException;
import org.eclipse.jubula.toolkit.common.utils.ToolkitUtils;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.messagehandling.MessageInfo;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PlatformUI;

public class MoveTestCaseHandler
extends AbstractHandler {
    public Object executeImpl(ExecutionEvent event) {
        TestCaseBrowser tcb = MultipleTCBTracker.getInstance().getMainTCB();
        if (!(tcb.getSelection() instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection sel = (IStructuredSelection)tcb.getSelection();
        List selectionList = sel.toList();
        ArrayList<INodePO> nodesToMove = new ArrayList<INodePO>();
        for (INodePO node : selectionList) {
            MultipleNodePM.collectAffectedNodes(nodesToMove, (INodePO)node);
        }
        if (!this.closeRelatedEditors(nodesToMove)) {
            return null;
        }
        ProblemSet moveProblems = this.getMoveProblem(nodesToMove);
        if (moveProblems.getProblems().isEmpty()) {
            Set reusedProjects = GeneralStorage.getInstance().getProject().getUsedProjects();
            ArrayList<String> projectNamesList = new ArrayList<String>();
            for (IReusedProjectPO project : reusedProjects) {
                projectNamesList.add(project.getName());
            }
            String[] projectNames = projectNamesList.toArray(new String[projectNamesList.size()]);
            ReusedProjectSelectionDialog dialog = this.hasRefDataCube(selectionList) ? new ReusedProjectSelectionDialog(this.getActiveShell(), projectNames, Messages.MoveTestCaseDialogShellTitle, Messages.MoveTestCaseDialogCTDHint, true, "moveTestCaseDialog.gif", Messages.MoveTestCaseDialogShellTitle) : new ReusedProjectSelectionDialog(this.getActiveShell(), projectNames, Messages.MoveTestCaseDialogShellTitle, Messages.MoveTestCaseDialogMessage, "moveTestCaseDialog.gif", Messages.MoveTestCaseDialogShellTitle);
            dialog.setHelpAvailable(true);
            dialog.create();
            DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
            Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.testCaseMoveExternalContextId");
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                String selectedName = dialog.getSelectedName();
                IReusedProjectPO selectedProject = null;
                for (IReusedProjectPO project : reusedProjects) {
                    if (!selectedName.equals(project.getName())) continue;
                    selectedProject = project;
                    break;
                }
                this.doMove(tcb, selectionList, selectedProject);
            }
        } else {
            this.showProblems(moveProblems);
        }
        return null;
    }

    public void setEnabled(boolean enabled) {
        IProjectPO currentProject = GeneralStorage.getInstance().getProject();
        boolean projectAvailable = currentProject == null ? false : !currentProject.getUsedProjects().isEmpty();
        super.setEnabled((Object)(enabled && projectAvailable ? 1 : 0));
    }

    private boolean closeRelatedEditors(List<INodePO> selectionList) {
        ArrayList<IEditorReference> editorsToClose = new ArrayList<IEditorReference>();
        for (INodePO node : selectionList) {
            IEditorReference editor = Utils.getEditorRefByPO((IPersistentObject)node);
            if (editor == null) continue;
            editorsToClose.add(editor);
        }
        return Plugin.getActivePage().closeEditors(editorsToClose.toArray(new IEditorReference[editorsToClose.size()]), true);
    }

    private void doMove(TestCaseBrowser tcb, List<INodePO> selectionList, IReusedProjectPO selectedProject) {
        Persistor per;
        EntityManager sess;
        block17: {
            IProjectPO extProject;
            block15: {
                sess = null;
                per = Persistor.instance();
                extProject = ProjectPM.loadReusedProject((IReusedProjectPO)selectedProject);
                sess = per.openSession();
                per.getTransaction(sess);
                extProject = (IProjectPO)sess.find(extProject.getClass(), (Object)extProject.getId());
                List<ICapPO> moveProblem = this.getMoveProblem(extProject, selectionList);
                if (moveProblem.isEmpty()) break block15;
                ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_MOVE_TO_EXT_PROJ_ERROR_TOOLKITLEVEL, null, null);
                per.dropSession(sess);
                return;
            }
            try {
                INodePO newParent = extProject.getSpecObjCont();
                List<MultipleNodePM.AbstractCmdHandle> commands = this.createCommands(selectionList, newParent, extProject);
                MessageInfo errorMessageInfo = MultipleNodePM.getInstance().executeCommands(commands, sess);
                DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)newParent, DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.all);
                if (errorMessageInfo == null) {
                    block16: {
                        GeneralStorage.getInstance().getMasterSession().refresh((Object)GeneralStorage.getInstance().getProject().getSpecObjCont());
                        Plugin.startLongRunning(Messages.RefreshTSBrowserActionProgressMessage);
                        try {
                            PlatformUI.getWorkbench().getProgressService().run(true, false, (IRunnableWithProgress)new RefreshReusedProjectOperation(selectedProject));
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            Plugin.stopLongRunning();
                            DataEventDispatcher.getInstance().fireProjectStateChanged(DataEventDispatcher.ProjectState.opened);
                            break block16;
                        }
                        catch (InterruptedException interruptedException) {
                            try {
                                Utils.clearClient();
                                break block16;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                Plugin.stopLongRunning();
                                DataEventDispatcher.getInstance().fireProjectStateChanged(DataEventDispatcher.ProjectState.opened);
                            }
                        }
                        Plugin.stopLongRunning();
                        DataEventDispatcher.getInstance().fireProjectStateChanged(DataEventDispatcher.ProjectState.opened);
                    }
                    tcb.getTreeViewer().refresh();
                    break block17;
                }
                ErrorHandlingUtil.createMessageDialog((Integer)errorMessageInfo.getMessageId(), (Object[])errorMessageInfo.getParams(), null);
            }
            catch (JBException e) {
                ErrorHandlingUtil.createMessageDialog((JBException)e, null, null);
                per.dropSession(sess);
            }
            catch (ToolkitPluginException toolkitPluginException) {
                try {
                    ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_GENERAL_TOOLKIT_ERROR);
                }
                catch (Throwable throwable) {
                    per.dropSession(sess);
                    throw throwable;
                }
                per.dropSession(sess);
            }
        }
        per.dropSession(sess);
    }

    private List<ICapPO> getMoveProblem(IProjectPO extProject, List<INodePO> selectionList) throws ToolkitPluginException {
        ArrayList<ICapPO> problemCaps = new ArrayList<ICapPO>();
        String extToolkitId = extProject.getToolkit();
        String extToolkitLevel = ToolkitSupportBP.getToolkitLevel((String)extToolkitId);
        List<ICapPO> caps = this.getCaps(selectionList);
        for (ICapPO cap : caps) {
            String capLevel = UsedToolkitBP.getInstance().getToolkitLevel((INodePO)cap);
            boolean capLessConcrete = !ToolkitUtils.isToolkitMoreConcrete((String)capLevel, (String)extToolkitLevel);
            Component component = CapBP.getComponent((ICapPO)cap);
            String capToolkitID = component.getToolkitDesriptor().getToolkitID();
            if (capLessConcrete || capToolkitID.equals(extToolkitId)) continue;
            problemCaps.add(cap);
        }
        return problemCaps;
    }

    private List<ICapPO> getCaps(List<INodePO> selectionList) {
        ArrayList<ICapPO> caps = new ArrayList<ICapPO>();
        for (INodePO node : selectionList) {
            CapBP.getCaps((INodePO)node, caps);
        }
        return caps;
    }

    private void showProblems(ProblemSet moveProblems) {
        StringBuilder sb = new StringBuilder();
        for (INodePO moveProblem : moveProblems.getProblems()) {
            sb.append(moveProblem.getName());
            sb.append("\n");
        }
        ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_CANNOT_MOVE_TC, null, (String[])new String[]{NLS.bind((String)Messages.InfoDetailCannotMoveTc, (Object)sb.toString())});
    }

    private List<MultipleNodePM.AbstractCmdHandle> createCommands(List<INodePO> selectionList, INodePO newParent, IProjectPO extProject) throws JBException {
        ArrayList<MultipleNodePM.AbstractCmdHandle> commands = new ArrayList<MultipleNodePM.AbstractCmdHandle>();
        CompNameUsageMap usageMap = new CompNameUsageMap();
        IProjectPO currenProject = GeneralStorage.getInstance().getProject();
        Long projId = currenProject.getId();
        for (INodePO selNode : selectionList) {
            commands.add((MultipleNodePM.AbstractCmdHandle)new MultipleNodePM.MoveNodeHandle(selNode, (IPersistentObject)selNode.getParentNode(), (IPersistentObject)newParent));
            ArrayList<INodePO> specTcs = new ArrayList<INodePO>();
            ArrayList<ISpecTestCasePO> specTcPOs = new ArrayList<ISpecTestCasePO>();
            MoveTestCaseHandler.addCatChildren(selNode, specTcs);
            for (INodePO spec : specTcs) {
                ISpecTestCasePO specTestCasePo = (ISpecTestCasePO)spec;
                specTcPOs.add(specTestCasePo);
                CollectComponentNameUsersOp op = new CollectComponentNameUsersOp(projId);
                new TreeTraverser((INodePO)specTestCasePo, (ITreeNodeOperation)op, true, 2).traverse();
                usageMap.addAll(op.getUsageMap());
                for (IExecTestCasePO execTc : NodePM.getInternalExecTestCases((String)specTestCasePo.getGuid(), (long)specTestCasePo.getParentProjectId())) {
                    commands.add((MultipleNodePM.AbstractCmdHandle)new MultipleNodePM.UpdateTestCaseRefHandle(execTc, specTestCasePo));
                }
            }
            commands.add((MultipleNodePM.AbstractCmdHandle)new MultipleNodePM.UpdateParamNamesHandle(specTcPOs, extProject));
        }
        commands.add((MultipleNodePM.AbstractCmdHandle)new MultipleNodePM.TransferCompNameHandle(usageMap, projId, extProject));
        return commands;
    }

    private ProblemSet getMoveProblem(List<INodePO> selectionList) {
        ProblemSet problems = new ProblemSet(selectionList);
        this.getMoveProblem(selectionList, problems);
        return problems;
    }

    private void getMoveProblem(List<INodePO> selectionList, ProblemSet problems) {
        Long cProjId = GeneralStorage.getInstance().getProject().getId();
        for (INodePO node : selectionList) {
            if (node instanceof IExecTestCasePO) {
                ISpecTestCasePO refTestCase = ((IExecTestCasePO)node).getSpecTestCase();
                if (problems.getNodesToMove().contains(refTestCase) || !cProjId.equals(refTestCase.getParentProjectId())) continue;
                problems.getProblems().add((INodePO)refTestCase);
                continue;
            }
            this.getMoveProblem(node.getUnmodifiableNodeList(), problems);
        }
    }

    private boolean hasRefDataCube(List<INodePO> selectionList) {
        for (INodePO selNode : selectionList) {
            ArrayList<INodePO> specTcs = new ArrayList<INodePO>();
            MoveTestCaseHandler.addCatChildren(selNode, specTcs);
            for (INodePO spec : specTcs) {
                if (!(spec instanceof ISpecTestCasePO)) continue;
                ISpecTestCasePO specTestCasePo = (ISpecTestCasePO)spec;
                if (specTestCasePo.getReferencedDataCube() != null) {
                    return true;
                }
                Iterator execTcs = specTestCasePo.getAllNodeIter();
                while (execTcs.hasNext()) {
                    IExecTestCasePO execTestCasePo;
                    INodePO exec = (INodePO)execTcs.next();
                    if (!(exec instanceof IExecTestCasePO) || (execTestCasePo = (IExecTestCasePO)exec).getReferencedDataCube() == null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static void addCatChildren(INodePO parentNode, Collection<INodePO> nodeList) {
        if (parentNode instanceof ICategoryPO) {
            for (INodePO node : parentNode.getUnmodifiableNodeList()) {
                MoveTestCaseHandler.addCatChildren(node, nodeList);
            }
        } else if (parentNode instanceof ISpecTestCasePO) {
            nodeList.add(parentNode);
        }
    }

    private static class ProblemSet {
        private Set<INodePO> m_problems = new HashSet<INodePO>();
        private List<INodePO> m_nodesToMove;

        public ProblemSet(List<INodePO> nodesToMove) {
            this.setNodesToMove(new ArrayList<INodePO>());
            for (INodePO node : nodesToMove) {
                MoveTestCaseHandler.addCatChildren(node, this.getNodesToMove());
            }
        }

        public Set<INodePO> getProblems() {
            return this.m_problems;
        }

        public List<INodePO> getNodesToMove() {
            return this.m_nodesToMove;
        }

        private void setNodesToMove(List<INodePO> nodesToMove) {
            this.m_nodesToMove = nodesToMove;
        }
    }

    private static class RefreshReusedProjectOperation
    implements IRunnableWithProgress {
        private IReusedProjectPO m_selectedProject;

        public RefreshReusedProjectOperation(IReusedProjectPO reusedProject) {
            this.m_selectedProject = reusedProject;
        }

        public void run(IProgressMonitor monitor) {
            monitor.beginTask(Messages.RefreshProjectOperationRefreshing, -1);
            ProgressMonitorTracker instance = ProgressMonitorTracker.SINGLETON;
            instance.setProgressMonitor(monitor);
            try {
                try {
                    IProjectPO referencedProject = ProjectPM.loadReusedProjectInMasterSession((IReusedProjectPO)this.m_selectedProject);
                    GeneralStorage.getInstance().getMasterSession().refresh((Object)referencedProject.getSpecObjCont());
                    DataEventDispatcher.getInstance().fireDataChangedListener(new DataChangedEvent[]{new DataChangedEvent((IPersistentObject)referencedProject, DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.all)});
                }
                catch (ProjectDeletedException projectDeletedException) {
                    PMExceptionHandler.handleProjectDeletedException();
                    instance.setProgressMonitor(null);
                    monitor.done();
                }
                catch (JBException e) {
                    ErrorHandlingUtil.createMessageDialog((JBException)e, null, null);
                    instance.setProgressMonitor(null);
                    monitor.done();
                }
            }
            finally {
                instance.setProgressMonitor(null);
                monitor.done();
            }
        }
    }
}

