/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jubula.client.core.businessprocess.db.NodeBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.provider.DecoratingCellLabelProvider;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.actions.CutTreeItemActionTCBrowser;
import org.eclipse.jubula.client.ui.rcp.actions.PasteTreeItemActionTCBrowser;
import org.eclipse.jubula.client.ui.rcp.controllers.MultipleTCBTracker;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.LocalSelectionClipboardTransfer;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.LocalSelectionTransfer;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.TCBrowserDndSupport;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.TestSpecDropTargetListener;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.TreeViewerContainerDragSourceListener;
import org.eclipse.jubula.client.ui.rcp.provider.contentprovider.TestCaseBrowserContentProvider;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.TestCaseBrowserLabelProvider;
import org.eclipse.jubula.client.ui.rcp.views.AbstractJBTreeView;
import org.eclipse.jubula.client.ui.utils.CommandHelper;
import org.eclipse.jubula.client.ui.views.IJBPart;
import org.eclipse.jubula.client.ui.views.ITreeViewerContainer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class TestCaseBrowser
extends AbstractJBTreeView
implements ITreeViewerContainer,
IJBPart,
DataEventDispatcher.IProblemPropagationListener {
    public static final String NEW_ID = "org.eclipse.ui.NewSubMenu";
    public static final String OPEN_WITH_ID = "org.eclipse.ui.OpenWithSubMenu";
    public static final String ADD_ID = "org.eclipse.ui.AddSubMenu";
    private CutTreeItemActionTCBrowser m_cutTreeItemAction;
    private PasteTreeItemActionTCBrowser m_pasteTreeItemAction;
    private CutAndPasteEnablementListener m_actionListener;
    private final DoubleClickListener m_doubleClickListener = new DoubleClickListener();

    @Override
    public void createPartControl(Composite parent) {
        this.m_cutTreeItemAction = new CutTreeItemActionTCBrowser();
        this.m_pasteTreeItemAction = new PasteTreeItemActionTCBrowser();
        super.createPartControl(parent);
        this.getViewSite().getActionBars().getToolBarManager().add(CommandHelper.createContributionItem((String)"org.eclipse.jubula.client.ui.rcp.commands.SetAsMainViewInstance", null, null, (int)8));
        this.getViewSite().getActionBars().getToolBarManager().add(CommandHelper.createContributionItem((String)"org.eclipse.jubula.client.ui.rcp.commands.CollapseAll", null, null, (int)8));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.getTreeViewer());
        this.getTreeViewer().setContentProvider((IContentProvider)new TestCaseBrowserContentProvider());
        DecoratingCellLabelProvider lp = new DecoratingCellLabelProvider((ILabelProvider)new TestCaseBrowserLabelProvider(), Plugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator());
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)lp);
        int ops = 2;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getInstance()};
        this.getTreeViewer().addDragSupport(ops, transfers, (DragSourceListener)new TreeViewerContainerDragSourceListener(this.getTreeViewer()));
        this.getTreeViewer().addDropSupport(ops, transfers, (DropTargetListener)new TestSpecDropTargetListener(this));
        this.registerContextMenu();
        Plugin.getHelpSystem().setHelp(this.getTreeViewer().getControl(), "org.eclipse.jubula.client.ua.help.testSpecificationViewContextId");
        this.configureActionBars();
        if (GeneralStorage.getInstance().getProject() != null) {
            this.handleProjectLoaded();
        }
        MultipleTCBTracker.getInstance().addTCB(this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.getTreeViewer());
        DataEventDispatcher.getInstance().addProblemPropagationListener((DataEventDispatcher.IProblemPropagationListener)this);
    }

    private void configureActionBars() {
        this.getTreeFilterText().addFocusListener(new FocusListener(){
            private IAction m_defaultCutAction;
            private IAction m_defaultPasteAction;
            {
                this.m_defaultCutAction = TestCaseBrowser.this.getViewSite().getActionBars().getGlobalActionHandler(ActionFactory.CUT.getId());
                this.m_defaultPasteAction = TestCaseBrowser.this.getViewSite().getActionBars().getGlobalActionHandler(ActionFactory.PASTE.getId());
            }

            public void focusGained(FocusEvent e) {
                TestCaseBrowser.this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), this.m_defaultCutAction);
                TestCaseBrowser.this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), this.m_defaultPasteAction);
                TestCaseBrowser.this.getViewSite().getActionBars().updateActionBars();
            }

            public void focusLost(FocusEvent e) {
                TestCaseBrowser.this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)TestCaseBrowser.this.m_cutTreeItemAction);
                TestCaseBrowser.this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)TestCaseBrowser.this.m_pasteTreeItemAction);
                TestCaseBrowser.this.getViewSite().getActionBars().updateActionBars();
            }
        });
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.m_cutTreeItemAction);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.m_pasteTreeItemAction);
        this.getViewSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this.getActionListener());
        this.getViewSite().getActionBars().updateActionBars();
    }

    @Override
    protected void createContextMenu(IMenuManager mgr) {
        mgr.add((IContributionItem)new GroupMarker("defaultTestCaseBrowserMarker"));
    }

    @Override
    protected void addTreeListener() {
        this.getTreeViewer().addDoubleClickListener((IDoubleClickListener)this.m_doubleClickListener);
        this.setActionListener(new CutAndPasteEnablementListener());
    }

    public void setFocus() {
        this.getTreeViewer().getControl().setFocus();
        Plugin.showStatusLine((IWorkbenchPart)this);
    }

    IStructuredSelection getActualSelection() {
        ISelection selection = this.getViewSite().getSelectionProvider().getSelection();
        return selection instanceof IStructuredSelection ? (IStructuredSelection)selection : StructuredSelection.EMPTY;
    }

    @Override
    public void dispose() {
        try {
            DataEventDispatcher ded = DataEventDispatcher.getInstance();
            ded.removeDataChangedListener((DataEventDispatcher.IDataChangedListener)this);
            ded.removeProblemPropagationListener((DataEventDispatcher.IProblemPropagationListener)this);
            this.getViewSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this.getActionListener());
            this.getTreeViewer().removeDoubleClickListener((IDoubleClickListener)this.m_doubleClickListener);
        }
        finally {
            MultipleTCBTracker.getInstance().removeTCB(this);
            super.dispose();
        }
    }

    @Override
    protected void rebuildTree() {
        IProjectPO activeProject = GeneralStorage.getInstance().getProject();
        if (activeProject != null) {
            this.getTreeViewer().setInput((Object)new INodePO[]{activeProject.getSpecObjCont()});
            this.getTreeViewer().expandToLevel(2);
        } else {
            this.getTreeViewer().setInput(null);
        }
    }

    @Override
    public void handleDataChanged(final IPersistentObject po, final DataEventDispatcher.DataState dataState, final DataEventDispatcher.UpdateState updateState) {
        Plugin.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (po instanceof IAUTMainPO || po instanceof ITestSuitePO) {
                    return;
                }
                if (updateState == DataEventDispatcher.UpdateState.onlyInEditor) {
                    return;
                }
                if (po instanceof IReusedProjectPO) {
                    TestCaseBrowser.this.handleProjectLoaded();
                    return;
                }
                switch (dataState) {
                    case Added: {
                        TestCaseBrowser.this.handleDataAdded(po, (IProgressMonitor)new NullProgressMonitor());
                        break;
                    }
                    case Deleted: {
                        TestCaseBrowser.this.handleDataDeleted(po);
                        break;
                    }
                    case Renamed: {
                        TestCaseBrowser.this.handleDataRenamed(po);
                        break;
                    }
                    case StructureModified: {
                        TestCaseBrowser.this.handleDataStructureModified(po);
                        break;
                    }
                }
            }
        });
    }

    private void handleDataStructureModified(IPersistentObject po) {
        if (po instanceof INodePO) {
            TreeViewer tv = this.getTreeViewer();
            try {
                tv.getTree().getParent().setRedraw(false);
                Object[] expandedElements = tv.getExpandedElements();
                ISelection selection = tv.getSelection();
                if (po instanceof IProjectPO) {
                    this.rebuildTree();
                }
                tv.refresh();
                tv.setExpandedElements(expandedElements);
                tv.setSelection(selection);
            }
            finally {
                tv.getTree().getParent().setRedraw(true);
            }
        }
    }

    private void handleDataRenamed(IPersistentObject po) {
        if (po instanceof ISpecTestCasePO || po instanceof ICategoryPO || po instanceof IExecTestCasePO) {
            this.getTreeViewer().refresh(true);
        }
    }

    private void handleDataDeleted(IPersistentObject po) {
        if (po instanceof ISpecTestCasePO || po instanceof ICategoryPO) {
            if (this.getTreeViewer() != null) {
                Plugin.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        TestCaseBrowser.this.getTreeViewer().refresh();
                    }
                });
            }
        } else if (po instanceof IProjectPO) {
            Plugin.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    TestCaseBrowser.this.getTreeViewer().setInput(null);
                    TestCaseBrowser.this.getTreeViewer().refresh();
                }
            });
        }
    }

    private void handleDataAdded(IPersistentObject po, IProgressMonitor monitor) {
        if (po instanceof ISpecTestCasePO || po instanceof ICategoryPO) {
            this.getTreeViewer().refresh();
            this.getTreeViewer().expandToLevel(this.getTreeViewer().getAutoExpandLevel());
            this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)po), true);
        } else if (po instanceof IProjectPO) {
            this.handleProjectLoaded();
        }
    }

    public void setViewTitle(String title) {
        super.setPartName(title);
    }

    public CutAndPasteEnablementListener getActionListener() {
        return this.m_actionListener;
    }

    private void setActionListener(CutAndPasteEnablementListener actionListener) {
        this.m_actionListener = actionListener;
    }

    public void problemPropagationFinished() {
        PlatformUI.getWorkbench();
        Plugin.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                TestCaseBrowser.this.getTreeViewer().refresh();
            }
        });
    }

    public final class CutAndPasteEnablementListener
    implements ISelectionListener {
        private void enableCutAction(INodePO[] selList) {
            TestCaseBrowser.this.m_cutTreeItemAction.setEnabled(false);
            INodePO[] iNodePOArray = selList;
            int n = selList.length;
            int n2 = 0;
            while (n2 < n) {
                INodePO guiNode = iNodePOArray[n2];
                if (!(guiNode instanceof ICategoryPO) && !(guiNode instanceof ISpecTestCasePO) || !NodeBP.isEditable((IPersistentObject)guiNode) || guiNode.isExecObjCont() || guiNode.isSpecObjCont()) {
                    TestCaseBrowser.this.m_cutTreeItemAction.setEnabled(false);
                    return;
                }
                ++n2;
            }
            TestCaseBrowser.this.m_cutTreeItemAction.setEnabled(true);
        }

        private void enablePasteAction(INodePO[] selList) {
            TestCaseBrowser.this.m_pasteTreeItemAction.setEnabled(false);
            Object cbContents = TestCaseBrowser.this.getClipboard().getContents((Transfer)LocalSelectionClipboardTransfer.getInstance());
            INodePO[] iNodePOArray = selList;
            int n = selList.length;
            int n2 = 0;
            while (n2 < n) {
                INodePO node = iNodePOArray[n2];
                if (!((node instanceof ICategoryPO || node instanceof ISpecTestCasePO || node instanceof IProjectPO) && NodeBP.isEditable((IPersistentObject)node) && cbContents instanceof IStructuredSelection && TCBrowserDndSupport.canMove((IStructuredSelection)cbContents, node))) {
                    TestCaseBrowser.this.m_pasteTreeItemAction.setEnabled(false);
                    return;
                }
                ++n2;
            }
            TestCaseBrowser.this.m_pasteTreeItemAction.setEnabled(true);
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            boolean isNullProject;
            if (!(selection instanceof IStructuredSelection)) {
                return;
            }
            boolean isThisPart = part == TestCaseBrowser.this;
            boolean bl = isNullProject = GeneralStorage.getInstance().getProject() == null;
            if (isNullProject || selection == null || selection.isEmpty()) {
                TestCaseBrowser.this.m_cutTreeItemAction.setEnabled(false);
                TestCaseBrowser.this.m_pasteTreeItemAction.setEnabled(false);
                return;
            }
            if (isThisPart) {
                IStructuredSelection sel = (IStructuredSelection)selection;
                Object[] selectedElements = sel.toArray();
                INodePO[] selectedNodes = new INodePO[selectedElements.length];
                int i = 0;
                while (i < selectedElements.length) {
                    if (!(selectedElements[i] instanceof INodePO)) {
                        TestCaseBrowser.this.m_cutTreeItemAction.setEnabled(false);
                        TestCaseBrowser.this.m_pasteTreeItemAction.setEnabled(false);
                        return;
                    }
                    selectedNodes[i] = (INodePO)selectedElements[i];
                    ++i;
                }
                this.enableCutAction(selectedNodes);
                this.enablePasteAction(selectedNodes);
            }
        }
    }

    private final class DoubleClickListener
    implements IDoubleClickListener {
        private DoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            IStructuredSelection selection = TestCaseBrowser.this.getActualSelection();
            Object firstElement = selection.getFirstElement();
            String commandId = firstElement instanceof ICategoryPO ? "org.eclipse.jubula.client.ui.rcp.commands.NewTestCaseCommand" : (firstElement instanceof IExecTestCasePO ? "org.eclipse.jubula.client.ui.commands.OpenSpecification" : "org.eclipse.jubula.client.ui.rcp.commands.OpenTestcaseEditor");
            CommandHelper.executeCommand((String)commandId, (IWorkbenchPartSite)TestCaseBrowser.this.getSite());
        }
    }
}

