/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.widgets;

import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jubula.client.core.businessprocess.CalcTypes;
import org.eclipse.jubula.client.core.businessprocess.CompNameManager;
import org.eclipse.jubula.client.core.businessprocess.CompNamesBP;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.dialogs.CNTypeProblemDialog;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractTestCaseEditor;
import org.eclipse.jubula.client.ui.rcp.editors.IJBEditor;
import org.eclipse.jubula.client.ui.rcp.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.rcp.editors.TestSuiteEditor;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.widgets.CompNamePopupTextCellEditor;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.tools.internal.i18n.CompSystemI18n;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPart;

public class ComponentNamesTableComposite
extends Composite
implements DataEventDispatcher.IDataChangedListener,
DisposeListener {
    private static final String COLUMN_PROPAGATE = "propagate";
    private static final String COLUMN_OLD_NAME = "firstName";
    private static final String COLUMN_NEW_NAME = "secondName";
    private static final String COLUMN_TYPE_NAME = "type";
    private static final int COLUMN_WIDTH = 70;
    private static final int NEW_NAME_COLUMN_WIDTH = 190;
    private CheckboxTableViewer m_tableViewer;
    private CellModifier m_cellModifier;
    private CompNamesBP m_compNamesBP = new CompNamesBP();
    private boolean m_invalidData = false;
    private IExecTestCasePO m_selectedExecNode;
    private IWorkbenchPart m_selectedExecNodeOwner;
    private ICompNamesPairPO m_selectedPair = null;
    private boolean m_editable;
    private CellEditorListener m_cellEditorListener = new CellEditorListener();
    private TableSelectionChangedListener m_selectionChangedListener = new TableSelectionChangedListener();
    private CompNamePopupTextCellEditor m_cellEdit;
    private CheckStateListener m_checkStateListener = new CheckStateListener();
    private IComponentNameCache m_compCache;

    public ComponentNamesTableComposite(Composite parent, int style) {
        super(parent, style);
        this.addDisposeListener(this);
        this.setLayout(this);
        Table table = new Table((Composite)this, 67616);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        TableColumn tc1 = new TableColumn(table, 0x1000000);
        tc1.setImage(IconConstants.PROPAGATE_IMAGE);
        TableColumn tc2 = new TableColumn(table, 16384);
        tc2.setText(Messages.CompNamesViewOldNameColumn);
        TableColumn tc3 = new TableColumn(table, 16384);
        tc3.setText(Messages.CompNamesViewNewNameColumn);
        TableColumn tc4 = new TableColumn(table, 16384);
        tc4.setText(Messages.CompNamesViewTypeColumn);
        ComponentNamesTableCompositeContentProvider provider = new ComponentNamesTableCompositeContentProvider();
        this.m_tableViewer = new CheckboxTableViewer(table);
        this.m_tableViewer.setContentProvider((IContentProvider)provider);
        this.m_tableViewer.setLabelProvider((IBaseLabelProvider)new ComponentNamesTableCompositeLabelProvider());
        this.m_tableViewer.setColumnProperties(new String[]{COLUMN_PROPAGATE, COLUMN_OLD_NAME, COLUMN_NEW_NAME, COLUMN_TYPE_NAME});
        this.setCompCache(Plugin.getActiveCompCache());
        this.setCellEdit(new CompNamePopupTextCellEditor(this.getCompCache(), (Composite)table));
        CellEditor[] cellEditorArray = new CellEditor[4];
        cellEditorArray[2] = this.getCellEdit();
        this.m_tableViewer.setCellEditors(cellEditorArray);
        this.setCellModifier(new CellModifier());
        this.m_tableViewer.setCellModifier((ICellModifier)this.getCellModifier());
        this.handleListenersAndResources(true);
        Plugin.getHelpSystem().setHelp((Control)this, "org.eclipse.jubula.client.ua.help.compNameViewContextId");
        this.setSelectedExecNode(null);
        this.setSelectedExecNodeOwner(null);
    }

    private void searchAndSetComponentType(List<ICompNamesPairPO> cNPairs, ISpecTestCasePO spec) {
        CompNameManager cache;
        if (cNPairs.isEmpty()) {
            return;
        }
        if (this.getSelectedExecNodeOwner() instanceof IJBEditor) {
            EditSupport supp = ((IJBEditor)this.getSelectedExecNodeOwner()).getEditorHelper().getEditSupport();
            if (supp == null) {
                return;
            }
            cache = supp.getCache();
        } else {
            cache = CompNameManager.getInstance();
        }
        CalcTypes calc = new CalcTypes((IComponentNameCache)cache, null);
        calc.calculateLocalType((INodePO)spec, null);
        Map locMap = calc.getLocalPropTypes((INodePO)spec);
        for (ICompNamesPairPO pair : cNPairs) {
            pair.setType((String)locMap.get(CompNameManager.getInstance().resolveGuid(pair.getFirstName())));
        }
    }

    private void setLayout(Composite c) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        c.setLayout((Layout)layout);
        GridData layoutData = new GridData(1808);
        layoutData.grabExcessHorizontalSpace = true;
        c.setLayoutData((Object)layoutData);
    }

    private void updateTableInput() {
        boolean editable = false;
        IExecTestCasePO exec = this.getSelectedExecNode();
        if (this.getSelectedExecNodeOwner() instanceof AbstractTestCaseEditor) {
            editable = true;
            INodePO cfr_ignored_0 = (INodePO)((AbstractTestCaseEditor)this.getSelectedExecNodeOwner()).getEditorHelper().getEditSupport().getWorkVersion();
        }
        List input = null;
        if (exec != null) {
            ISpecTestCasePO spec;
            input = this.m_compNamesBP.getAllCompNamesPairs(exec);
            IWorkbenchPart activePart = Plugin.getActivePart();
            if (activePart instanceof IJBEditor) {
                this.setCompCache((IComponentNameCache)((IJBEditor)activePart).getCompNameCache());
            }
            if ((spec = exec.getSpecTestCase()) != null) {
                this.searchAndSetComponentType(input, spec);
            }
        }
        this.m_tableViewer.setInput(input);
        this.m_editable = editable;
        TableItem[] tableItemArray = this.m_tableViewer.getTable().getItems();
        int n = tableItemArray.length;
        int spec = 0;
        while (spec < n) {
            TableItem item = tableItemArray[spec];
            if (editable) {
                item.setForeground(LayoutUtil.DEFAULT_OS_COLOR);
            } else {
                item.setForeground(LayoutUtil.GRAY_COLOR);
            }
            item.setGrayed(!editable);
            ++spec;
        }
        Table table = this.m_tableViewer.getTable();
        if (table.getItemCount() != 0) {
            TableColumn[] columns = table.getColumns();
            int columnCount = columns.length;
            int i = 1;
            while (i < columnCount) {
                TableColumn column = columns[i];
                column.pack();
                if (column.getWidth() < 70) {
                    column.setWidth(70);
                }
                ++i;
            }
            for (ICompNamesPairPO pair : input) {
                this.m_tableViewer.setChecked((Object)pair, pair.isPropagated());
            }
            TableColumn propagationColumn = table.getColumn(0);
            propagationColumn.setResizable(false);
            propagationColumn.setWidth(38);
            TableColumn newNameColumn = table.getColumn(2);
            if (newNameColumn.getWidth() < 190) {
                newNameColumn.setWidth(190);
            }
        }
        this.controlPropagation(editable);
    }

    private void updatePropagated(ICompNamesPairPO pair, boolean propagated) {
        if (this.getSelectedExecNodeOwner() instanceof IJBEditor) {
            IExecTestCasePO exec = this.getSelectedExecNode();
            if (exec == null) {
                return;
            }
            pair.setPropagated(propagated);
            if (exec.getCompNamesPair(pair.getFirstName()) == null) {
                exec.addCompNamesPair(pair);
            }
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)this.getSelectedExecNode(), DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
        }
    }

    private void updateSecondName(ICompNamesPairPO pair, String secondName) {
        String oldName;
        if (this.getInvalidData() || !(this.getSelectedExecNodeOwner() instanceof IJBEditor) || this.getSelectedExecNode() == null) {
            return;
        }
        if (secondName == null || secondName.length() == 0) {
            return;
        }
        AbstractTestCaseEditor editor = (AbstractTestCaseEditor)this.getSelectedExecNodeOwner();
        IWritableComponentNameCache cache = editor.getCompNameCache();
        IComponentNamePO cN = cache.getResCompNamePOByGuid(oldName = pair.getSecondName());
        if (cN != null) {
            oldName = cN.getName();
        }
        INodePO root = (INodePO)editor.getEditorHelper().getEditSupport().getWorkVersion();
        this.m_compNamesBP.updateCompNamesPairNew(this.getSelectedExecNode(), pair, secondName, cache);
        this.setInvalidData(true);
        if (!CNTypeProblemDialog.noProblemOrIgnore(cache, root)) {
            this.m_compNamesBP.updateCompNamesPairNew(this.getSelectedExecNode(), pair, oldName, cache);
            return;
        }
        this.setInvalidData(false);
        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)this.getSelectedExecNode(), DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
    }

    private void setInvalidData(boolean invalidData) {
        this.m_invalidData = invalidData;
    }

    private boolean getInvalidData() {
        return this.m_invalidData;
    }

    public boolean setFocus() {
        return this.m_tableViewer.getTable().setFocus();
    }

    public void setSelectedExecNode(IExecTestCasePO selectedExecNode) {
        this.m_selectedExecNode = selectedExecNode;
        this.updateTableInput();
    }

    private IExecTestCasePO getSelectedExecNode() {
        return this.m_selectedExecNode;
    }

    public void setSelectedExecNodeOwner(IWorkbenchPart selectedExecNodeOwner) {
        this.m_selectedExecNodeOwner = selectedExecNodeOwner;
    }

    private IWorkbenchPart getSelectedExecNodeOwner() {
        return this.m_selectedExecNodeOwner;
    }

    private void setCellModifier(CellModifier cellModifier) {
        this.m_cellModifier = cellModifier;
    }

    private CellModifier getCellModifier() {
        return this.m_cellModifier;
    }

    public void controlPropagation(boolean allow) {
        this.getCellModifier().setModifiable(allow);
    }

    private void setCompCache(IComponentNameCache compCache) {
        this.m_compCache = compCache;
    }

    private IComponentNameCache getCompCache() {
        return this.m_compCache;
    }

    private void setCellEdit(CompNamePopupTextCellEditor cellEdit) {
        this.m_cellEdit = cellEdit;
    }

    public CompNamePopupTextCellEditor getCellEdit() {
        return this.m_cellEdit;
    }

    public void handleDataChanged(final DataChangedEvent ... events) {
        Plugin.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                DataChangedEvent[] dataChangedEventArray = events;
                int n = events.length;
                int n2 = 0;
                while (n2 < n) {
                    DataChangedEvent e = dataChangedEventArray[n2];
                    ComponentNamesTableComposite.this.handleDataChanged(e.getPo(), e.getDataState());
                    ++n2;
                }
            }
        });
    }

    public void handleDataChanged(IPersistentObject po, DataEventDispatcher.DataState dataState) {
        IExecTestCasePO exec = this.getSelectedExecNode();
        if (po != null && exec != null && po.equals(exec.getSpecAncestor())) {
            this.updateTableInput();
            return;
        }
        if (po instanceof IExecTestCasePO || po instanceof ISpecTestCasePO || po instanceof IComponentNamePO || po instanceof ICompNamesPairPO) {
            this.m_tableViewer.refresh();
        }
    }

    private void handleListenersAndResources(boolean add) {
        if (add) {
            this.getCellEdit().addListener(this.m_cellEditorListener);
            this.m_tableViewer.addCheckStateListener((ICheckStateListener)this.m_checkStateListener);
            this.m_tableViewer.addSelectionChangedListener((ISelectionChangedListener)this.m_selectionChangedListener);
            DataEventDispatcher.getInstance().addDataChangedListener((DataEventDispatcher.IDataChangedListener)this, true);
            return;
        }
        this.getCellEdit().removeListener(this.m_cellEditorListener);
        this.m_tableViewer.removeCheckStateListener((ICheckStateListener)this.m_checkStateListener);
        this.m_tableViewer.removeSelectionChangedListener((ISelectionChangedListener)this.m_selectionChangedListener);
        this.m_tableViewer = null;
        DataEventDispatcher.getInstance().removeDataChangedListener((DataEventDispatcher.IDataChangedListener)this);
    }

    public void widgetDisposed(DisposeEvent e) {
        this.handleListenersAndResources(false);
    }

    private final class CellEditorListener
    implements ICellEditorListener {
        private CellEditorListener() {
        }

        public void applyEditorValue() {
            String newName;
            Object value = ComponentNamesTableComposite.this.getCellEdit().getValue();
            String string = newName = value != null ? value.toString() : "";
            if (ComponentNamesTableComposite.this.getCellEdit().isDirty()) {
                ComponentNamesTableComposite.this.updateSecondName(ComponentNamesTableComposite.this.m_selectedPair, newName);
            }
        }

        public void cancelEditor() {
        }

        public void editorValueChanged(boolean oldValidState, boolean newValidState) {
        }
    }

    private final class CellModifier
    implements ICellModifier {
        private boolean m_modifiable = true;

        private CellModifier() {
        }

        private ICompNamesPairPO getPair(Object element) {
            return (ICompNamesPairPO)(element instanceof Item ? ((Item)element).getData() : element);
        }

        public boolean canModify(Object element, String property) {
            boolean editable = false;
            if (ComponentNamesTableComposite.this.getSelectedExecNodeOwner() instanceof AbstractTestCaseEditor && ((AbstractTestCaseEditor)ComponentNamesTableComposite.this.getSelectedExecNodeOwner()).getEditorHelper().requestEditableState() == JBEditorHelper.EditableState.OK) {
                editable = true;
            }
            if (editable && element instanceof ICompNamesPairPO) {
                ICompNamesPairPO compNamesPair = (ICompNamesPairPO)element;
                return ComponentNamesTableComposite.COLUMN_NEW_NAME.equals(property) && this.isModifiable() && CompNamesBP.isValidCompNamePair((ICompNamesPairPO)compNamesPair);
            }
            return false;
        }

        public Object getValue(Object element, String property) {
            if (ComponentNamesTableComposite.this.getCompCache() != null) {
                return ComponentNamesTableComposite.this.getCompCache().getNameByGuid(this.getPair(element).getSecondName());
            }
            return CompNameManager.getInstance().getNameByGuid(this.getPair(element).getSecondName());
        }

        public void modify(Object element, String property, Object value) {
        }

        public void setModifiable(boolean modifiable) {
            this.m_modifiable = modifiable;
        }

        public boolean isModifiable() {
            return this.m_modifiable;
        }
    }

    private final class CheckStateListener
    implements ICheckStateListener {
        private CheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            boolean editable = false;
            if (ComponentNamesTableComposite.this.getSelectedExecNodeOwner() instanceof AbstractTestCaseEditor && ((AbstractTestCaseEditor)ComponentNamesTableComposite.this.getSelectedExecNodeOwner()).getEditorHelper().requestEditableState() == JBEditorHelper.EditableState.OK) {
                editable = true;
            }
            if (editable) {
                ICompNamesPairPO pair = (ICompNamesPairPO)event.getElement();
                ComponentNamesTableComposite.this.getCellModifier().setModifiable(ComponentNamesTableComposite.this.m_editable && !"".equals(pair.getType()));
                if (!ComponentNamesTableComposite.this.getCellModifier().isModifiable() || ComponentNamesTableComposite.this.getSelectedExecNodeOwner() instanceof TestSuiteEditor) {
                    ComponentNamesTableComposite.this.m_tableViewer.setChecked((Object)pair, pair.isPropagated());
                    return;
                }
                ComponentNamesTableComposite.this.updatePropagated(pair, event.getChecked());
            }
        }
    }

    private class ComponentNamesTableCompositeContentProvider
    implements IStructuredContentProvider {
        private ComponentNamesTableCompositeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ComponentNamesTableCompositeLabelProvider
    implements ITableLabelProvider {
        private ComponentNamesTableCompositeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            String type = ((ICompNamesPairPO)element).getType();
            switch (columnIndex) {
                case 0: {
                    if ("".equals(type)) {
                        ComponentNamesTableComposite.this.m_tableViewer.getTable().getColumn(0).pack();
                        return IconConstants.WARNING_IMAGE;
                    }
                    return null;
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ICompNamesPairPO pair = (ICompNamesPairPO)element;
            Table table = ComponentNamesTableComposite.this.m_tableViewer.getTable();
            switch (columnIndex) {
                case 0: {
                    return "";
                }
                case 1: {
                    if (ComponentNamesTableComposite.this.getCompCache() != null) {
                        return ComponentNamesTableComposite.this.getCompCache().getNameByGuid(pair.getFirstName());
                    }
                    return CompNameManager.getInstance().getNameByGuid(pair.getFirstName());
                }
                case 2: {
                    if (ComponentNamesTableComposite.this.getCompCache() != null) {
                        return ComponentNamesTableComposite.this.getCompCache().getNameByGuid(pair.getSecondName());
                    }
                    return CompNameManager.getInstance().getNameByGuid(pair.getSecondName());
                }
                case 3: {
                    String type = pair.getType();
                    int i = 0;
                    while (i < table.getItems().length) {
                        if (table.getItems()[i].getData() != null && table.getItems()[i].getData().equals(pair)) {
                            TableItem item;
                            if ("".equals(type)) {
                                type = "CompNamesView.errorText";
                                item = table.getItem(i);
                                item.setForeground(3, item.getDisplay().getSystemColor(3));
                                item.setFont(3, LayoutUtil.ITALIC_TAHOMA);
                                if (ComponentNamesTableComposite.this.getSelectedExecNodeOwner() instanceof AbstractTestCaseEditor) {
                                    ComponentNamesTableComposite.this.m_tableViewer.setGrayed((Object)pair, false);
                                    ComponentNamesTableComposite.this.m_tableViewer.setChecked((Object)pair, false);
                                }
                            } else {
                                item = table.getItem(i);
                                item.setForeground(3, LayoutUtil.GRAY_COLOR);
                                item.setFont(3, LayoutUtil.NORMAL_TAHOMA);
                                if (ComponentNamesTableComposite.this.getSelectedExecNodeOwner() instanceof AbstractTestCaseEditor) {
                                    item.setForeground(3, LayoutUtil.DEFAULT_OS_COLOR);
                                    ComponentNamesTableComposite.this.m_tableViewer.setGrayed((Object)pair, true);
                                    ComponentNamesTableComposite.this.m_tableViewer.setChecked((Object)pair, true);
                                }
                            }
                        }
                        ++i;
                    }
                    return CompSystemI18n.getString((String)type);
                }
            }
            return null;
        }
    }

    private class TableSelectionChangedListener
    implements ISelectionChangedListener {
        private TableSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (!(event.getSelection() instanceof IStructuredSelection)) {
                return;
            }
            Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (!(o instanceof ICompNamesPairPO) || !(ComponentNamesTableComposite.this.getSelectedExecNodeOwner() instanceof AbstractTestCaseEditor)) {
                ComponentNamesTableComposite.this.m_selectedPair = null;
                return;
            }
            IWritableComponentNameCache cache = ((AbstractTestCaseEditor)ComponentNamesTableComposite.this.getSelectedExecNodeOwner()).getCompNameCache();
            ICompNamesPairPO pair = (ICompNamesPairPO)o;
            ComponentNamesTableComposite.this.m_selectedPair = pair;
            ComponentNamesTableComposite.this.getCellModifier().setModifiable(ComponentNamesTableComposite.this.m_editable && !"".equals(pair.getType()));
            if (!ComponentNamesTableComposite.this.getCellModifier().isModifiable()) {
                return;
            }
            CalcTypes calc = new CalcTypes((IComponentNameCache)cache, null);
            String filter = calc.calculateLocalType((INodePO)ComponentNamesTableComposite.this.getSelectedExecNode().getSpecTestCase(), pair.getFirstName());
            ComponentNamesTableComposite.this.getCellEdit().setFilter(filter);
            ComponentNamesTableComposite.this.setInvalidData(false);
        }
    }
}

