/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.tester;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.driver.CheckWithTimeoutQueuer;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.DragAndDropHelper;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.exception.StepVerifyFailedException;
import org.eclipse.jubula.rc.common.implclasses.tree.AbstractTreeNodeTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.AbstractTreeOperationContext;
import org.eclipse.jubula.rc.common.implclasses.tree.ChildTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.ExpandCollapseTreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.INodePath;
import org.eclipse.jubula.rc.common.implclasses.tree.IndexNodePath;
import org.eclipse.jubula.rc.common.implclasses.tree.ParentTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.PathBasedTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.SelectTreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.SiblingTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.StringNodePath;
import org.eclipse.jubula.rc.common.implclasses.tree.TreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.TreeNodeOperationConstraint;
import org.eclipse.jubula.rc.common.tester.WidgetTester;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.ITreeComponent;
import org.eclipse.jubula.rc.common.util.IndexConverter;
import org.eclipse.jubula.rc.common.util.Verifier;
import org.eclipse.jubula.toolkit.enums.ValueSets;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;
import org.eclipse.jubula.tools.internal.objects.event.TestErrorEvent;
import org.eclipse.jubula.tools.internal.utils.StringParsing;

public abstract class AbstractTreeTester
extends WidgetTester {
    public String[] getTextArrayFromComponent() {
        return null;
    }

    protected ITreeComponent getTreeAdapter() {
        return (ITreeComponent)this.getComponent();
    }

    public void rcVerifyTextAtMousePosition(final String text, final String operator, int timeout) {
        CheckWithTimeoutQueuer.invokeAndWait("rcVerifyTextAtMousePosition", timeout, new Runnable(){

            public void run() {
                AbstractTreeTester.this.checkNodeText(new Object[]{AbstractTreeTester.this.getNodeAtMousePosition()}, text, operator);
            }
        });
    }

    protected String[] splitTextTreePath(String treePath) {
        return StringParsing.splitToArray((String)treePath, (char)'/', (char)'\\', (boolean)true);
    }

    protected Integer[] splitIndexTreePath(String treePath) throws StepExecutionException {
        Integer[] indexPath = null;
        String[] path = this.splitTextTreePath(treePath);
        if (path != null) {
            indexPath = new Integer[path.length];
            int i = 0;
            while (i < path.length) {
                indexPath[i] = new Integer(IndexConverter.intValue(path[i]));
                ++i;
            }
        }
        return IndexConverter.toImplementationIndices(indexPath);
    }

    protected INodePath createStringNodePath(String[] treePath, String operator) {
        return new StringNodePath(treePath, operator);
    }

    protected INodePath createIndexNodePath(Integer[] treePath) {
        return new IndexNodePath(treePath);
    }

    protected void traverseTreeByPath(INodePath treePath, String pathType, int preAscend, TreeNodeOperation operation) throws StepExecutionException {
        Validate.notNull((Object)treePath);
        Validate.notNull((Object)operation);
        ITreeComponent adapter = this.getTreeAdapter();
        AbstractTreeOperationContext context = adapter.getContext();
        PathBasedTraverser traverser = new PathBasedTraverser(context, treePath);
        ((AbstractTreeNodeTraverser)traverser).traversePath(operation, this.getStartNode(pathType, preAscend, context));
    }

    protected void traverseLastElementByPath(INodePath treePath, String pathType, int preAscend, TreeNodeOperation operation) throws StepExecutionException {
        Validate.notNull((Object)treePath);
        Validate.notNull((Object)operation);
        AbstractTreeOperationContext context = this.getTreeAdapter().getContext();
        Object startNode = this.getStartNode(pathType, preAscend, context);
        PathBasedTraverser traverser = new PathBasedTraverser(context, treePath, new TreeNodeOperationConstraint());
        ((AbstractTreeNodeTraverser)traverser).traversePath(operation, startNode);
    }

    private void selectByPath(String pathType, int preAscend, INodePath objectPath, ClickOptions co) {
        ExpandCollapseTreeNodeOperation expOp = new ExpandCollapseTreeNodeOperation(false);
        SelectTreeNodeOperation selectOp = new SelectTreeNodeOperation(co);
        INodePath subPath = objectPath.subPath(0, objectPath.getLength() - 1);
        this.traverseTreeByPath(subPath, pathType, preAscend, expOp);
        this.traverseLastElementByPath(objectPath, pathType, preAscend, selectOp);
    }

    protected Object getSelectedNode(AbstractTreeOperationContext context) {
        return context.getSelectedNode();
    }

    public void rcClick(int count, int button) {
        if (this.getRobot().isMouseInComponent(this.getTreeAdapter().getRealComponent())) {
            this.getRobot().clickAtCurrentPosition(this.getTreeAdapter().getRealComponent(), count, button);
        } else {
            this.getRobot().click(this.getTreeAdapter().getRealComponent(), null, ClickOptions.create().setClickCount(count).setMouseButton(button));
        }
    }

    public void rcCollapse(String pathType, int preAscend, String treePath, String operator) throws StepExecutionException {
        this.traverseLastElementByPath(this.createStringNodePath(this.splitTextTreePath(treePath), operator), pathType, preAscend, new ExpandCollapseTreeNodeOperation(true));
    }

    public void rcCollapseByIndices(String pathType, int preAscend, String indexPath) throws StepExecutionException {
        try {
            this.traverseLastElementByPath(this.createIndexNodePath(this.splitIndexTreePath(indexPath)), pathType, preAscend, new ExpandCollapseTreeNodeOperation(true));
        }
        catch (NumberFormatException e) {
            throw new StepExecutionException(e.getMessage(), EventFactory.createActionError((String)"TestErrorEvent.InvalidIndex"));
        }
    }

    public void rcExpand(String pathType, int preAscend, String treePath, String operator) throws StepExecutionException {
        this.traverseTreeByPath(this.createStringNodePath(this.splitTextTreePath(treePath), operator), pathType, preAscend, new ExpandCollapseTreeNodeOperation(false));
    }

    public void rcExpandByIndices(String pathType, int preAscend, String indexPath) throws StepExecutionException {
        try {
            this.traverseTreeByPath(this.createIndexNodePath(this.splitIndexTreePath(indexPath)), pathType, preAscend, new ExpandCollapseTreeNodeOperation(false));
        }
        catch (NumberFormatException e) {
            throw new StepExecutionException(e.getMessage(), EventFactory.createActionError((String)"TestErrorEvent.InvalidIndex"));
        }
    }

    public void rcMove(String direction, int distance, int clickCount) throws StepExecutionException {
        AbstractTreeOperationContext context = this.getTreeAdapter().getContext();
        Object selectedNode = this.getSelectedNode(context);
        SelectTreeNodeOperation selectOp = new SelectTreeNodeOperation(ClickOptions.create().setClickCount(clickCount));
        TreeNodeOperationConstraint constraint = new TreeNodeOperationConstraint();
        if (ValueSets.TreeDirection.up.rcValue().equalsIgnoreCase(direction)) {
            ParentTraverser traverser = new ParentTraverser(context, distance, constraint);
            ((AbstractTreeNodeTraverser)traverser).traversePath(selectOp, selectedNode);
        } else if (ValueSets.TreeDirection.down.rcValue().equalsIgnoreCase(direction)) {
            ExpandCollapseTreeNodeOperation expandOp = new ExpandCollapseTreeNodeOperation(false);
            ChildTraverser expandTraverser = new ChildTraverser(context, distance - 1);
            ((AbstractTreeNodeTraverser)expandTraverser).traversePath(expandOp, selectedNode);
            ChildTraverser selectTraverser = new ChildTraverser(context, distance, constraint);
            ((AbstractTreeNodeTraverser)selectTraverser).traversePath(selectOp, selectedNode);
        } else if (ValueSets.TreeDirection.next.rcValue().equalsIgnoreCase(direction)) {
            SiblingTraverser traverser = new SiblingTraverser(context, distance, true, constraint);
            ((AbstractTreeNodeTraverser)traverser).traversePath(selectOp, selectedNode);
        } else if (ValueSets.TreeDirection.previous.rcValue().equalsIgnoreCase(direction)) {
            SiblingTraverser traverser = new SiblingTraverser(context, distance, false, constraint);
            ((AbstractTreeNodeTraverser)traverser).traversePath(selectOp, selectedNode);
        }
    }

    public void rcSelect(String pathType, int preAscend, String treePath, String operator, int clickCount, int button, String extendSelection) throws StepExecutionException {
        this.selectByPath(pathType, preAscend, this.createStringNodePath(this.splitTextTreePath(treePath), operator), ClickOptions.create().setClickCount(clickCount).setMouseButton(button).setClickModifier(this.getClickModifier(extendSelection)));
    }

    public void rcSelectByIndices(String pathType, int preAscend, String indexPath, int clickCount, int button, String extendSelection) throws StepExecutionException {
        this.selectByPath(pathType, preAscend, this.createIndexNodePath(this.splitIndexTreePath(indexPath)), ClickOptions.create().setClickCount(clickCount).setMouseButton(button).setClickModifier(this.getClickModifier(extendSelection)));
    }

    public void rcVerifyPath(final String pathType, final int preAscend, final String treePath, final String operator, final boolean exists, int timeout) {
        CheckWithTimeoutQueuer.invokeAndWait("rcVerifyPath", timeout, new Runnable(){

            public void run() {
                try {
                    AbstractTreeTester.this.rcExpand(pathType, preAscend, treePath, operator);
                }
                catch (StepExecutionException stepExecutionException) {
                    if (exists) {
                        Verifier.equals(exists, false);
                    }
                    return;
                }
                if (!exists) {
                    Verifier.equals(exists, true);
                }
            }
        });
    }

    public void rcVerifyPathByIndices(final String pathType, final int preAscend, final String treePath, final boolean exists, int timeout) {
        CheckWithTimeoutQueuer.invokeAndWait("rcVerifyIndices", timeout, new Runnable(){

            public void run() {
                try {
                    AbstractTreeTester.this.rcExpandByIndices(pathType, preAscend, treePath);
                }
                catch (StepExecutionException stepExecutionException) {
                    if (exists) {
                        Verifier.equals(exists, false);
                    }
                    return;
                }
                if (!exists) {
                    Verifier.equals(exists, true);
                }
            }
        });
    }

    public String rcStoreSelectedNodeValue(String variable) {
        AbstractTreeOperationContext context = this.getTreeAdapter().getContext();
        Object selectedNode = this.getSelectedNode(context);
        return context.getRenderedText(selectedNode);
    }

    public String rcStoreValueAtMousePosition(String variable) {
        AbstractTreeOperationContext context = this.getTreeAdapter().getContext();
        return context.getRenderedText(this.getNodeAtMousePosition());
    }

    protected abstract Object getNodeAtMousePosition() throws StepExecutionException;

    public void rcCheckPropertyAtMousePosition(final String name, final String value, final String operator, int timeout) {
        CheckWithTimeoutQueuer.invokeAndWait("rcCheckPropertyAtMousePosition", timeout, new Runnable(){

            public void run() {
                Object cell = AbstractTreeTester.this.getNodeAtMousePosition();
                ITreeComponent bean = AbstractTreeTester.this.getTreeAdapter();
                String propToStr = bean.getPropertyValueOfCell(name, cell);
                Verifier.match(propToStr, value, operator);
            }
        });
    }

    public String rcStorePropertyValueAtMousePosition(String variableName, String propertyName) {
        return this.getTreeAdapter().getPropertyValueOfCell(propertyName, this.getNodeAtMousePosition());
    }

    public void rcVerifySelectedValue(final String pattern, final String operator, int timeout) throws StepExecutionException {
        CheckWithTimeoutQueuer.invokeAndWait("rcVerifySelectedValue", timeout, new Runnable(){

            public void run() {
                AbstractTreeOperationContext context = AbstractTreeTester.this.getTreeAdapter().getContext();
                AbstractTreeTester.this.checkNodeText(context.getSelectedNodes(), pattern, operator);
            }
        });
    }

    protected void checkNodeText(Object[] node, String pattern, String operator) throws StepVerifyFailedException {
        ArrayList<String> nodeTextList = new ArrayList<String>();
        AbstractTreeOperationContext context = this.getTreeAdapter().getContext();
        int i = 0;
        while (i < node.length) {
            nodeTextList.addAll(context.getNodeTextList(node[i]));
            ++i;
        }
        Iterator it = nodeTextList.iterator();
        boolean isMatched = false;
        while (it.hasNext() && !isMatched) {
            try {
                Verifier.match((String)it.next(), pattern, operator);
                isMatched = true;
            }
            catch (StepVerifyFailedException svfe) {
                if (it.hasNext()) continue;
                throw svfe;
            }
        }
    }

    protected Object getStartNode(String pathType, int preAscend, AbstractTreeOperationContext context) {
        Object startNode;
        ITreeComponent tree = this.getTreeAdapter();
        if (pathType.equals(ValueSets.SearchType.relative.rcValue())) {
            Object child = startNode = this.getSelectedNode(context);
            int i = 0;
            while (i < preAscend) {
                if (startNode == null || tree.isRootVisible() && tree.getRootNode() == null) {
                    TestErrorEvent event = EventFactory.createActionError((String)"TestErrorEvent.TreeNodeNotFound");
                    throw new StepExecutionException("Tree node not found: Parent of " + child.toString(), event);
                }
                child = startNode;
                startNode = context.getParent(startNode);
                ++i;
            }
            if (startNode == null || tree.isRootVisible() && tree.getRootNode() == null) {
                startNode = null;
            }
        } else if (pathType.equals(ValueSets.SearchType.absolute.rcValue())) {
            startNode = null;
        } else {
            throw new StepExecutionException(String.valueOf(pathType) + " is not a valid Path Type", EventFactory.createActionError((String)"TestErrorEvent.InvalidParameterValue"));
        }
        return startNode;
    }

    public void rcDragByTextPath(int mouseButton, String modifier, String pathType, int preAscend, String treeTextPath, String operator) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setModifier(modifier);
        dndHelper.setMouseButton(mouseButton);
        this.rcSelect(pathType, preAscend, treeTextPath, operator, 0, 1, ValueSets.BinaryChoice.no.rcValue());
        this.pressOrReleaseModifiers(dndHelper.getModifier(), true);
        this.getRobot().mousePress(null, null, dndHelper.getMouseButton());
        dndHelper.setDragMode(true);
    }

    public void rcDropByTextPath(String pathType, int preAscend, String treeTextPath, String operator, int delayBeforeDrop) {
        try {
            this.rcSelect(pathType, preAscend, treeTextPath, operator, 0, 1, ValueSets.BinaryChoice.no.rcValue());
            AbstractTreeTester.waitBeforeDrop(delayBeforeDrop);
            this.getRobot().shakeMouse();
        }
        finally {
            DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            dndHelper.setDragMode(false);
        }
    }

    public void rcDragByIndexPath(int mouseButton, String modifier, String pathType, int preAscend, String treeIndexPath) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setModifier(modifier);
        dndHelper.setMouseButton(mouseButton);
        this.rcSelectByIndices(pathType, preAscend, treeIndexPath, 0, 1, ValueSets.BinaryChoice.no.rcValue());
        this.pressOrReleaseModifiers(dndHelper.getModifier(), true);
        this.getRobot().mousePress(null, null, dndHelper.getMouseButton());
        dndHelper.setDragMode(true);
    }

    public void rcDropByIndexPath(String pathType, int preAscend, String treeIndexPath, int delayBeforeDrop) {
        try {
            this.rcSelectByIndices(pathType, preAscend, treeIndexPath, 0, 1, ValueSets.BinaryChoice.no.rcValue());
            AbstractTreeTester.waitBeforeDrop(delayBeforeDrop);
            this.getRobot().shakeMouse();
        }
        finally {
            DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            dndHelper.setDragMode(false);
        }
    }
}

