/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.persistence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.EntityTransaction;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang.Validate;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IAbstractContainerPO;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.model.ProjectVersion;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMDirtyVersionException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMSaveException;
import org.eclipse.jubula.client.core.persistence.PersistenceManager;
import org.eclipse.jubula.client.core.persistence.PersistenceUtil;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.core.utils.AbstractNonPostOperatingTreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.TreeTraverser;
import org.eclipse.jubula.tools.internal.exception.InvalidDataException;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.exception.JBFatalException;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.utils.ValueListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodePM
extends PersistenceManager {
    private static NodePM nodePersManager = null;
    private static Logger log = LoggerFactory.getLogger(NodePM.class);
    private Map<String, Long> m_projectIDCache = null;
    private Map<String, Object> m_specTCCache = null;
    private EntityManager m_lastSession = null;
    private boolean m_useCache = false;

    public static NodePM getInstance() {
        if (nodePersManager == null) {
            nodePersManager = new NodePM();
        }
        return nodePersManager;
    }

    public static AbstractCmdHandleChild getCmdHandleChild(INodePO parent, INodePO child) {
        if (parent instanceof ICategoryPO || parent instanceof IAbstractContainerPO) {
            return new CmdHandleChildIntoNodeList();
        }
        if (parent instanceof ITestSuitePO) {
            return new CmdHandleChildIntoNodeList();
        }
        if (parent instanceof ISpecTestCasePO) {
            if (child instanceof IEventExecTestCasePO) {
                return new CmdHandleEventHandlerIntoMap();
            }
            return new CmdHandleChildIntoNodeList();
        }
        String msg = Messages.UnsupportedINodePOSubclass;
        log.error(msg);
        throw new JBFatalException(msg, MessageIDs.E_UNSUPPORTED_NODE);
    }

    public static void addAndPersistChildNode(INodePO parent, INodePO child, Integer pos) throws PMSaveException, PMAlreadyLockedException, PMException, ProjectDeletedException {
        Persistor persistor = Persistor.instance();
        EntityManager sess = persistor.openSession();
        try {
            try {
                AbstractCmdHandleChild handler = NodePM.getCmdHandleChild(parent, child);
                GeneralStorage.getInstance().getProject();
                EntityTransaction tx = persistor.getTransaction(sess);
                sess.persist((Object)child);
                IPersistentObject newParent = (IPersistentObject)sess.find(parent.getClass(), (Object)parent.getId());
                persistor.lockPO(sess, newParent);
                handler.add((INodePO)newParent, child, pos);
                persistor.commitTransaction(sess, tx);
                NodePM.refreshMasterSession(newParent);
            }
            catch (PersistenceException e) {
                PersistenceManager.handleDBExceptionForMasterSession(null, e);
                persistor.dropSession(sess);
            }
        }
        finally {
            persistor.dropSession(sess);
        }
    }

    public static void refreshMasterSession(IPersistentObject refr) {
        EntityManager sess = GeneralStorage.getInstance().getMasterSession();
        IPersistentObject obj = (IPersistentObject)sess.find(refr.getClass(), (Object)refr.getId());
        if (obj != null) {
            try {
                sess.refresh((Object)obj);
            }
            catch (EntityNotFoundException entityNotFoundException) {
                sess.detach((Object)obj);
            }
        }
    }

    public static void renameNode(INodePO node, String newName) throws PMDirtyVersionException, PMAlreadyLockedException, PMSaveException, PMException, ProjectDeletedException {
        Persistor per = Persistor.instance();
        EntityManager sess = per.openSession();
        EntityTransaction tx = null;
        try {
            try {
                INodePO newNode = (INodePO)sess.find(node.getClass(), (Object)node.getId());
                tx = per.getTransaction(sess);
                per.lockPO(sess, node);
                newNode.setName(newName);
                per.commitTransaction(sess, tx);
                NodePM.refreshMasterSession(node);
            }
            catch (PersistenceException e) {
                PersistenceManager.handleDBExceptionForMasterSession(node, e);
                per.dropSession(sess);
            }
        }
        finally {
            per.dropSession(sess);
        }
    }

    public static void setComment(INodePO node, String newComment) throws PMDirtyVersionException, PMAlreadyLockedException, PMSaveException, PMException, ProjectDeletedException {
        Persistor persistor = Persistor.instance();
        EntityManager sess = persistor.openSession();
        EntityTransaction tx = null;
        try {
            try {
                tx = persistor.getTransaction(sess);
                persistor.lockPO(sess, node);
                node.setComment(newComment);
                INodePO persNode = (INodePO)sess.find(node.getClass(), (Object)node.getId());
                persNode.setComment(newComment);
                persistor.commitTransaction(sess, tx);
            }
            catch (PersistenceException e) {
                PersistenceManager.handleDBExceptionForMasterSession(node, e);
                persistor.dropSession(sess);
            }
        }
        finally {
            persistor.dropSession(sess);
        }
    }

    public static List<? extends INodePO> computeListOfNodes(Class type, Long parentProjectId, EntityManager s) {
        Assert.isNotNull((Object)type);
        Assert.isNotNull((Object)s);
        CriteriaQuery query = s.getCriteriaBuilder().createQuery();
        Root from = query.from(type);
        query.select((Selection)from).where((Expression)s.getCriteriaBuilder().equal((Expression)from.get("hbmParentProjectId"), (Object)parentProjectId));
        List queryResult = s.createQuery(query).getResultList();
        return queryResult;
    }

    public static List<IExecTestCasePO> getInternalExecTestCases(String specTcGuid, long parentProjectId) {
        if (specTcGuid == null) {
            return new ArrayList<IExecTestCasePO>(0);
        }
        ArrayList<Long> parentProjectIds = new ArrayList<Long>();
        parentProjectIds.add(parentProjectId);
        return NodePM.getExecTestCasesFor(specTcGuid, parentProjectIds, GeneralStorage.getInstance().getMasterSession());
    }

    public static List<IRefTestSuitePO> getInternalRefTestSuites(String tsGuid, long parentProjectId) {
        if (tsGuid == null) {
            return new ArrayList<IRefTestSuitePO>(0);
        }
        ArrayList<Long> parentProjectIds = new ArrayList<Long>();
        parentProjectIds.add(parentProjectId);
        return NodePM.getRefTestSuitesFor(tsGuid, parentProjectIds, GeneralStorage.getInstance().getMasterSession());
    }

    private static synchronized List<IRefTestSuitePO> getRefTestSuitesFor(String tsGuid, List<Long> parentProjectIds, EntityManager s) {
        StringBuffer queryBuffer = new StringBuffer("select ref from RefTestSuitePO as ref where ref.testSuiteGuid = :tsGuid and ref.hbmParentProjectId in :ids");
        Query q = s.createQuery(queryBuffer.toString());
        q.setParameter("tsGuid", (Object)tsGuid);
        q.setParameter("ids", parentProjectIds);
        List refTestSuiteList = q.getResultList();
        return refTestSuiteList;
    }

    public static List<IExecTestCasePO> getExecTestCases(String specTcGuid, List<Long> parentProjectIds) {
        if (specTcGuid == null) {
            return new ArrayList<IExecTestCasePO>(0);
        }
        return NodePM.getExecTestCasesFor(specTcGuid, parentProjectIds, GeneralStorage.getInstance().getMasterSession());
    }

    @Nullable
    public static List<IExecTestCasePO> getExecTestCases(String specTcGuid, List<Long> parentProjectIds, EntityManager session) {
        if (specTcGuid == null) {
            return null;
        }
        return NodePM.getExecTestCasesFor(specTcGuid, parentProjectIds, session);
    }

    private static synchronized List<IExecTestCasePO> getExecTestCasesFor(String specTcGuid, List<Long> parentProjectIds, EntityManager s) {
        StringBuffer queryBuffer = new StringBuffer("select ref from ExecTestCasePO as ref where ref.specTestCaseGuid = :specTcGuid and ref.hbmParentProjectId in :ids");
        Query q = s.createQuery(queryBuffer.toString());
        q.setParameter("specTcGuid", (Object)specTcGuid);
        q.setParameter("ids", parentProjectIds);
        List execTcList = q.getResultList();
        return execTcList;
    }

    public static synchronized List<IExecTestCasePO> getUsedTestCaseNames(IProjectPO project, IReusedProjectPO reused) {
        if (project == null) {
            return new ArrayList<IExecTestCasePO>();
        }
        EntityManager s = GeneralStorage.getInstance().getMasterSession();
        Query q = s.createQuery("select ref from ExecTestCasePO as ref where ref.hbmParentProjectId = :parentProjectId and ref.projectGuid = :projectGuid");
        q.setParameter("parentProjectId", (Object)project.getId());
        q.setParameter("projectGuid", (Object)reused.getProjectGuid());
        List result = q.getResultList();
        return result;
    }

    public static synchronized ISpecTestCasePO getSpecTestCase(Set<IReusedProjectPO> reusedProjects, String projectGuid, String specTcGuid) {
        ProjectVersion version = null;
        for (IReusedProjectPO reusedProj : reusedProjects) {
            if (!reusedProj.getProjectGuid().equals(projectGuid)) continue;
            version = reusedProj.getProjectVersion();
            break;
        }
        if (version == null || version.getMajorNumber() == null && version.getVersionQualifier() == null) {
            return null;
        }
        EntityManager s = GeneralStorage.getInstance().getMasterSession();
        Long projectId = NodePM.getInstance().findProjectID(s, projectGuid, version);
        if (projectId == null) {
            return null;
        }
        Object result = NodePM.getInstance().findSpecTC(s, specTcGuid, projectId);
        if (result instanceof ISpecTestCasePO) {
            return (ISpecTestCasePO)result;
        }
        return null;
    }

    private Object findSpecTC(EntityManager s, String specTcGuid, Long projectId) {
        Object cached;
        this.validateSession(s);
        StringBuilder idBuilder = new StringBuilder(50);
        idBuilder.append(specTcGuid);
        idBuilder.append(':');
        idBuilder.append(projectId);
        String key = idBuilder.toString();
        if (this.m_useCache && (cached = this.m_specTCCache.get(key)) != null) {
            if (cached instanceof INodePO) {
                return cached;
            }
            return null;
        }
        Query specTcQuery = s.createQuery("select node from SpecTestCasePO as node where node.guid = :guid and node.hbmParentProjectId = :projectId");
        specTcQuery.setParameter("guid", (Object)specTcGuid);
        specTcQuery.setParameter("projectId", (Object)projectId);
        Object result = null;
        try {
            result = specTcQuery.getSingleResult();
        }
        catch (NoResultException noResultException) {}
        if (this.m_useCache) {
            if (result != null) {
                this.m_specTCCache.put(key, result);
            } else {
                this.m_specTCCache.put(key, new Object());
            }
        }
        return result;
    }

    private Long findProjectID(EntityManager s, String projectGuid, ProjectVersion projVersion) {
        Long id;
        this.validateSession(s);
        String key = NodePM.buildProjectKey(projectGuid, projVersion.getMajorNumber(), projVersion.getMinorNumber(), projVersion.getMicroNumber(), projVersion.getVersionQualifier());
        if (this.m_useCache && (id = this.m_projectIDCache.get(key)) != null) {
            if (id != -1L) {
                return id;
            }
            return null;
        }
        Long projectId = null;
        try {
            projectId = ProjectPM.findProjectId(projectGuid, projVersion.getMajorNumber(), projVersion.getMinorNumber(), projVersion.getMicroNumber(), projVersion.getVersionQualifier());
        }
        catch (JBException jBException) {}
        if (projectId != null) {
            if (this.m_useCache) {
                this.m_projectIDCache.put(key, projectId);
            }
            return projectId;
        }
        if (this.m_useCache) {
            this.m_projectIDCache.put(key, new Long(-1L));
        }
        return null;
    }

    private void validateSession(EntityManager s) {
        if (this.m_useCache && this.m_lastSession != s) {
            this.resetCaching();
            this.m_lastSession = s;
        }
    }

    private void resetCaching() {
        if (this.m_projectIDCache != null) {
            this.m_projectIDCache.clear();
            this.m_projectIDCache = null;
        }
        if (this.m_specTCCache != null) {
            this.m_specTCCache.clear();
            this.m_specTCCache = null;
        }
        this.m_lastSession = null;
        if (this.m_useCache) {
            this.m_projectIDCache = new HashMap<String, Long>(20);
            this.m_specTCCache = new HashMap<String, Object>(500);
        }
    }

    private static String buildProjectKey(String projectGuid, Integer majorNumber, Integer minorNumber, Integer microNumber, String versionQualifier) {
        StringBuilder idBuilder = new StringBuilder(200);
        idBuilder.append(projectGuid);
        idBuilder.append(":");
        idBuilder.append(majorNumber);
        idBuilder.append(":");
        idBuilder.append(minorNumber);
        idBuilder.append(":");
        idBuilder.append(microNumber);
        idBuilder.append(":");
        idBuilder.append(versionQualifier);
        return idBuilder.toString();
    }

    public static synchronized ISpecTestCasePO getSpecTestCase(Long projectId, String specTcGuid) {
        EntityManager s = GeneralStorage.getInstance().getMasterSession();
        return (ISpecTestCasePO)NodePM.getInstance().findSpecTC(s, specTcGuid, projectId);
    }

    /*
     * Unable to fully structure code
     */
    public static ISpecTestCasePO getSpecTestCaseParent(INodePO child) {
        if (child == null) {
            return null;
        }
        node = child;
        if (!(node instanceof ISpecTestCasePO)) ** GOTO lbl8
        return (ISpecTestCasePO)node;
lbl-1000:
        // 1 sources

        {
            if (!((node = node.getParentNode()) instanceof ISpecTestCasePO)) continue;
            return (ISpecTestCasePO)node;
lbl8:
            // 2 sources

            ** while (node.getParentNode() != null)
        }
lbl9:
        // 1 sources

        return null;
    }

    public static synchronized ITestSuitePO getTestSuite(String testSuiteGuid) {
        GeneralStorage gs = GeneralStorage.getInstance();
        IProjectPO currentProject = gs.getProject();
        if (currentProject != null) {
            EntityManager s = gs.getMasterSession();
            CriteriaBuilder builder = s.getCriteriaBuilder();
            CriteriaQuery query = builder.createQuery();
            Root from = query.from(NodeMaker.getTestSuitePOClass());
            query.select((Selection)from).where(new Predicate[]{builder.like((Expression)from.get("guid"), testSuiteGuid), builder.equal((Expression)from.get("hbmParentProjectId"), (Object)currentProject.getId())});
            try {
                Object result = s.createQuery(query).getSingleResult();
                if (result instanceof ITestSuitePO) {
                    return (ITestSuitePO)result;
                }
            }
            catch (NoResultException noResultException) {}
        }
        return null;
    }

    public static synchronized INodePO getNode(Long projectId, String nodeGuid) {
        return NodePM.getNode(projectId, nodeGuid, GeneralStorage.getInstance().getMasterSession());
    }

    public static synchronized INodePO getNode(Long projectId, String nodeGuid, EntityManager session) {
        Validate.notNull((Object)session);
        Query specTcQuery = session.createQuery("select node from NodePO node where node.guid = :guid and node.hbmParentProjectId = :projectId");
        specTcQuery.setParameter("guid", (Object)nodeGuid);
        specTcQuery.setParameter("projectId", (Object)projectId);
        try {
            Object result = specTcQuery.getSingleResult();
            if (result instanceof INodePO) {
                return (INodePO)result;
            }
        }
        catch (NoResultException noResultException) {}
        return null;
    }

    public static synchronized Map<String, INodePO> getNodes(Long projectId, Collection<String> guids, EntityManager session) {
        CriteriaQuery query = session.getCriteriaBuilder().createQuery();
        Root from = query.from(NodeMaker.getNodePOClass());
        Predicate parentProjectPred = session.getCriteriaBuilder().equal((Expression)from.get("hbmParentProjectId"), (Object)projectId);
        Predicate guidDisjunction = PersistenceUtil.getExpressionDisjunction(guids, from.get("guid"), session.getCriteriaBuilder());
        query.select((Selection)from).where(new Predicate[]{parentProjectPred, guidDisjunction});
        List nodeList = session.createQuery(query).getResultList();
        HashMap<String, INodePO> guidToNodeMap = new HashMap<String, INodePO>();
        for (INodePO node : nodeList) {
            String guid = node.getGuid();
            if (guidToNodeMap.containsKey(guid)) continue;
            guidToNodeMap.put(guid, node);
        }
        return guidToNodeMap;
    }

    public static long getNumNodes(long parentProjectId, EntityManager sess) {
        Query specTcQuery = sess.createQuery("select count(node) from NodePO as node where node.hbmParentProjectId = :parentProjectId");
        specTcQuery.setParameter("parentProjectId", (Object)parentProjectId);
        try {
            return (Long)specTcQuery.getSingleResult();
        }
        catch (NoResultException noResultException) {
            return 0L;
        }
    }

    public static long getNumTestDataManagers(long parentProjectId, EntityManager sess) {
        Query tdManQuery = sess.createQuery("select count(tdMan) from TDManagerPO tdMan where tdMan.hbmParentProjectId = :parentProjectId");
        tdManQuery.setParameter("parentProjectId", (Object)parentProjectId);
        try {
            return (Long)tdManQuery.getSingleResult();
        }
        catch (NoResultException noResultException) {
            return 0L;
        }
    }

    public static long getNumExecTestCases(long parentProjectId, EntityManager sess) {
        Query execTcQuery = sess.createQuery("select count(execTc) from ExecTestCasePO as execTc where execTc.hbmParentProjectId = :parentProjectId");
        execTcQuery.setParameter("parentProjectId", (Object)parentProjectId);
        try {
            return (Long)execTcQuery.getSingleResult();
        }
        catch (NoResultException noResultException) {
            return 0L;
        }
    }

    public static long getNumExecTestCasesWithRefTd(long parentProjectId, EntityManager sess) {
        Query execTcQuery = sess.createQuery("select count(execTc) from ExecTestCasePO as execTc where execTc.hbmParentProjectId = :parentProjectId and execTc.hasReferencedTD = :hasReferencedTD");
        execTcQuery.setParameter("parentProjectId", (Object)parentProjectId);
        execTcQuery.setParameter("hasReferencedTD", (Object)true);
        try {
            return (Long)execTcQuery.getSingleResult();
        }
        catch (NoResultException noResultException) {
            return 0L;
        }
    }

    public void setUseCache(boolean useCache) {
        this.m_useCache = useCache;
        this.resetCaching();
    }

    public boolean isUseCache() {
        return this.m_useCache;
    }

    public static Map<INodePO, Boolean> cleanupTrackedChanges(IProgressMonitor monitor, IProjectPO project) throws PMException, ProjectDeletedException {
        CollectNodesWithTrackedChangesOperation treeNodeOp = new CollectNodesWithTrackedChangesOperation(project);
        TreeTraverser treeTraverser = new TreeTraverser((INodePO)project, (ITreeNodeOperation<INodePO>)treeNodeOp, true, true);
        treeTraverser.traverse();
        List<INodePO> listOfNodesWithTrackedChanges = treeNodeOp.getListOfNodesWithTrackedChanges();
        HashMap<INodePO, Boolean> nodeToWasLockedMap = new HashMap<INodePO, Boolean>(listOfNodesWithTrackedChanges.size());
        monitor.beginTask(Messages.DeleteTrackedChangesActionDialog, listOfNodesWithTrackedChanges.size());
        Persistor persistor = Persistor.instance();
        EntityManager session = persistor.openSession();
        EntityTransaction tx = null;
        tx = persistor.getTransaction(session);
        for (INodePO node : listOfNodesWithTrackedChanges) {
            try {
                persistor.lockPO(session, node);
                node.deleteTrackedChanges();
                session.merge((Object)node);
                nodeToWasLockedMap.put(node, new Boolean(false));
            }
            catch (PersistenceException | PMException object) {
                nodeToWasLockedMap.put(node, new Boolean(true));
            }
            monitor.worked(1);
        }
        persistor.commitTransaction(session, tx);
        persistor.dropSession(session);
        EntityManager master = GeneralStorage.getInstance().getMasterSession();
        for (INodePO key : nodeToWasLockedMap.keySet()) {
            INodePO refr;
            if (((Boolean)nodeToWasLockedMap.get(key)).booleanValue() || (refr = (INodePO)master.find(key.getClass(), (Object)key.getId())) == null) continue;
            master.refresh((Object)refr);
        }
        monitor.done();
        return nodeToWasLockedMap;
    }

    public static INodePO findNodeById(Long id) {
        EntityManager em = GeneralStorage.getInstance().getEntityManager();
        Query q = em.createQuery("select node from NodePO node where node.id =:id");
        q.setParameter("id", (Object)id);
        Object res = null;
        try {
            res = q.getSingleResult();
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
        }
        if (res != null) {
            return (INodePO)res;
        }
        return null;
    }

    public static List<IExecTestCasePO> findExecTCsByRefSpecTCAndProject(Set<Long> projIds, List<String> specTCGuids, EntityManager sess) {
        TypedQuery q = sess.createQuery("select exec from ExecTestCasePO exec where exec.hbmParentProjectId in :projIds and exec.specTestCaseGuid in :specTCGuids and exec.projectGuid = :currProjGuid", IExecTestCasePO.class);
        q.setParameter("projIds", projIds);
        q.setParameter("currProjGuid", (Object)GeneralStorage.getInstance().getProject().getGuid());
        ValueListIterator listIter = new ValueListIterator(specTCGuids);
        ArrayList<IExecTestCasePO> result = new ArrayList<IExecTestCasePO>();
        while (listIter.hasNext()) {
            q.setParameter("specTCGuids", (Object)listIter.nextList());
            result.addAll(q.getResultList());
        }
        return result;
    }

    public static abstract class AbstractCmdHandleChild {
        private IPersistentObject m_parent = null;

        public abstract void add(INodePO var1, INodePO var2, Integer var3);

        public void delete(INodePO parent, INodePO child) {
            this.remove(parent, child);
        }

        public abstract void remove(INodePO var1, INodePO var2);

        public void setParentProjectId(INodePO child, INodePO parent) {
            Long parentProjectId = parent.getParentProjectId();
            if (parentProjectId == null) {
                parentProjectId = GeneralStorage.getInstance().getProject().getId();
            }
            child.setParentProjectId(parentProjectId);
        }

        public void setParent(IPersistentObject par) {
            this.m_parent = par;
        }

        public IPersistentObject getParent() {
            return this.m_parent;
        }
    }

    public static class CmdHandleChildIntoNodeList
    extends AbstractCmdHandleChild {
        @Override
        public void add(INodePO parent, INodePO child, Integer pos) {
            parent.addNode(pos == null ? -1 : pos, child);
            this.setParentProjectId(child, parent);
        }

        @Override
        public void remove(INodePO parent, INodePO child) {
            parent.removeNode(child);
        }
    }

    public static class CmdHandleEventHandlerIntoMap
    extends AbstractCmdHandleChild {
        @Override
        public void add(INodePO assocNode, INodePO evHandler, Integer pos) {
            if (assocNode instanceof ISpecTestCasePO && evHandler instanceof IEventExecTestCasePO) {
                ISpecTestCasePO usingSpecTc = (ISpecTestCasePO)assocNode;
                try {
                    usingSpecTc.addEventTestCase((IEventExecTestCasePO)evHandler);
                    this.setParentProjectId(usingSpecTc, evHandler);
                }
                catch (InvalidDataException e) {
                    log.error(Messages.AttemptToAddAnEventhandlerTwice, (Throwable)e);
                }
            } else {
                throw new JBFatalException(Messages.WrongTypeForAdditionOfEventhandler, MessageIDs.E_UNEXPECTED_EXCEPTION);
            }
        }

        @Override
        public void remove(INodePO assocNode, INodePO evHandler) {
            if (!(assocNode instanceof ISpecTestCasePO) || !(evHandler instanceof IEventExecTestCasePO)) {
                throw new JBFatalException(Messages.WrongTypeForRemovalOfEventhandler, MessageIDs.E_UNEXPECTED_EXCEPTION);
            }
            ISpecTestCasePO usingSpecTc = (ISpecTestCasePO)assocNode;
            usingSpecTc.removeNode(evHandler);
        }
    }

    private static class CollectNodesWithTrackedChangesOperation
    extends AbstractNonPostOperatingTreeNodeOperation<INodePO> {
        private List<INodePO> m_listOfNodesWithTrackedChanges = new ArrayList<INodePO>();
        private IProjectPO m_project;

        public CollectNodesWithTrackedChangesOperation(IProjectPO project) {
            this.m_project = project;
        }

        @Override
        public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            Long parentProjectId = node.getParentProjectId();
            if (parentProjectId != null && !this.m_project.getId().equals(parentProjectId)) {
                return false;
            }
            if (!node.getTrackedChanges().isEmpty()) {
                this.m_listOfNodesWithTrackedChanges.add(node);
            }
            return true;
        }

        public List<INodePO> getListOfNodesWithTrackedChanges() {
            return this.m_listOfNodesWithTrackedChanges;
        }
    }
}

