/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the TooltipComponent component from the concrete toolkit.
 * @since 4.0
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ComponentClassGenerator", 
           date =  "2018-01-29T10:54:03.332Z")
public class TooltipComponent implements org.eclipse.jubula.toolkit.concrete.components.TooltipComponent {
            public TooltipComponent() {
                super();
            }
    
    protected IComponentIdentifier getPseudoComponentIdentifier() {
        return null;
    }
    
        /**
         * 
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkTooltipText(@NonNull Integer timeoutInMs,@NonNull String text,@NonNull Operator operator
        ) throws IllegalArgumentException {
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcCheckTooltipText")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(timeoutInMs)
                        .addParameter(text)
                        .addParameter(operator.rcValue())
                        .build();
        }
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkTooltipText(@NonNull String text,@NonNull Operator operator
        ) throws IllegalArgumentException {
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcCheckTooltipText")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(3000)
                        .addParameter(text)
                        .addParameter(operator.rcValue())
                        .build();
        }
        
} 