/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.internal.impl.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Class representing the OperatingSystemComponentActionHandler component from the concrete toolkit.
 * @since 4.0
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2018-01-29T10:54:03.340Z")
public class OperatingSystemComponentActionHandler implements org.eclipse.jubula.toolkit.concrete.components.handler.OperatingSystemComponentActionHandler {
            public OperatingSystemComponentActionHandler() {
                super();
            }
    
    protected IComponentIdentifier getPseudoComponentIdentifier() {
        return null;
    }
    
        
        /**
         * Run operating system specific executable
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @param directory 
         *        the directory in which the command should be executed
         * @param executable 
         *        the command to execute without any command line arguments
         * @param arguments 
         *        a splitChar-delimited list of command-line arguments
         * @param argumentSplitCharacter 
         *        the character used to split the arguments string into individual arguments
         * @param expectedExitCode 
         *        the expected exit code
         * @param encoding 
         *        the encoding used to read output from the process
         * @param useNewEnvironment 
         *        Do not use old / current environment for new sub-process 
         * @since 4.1
         */
        public Result runExecutable(
            @Nullable Integer timeoutInMs,
            @Nullable String directory,
            @Nullable String executable,
            @Nullable String arguments,
            @Nullable String argumentSplitCharacter,
            @Nullable Integer expectedExitCode,
            @Nullable String encoding,
            @Nullable Boolean useNewEnvironment
        )  {
            if (timeoutInMs == null) return null;
            
            if (directory == null) return null;
            
            if (executable == null) return null;
            
            
            
            if (expectedExitCode == null) return null;
            
            if (encoding == null) return null;
            
            if (useNewEnvironment == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcExec")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(timeoutInMs)
                            .addParameter(directory)
                            .addParameter(executable)
                            .addOptionalParameter(arguments)
                            .addOptionalParameter(argumentSplitCharacter)
                            .addParameter(expectedExitCode)
                            .addParameter(encoding)
                            .addParameter(useNewEnvironment)
                            .build(), null);
        }
        /**
         * Run operating system specific executable
         * @param directory 
         *        the directory in which the command should be executed
         * @param executable 
         *        the command to execute without any command line arguments
         * @param arguments 
         *        a splitChar-delimited list of command-line arguments
         * @param argumentSplitCharacter 
         *        the character used to split the arguments string into individual arguments
         * @param expectedExitCode 
         *        the expected exit code
         * @param encoding 
         *        the encoding used to read output from the process
         * @param useNewEnvironment 
         *        Do not use old / current environment for new sub-process 
         * @since 4.1
         */
        public Result runExecutable(
            @Nullable String directory,
            @Nullable String executable,
            @Nullable String arguments,
            @Nullable String argumentSplitCharacter,
            @Nullable Integer expectedExitCode,
            @Nullable String encoding,
            @Nullable Boolean useNewEnvironment
        )  {
            if (directory == null) return null;
            
            if (executable == null) return null;
            
            
            
            if (expectedExitCode == null) return null;
            
            if (encoding == null) return null;
            
            if (useNewEnvironment == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcExec")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(0)
                            .addParameter(directory)
                            .addParameter(executable)
                            .addOptionalParameter(arguments)
                            .addOptionalParameter(argumentSplitCharacter)
                            .addParameter(expectedExitCode)
                            .addParameter(encoding)
                            .addParameter(useNewEnvironment)
                            .build(), null);
        }
        
} 