/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.desktop.connection;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.autagent.AutStarter;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.internal.BaseAUTConnection;
import org.eclipse.jubula.client.internal.BaseConnection;
import org.eclipse.jubula.client.internal.commands.AUTStartedCommand;
import org.eclipse.jubula.client.internal.exceptions.ConnectionException;
import org.eclipse.jubula.communication.internal.Communicator;
import org.eclipse.jubula.communication.internal.ICommand;
import org.eclipse.jubula.communication.internal.message.AUTStateMessage;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.communication.internal.message.SendAUTListOfSupportedComponentsMessage;
import org.eclipse.jubula.communication.internal.message.SendCompSystemI18nMessage;
import org.eclipse.jubula.communication.internal.message.UnknownMessageException;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.internal.exception.CommunicationException;
import org.eclipse.jubula.tools.internal.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.registration.AutIdentifier;
import org.eclipse.jubula.tools.internal.utils.TimeUtil;
import org.eclipse.jubula.tools.internal.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectAUTConnection
extends BaseAUTConnection {
    private static final Logger LOG = LoggerFactory.getLogger(DirectAUTConnection.class);

    public DirectAUTConnection(Communicator communicator, AutIdentifier autID) throws ConnectionException {
        this.setCommunicator(communicator);
        this.setConnectedAutId(autID);
    }

    public void setup() throws BaseConnection.NotConnectedException, ConnectionException, CommunicationException {
        AUTStartedCommand response = new AUTStartedCommand();
        response.setStateMessage(new AUTStateMessage(1));
        this.sendKeyboardLayoutToAut();
        this.sendResourceBundlesToAut();
        this.getAllComponentsFromAUT(response);
    }

    private void sendResourceBundlesToAut() {
        SendCompSystemI18nMessage i18nMessage = new SendCompSystemI18nMessage();
        i18nMessage.setResourceBundles(CompSystemI18n.bundlesToString());
        try {
            this.send((Message)i18nMessage);
        }
        catch (CommunicationException e) {
            LOG.error(Messages.CommunicationErrorWhileSettingResourceBundle, (Throwable)e);
        }
    }

    public void getAllComponentsFromAUT(AUTStartedCommand command) throws CommunicationException {
        LOG.info(Messages.GettingAllComponentsFromAUT);
        try {
            SendAUTListOfSupportedComponentsMessage message = new SendAUTListOfSupportedComponentsMessage();
            CompSystem compSystem = ComponentBuilder.getInstance().getCompSystem();
            String autToolkitId = AutStarter.getInstance().getAgent().getToolkitForAutID(this.getConnectedAutId());
            if (StringUtils.isBlank((String)autToolkitId)) {
                throw new IllegalArgumentException("toolkit id is not given");
            }
            List components = compSystem.getComponents(autToolkitId, true);
            components.retainAll(compSystem.getConcreteComponents());
            message.setComponents(components);
            Profile profile = new Profile();
            message.setProfile(profile);
            int timeoutToUse = 500000;
            this.request((Message)message, (ICommand)command, timeoutToUse);
            long startTime = System.currentTimeMillis();
            while (System.currentTimeMillis() <= startTime + (long)timeoutToUse && !command.wasExecuted() && this.isConnected()) {
                TimeUtil.delay((long)500L);
            }
            if (!command.wasExecuted() && this.isConnected()) {
                throw new CommunicationException(Messages.CouldNotRequestComponentsFromAUT, MessageIDs.E_COMMUNICATOR_CONNECTION);
            }
        }
        catch (UnknownMessageException ume) {
            LOG.error("An exception occurred during sending the message", (Throwable)ume);
        }
    }

    public boolean isConnected() {
        return true;
    }
}

