/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.businessprocess;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.eclipse.jubula.client.core.businessprocess.CompNameManager;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.ObjectMappingEventDispatcher;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IComponentNameReuser;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IObjectMappingPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.objectmapping.OMEditorDndSupport;
import org.eclipse.jubula.client.ui.rcp.editors.ObjectMappingMultiPageEditor;

public class OMEditorBP {
    private transient IObjectMappingCategoryPO m_categoryToCreateIn;
    private ObjectMappingMultiPageEditor m_editor;

    public OMEditorBP(ObjectMappingMultiPageEditor editor) {
        this.setEditor(editor);
    }

    public IObjectMappingCategoryPO getCategoryToCreateIn() {
        return this.m_categoryToCreateIn;
    }

    public void setCategoryToCreateIn(IObjectMappingCategoryPO categoryToCreateIn) {
        this.m_categoryToCreateIn = categoryToCreateIn;
        ObjectMappingEventDispatcher.setCategoryToCreateIn((IObjectMappingCategoryPO)categoryToCreateIn);
    }

    public IObjectMappingCategoryPO deleteCategory(IObjectMappingCategoryPO toDelete) {
        this.changeReuseOfCompNames(toDelete);
        IObjectMappingCategoryPO parent = toDelete.getParent();
        parent.removeCategory(toDelete);
        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)parent, DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)toDelete, DataEventDispatcher.DataState.Deleted, DataEventDispatcher.UpdateState.onlyInEditor);
        return parent;
    }

    private void changeReuseOfCompNames(IObjectMappingCategoryPO toDelete) {
        for (IObjectMappingAssoziationPO assoc : toDelete.getUnmodifiableAssociationList()) {
            this.removeCompNames(assoc);
        }
        for (IObjectMappingCategoryPO cat : toDelete.getUnmodifiableCategoryList()) {
            this.changeReuseOfCompNames(cat);
        }
    }

    public IObjectMappingCategoryPO deleteCompName(IComponentNamePO toDelete, boolean fromEditor) {
        IObjectMappingCategoryPO category;
        IObjectMappingCategoryPO originalCategory = null;
        IWritableComponentNameCache cNCache = this.getEditor().getCompNameCache();
        IObjectMappingAssoziationPO parent = this.getAssociation(toDelete.getGuid());
        if (parent == null) {
            return null;
        }
        cNCache.changeReuse((IComponentNameReuser)parent, toDelete.getGuid(), null);
        originalCategory = category = parent.getCategory();
        if (parent.getLogicalNames().isEmpty()) {
            if (originalCategory != null) {
                originalCategory.removeAssociation(parent);
            }
            if (parent.getTechnicalName() != null) {
                Stack<String> catPath = new Stack<String>();
                while (category.getParent() != null) {
                    catPath.push(category.getName());
                    category = category.getParent();
                }
                IObjectMappingCategoryPO newCategory = this.getEditor().getAut().getObjMap().getUnmappedTechnicalCategory();
                while (!catPath.isEmpty()) {
                    String catName = (String)catPath.pop();
                    IObjectMappingCategoryPO subcategory = this.findSubcategory(newCategory, catName);
                    if (subcategory == null) {
                        subcategory = PoMaker.createObjectMappingCategoryPO((String)catName, (IAUTMainPO)this.getEditor().getAut());
                        newCategory.addCategory(subcategory);
                    }
                    newCategory = subcategory;
                }
                newCategory.addAssociation(parent);
            } else {
                this.getEditor().getEntityManager().remove((Object)parent);
            }
        }
        if (fromEditor && CompNameManager.getInstance().getResCompNamePOByGuid(toDelete.getGuid()) == null) {
            cNCache.removeCompName(toDelete.getGuid());
        }
        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)this.getEditor().getAut().getObjMap(), DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
        return originalCategory;
    }

    public IObjectMappingCategoryPO deleteAssociation(IObjectMappingAssoziationPO toDelete) {
        this.removeCompNames(toDelete);
        IObjectMappingCategoryPO parent = toDelete.getCategory();
        parent.removeAssociation(toDelete);
        this.getEditor().getAut().getObjMap().removeAssociationFromCache(toDelete);
        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)parent, DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
        return parent;
    }

    private void removeCompNames(IObjectMappingAssoziationPO assoc) {
        ArrayList guids = new ArrayList(assoc.getLogicalNames());
        for (String guid : guids) {
            this.getEditor().getCompNameCache().changeReuse((IComponentNameReuser)assoc, guid, null);
        }
    }

    private IObjectMappingCategoryPO findSubcategory(IObjectMappingCategoryPO category, String subcategoryName) {
        for (IObjectMappingCategoryPO subcategory : category.getUnmodifiableCategoryList()) {
            if (!subcategoryName.equals(subcategory.getName())) continue;
            return subcategory;
        }
        return null;
    }

    public IObjectMappingAssoziationPO getAssociation(String compNameGuid) {
        IObjectMappingPO objMap = this.getEditor().getAut().getObjMap();
        return objMap.getLogicalNameAssoc(compNameGuid);
    }

    public boolean existCategory(IObjectMappingCategoryPO start, String name) {
        for (IObjectMappingCategoryPO child : start.getUnmodifiableCategoryList()) {
            if (!child.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public IObjectMappingCategoryPO getSection(IComponentNamePO compNamePo) {
        IObjectMappingAssoziationPO assoc = this.getAssociation(compNamePo.getGuid());
        if (assoc != null) {
            return OMEditorDndSupport.getSection(assoc);
        }
        return null;
    }

    public IObjectMappingCategoryPO getCategory(IComponentNamePO compNamePo) {
        IObjectMappingAssoziationPO assoc = this.getAssociation(compNamePo.getGuid());
        return assoc.getCategory();
    }

    public IObjectMappingCategoryPO createCategory(IObjectMappingCategoryPO section, IObjectMappingCategoryPO subcategory) {
        IObjectMappingCategoryPO curCat = section;
        for (String pathEntry : this.getCatPath(subcategory)) {
            boolean childExists = false;
            for (IObjectMappingCategoryPO child : curCat.getUnmodifiableCategoryList()) {
                if (!child.getName().equals(pathEntry)) continue;
                curCat = child;
                childExists = true;
                break;
            }
            if (childExists) continue;
            IObjectMappingCategoryPO newCat = PoMaker.createObjectMappingCategoryPO((String)pathEntry, (IAUTMainPO)this.getEditor().getAut());
            curCat.addCategory(newCat);
            curCat = newCat;
        }
        return curCat;
    }

    private List<String> getCatPath(IObjectMappingCategoryPO category) {
        ArrayList<String> catPath = new ArrayList<String>();
        IObjectMappingCategoryPO curCat = category;
        while (curCat.getParent() != null) {
            catPath.add(curCat.getName());
            curCat = curCat.getParent();
        }
        Collections.reverse(catPath);
        return catPath;
    }

    public void collectNewLogicalComponentNames() {
        if (this.getEditor().cleanupNames() > 0) {
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)this.getEditor().getAut().getObjMap(), DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
        }
    }

    private void setEditor(ObjectMappingMultiPageEditor editor) {
        this.m_editor = editor;
    }

    private ObjectMappingMultiPageEditor getEditor() {
        return this.m_editor;
    }
}

