/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers.dnd;

import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jubula.client.core.model.INodePO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNodeViewerDropAdapter
extends ViewerDropAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNodeViewerDropAdapter.class);

    protected AbstractNodeViewerDropAdapter(Viewer viewer) {
        super(viewer);
    }

    protected Object getFallbackTarget(Viewer viewer) {
        if (viewer != null) {
            Object fallbackTarget = null;
            Object viewerInput = ((Object[])viewer.getInput())[0];
            if (viewerInput instanceof INodePO) {
                List viewerRootChildren = ((INodePO)viewerInput).getUnmodifiableNodeList();
                int childrenCount = 1;
                if (viewerRootChildren != null) {
                    childrenCount = viewerRootChildren.size();
                }
                fallbackTarget = childrenCount > 0 ? viewerRootChildren.get(childrenCount - 1) : viewerInput;
            }
            return fallbackTarget;
        }
        return null;
    }

    void logDrop(IStructuredSelection sel, INodePO target, boolean succ) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        INodePO par = target.getSpecAncestor();
        StringBuilder str = new StringBuilder();
        str.append("\nDropping in an Editor.\nThe root node is: ");
        str.append(par.toString());
        str.append("\nThe drop target is: ");
        str.append(target.toString());
        str.append("\nThe dropped nodes are:\n");
        str.append(sel.toList().toString());
        str.append("\nSuccess: ");
        str.append(succ);
        str.append("\n");
        LOG.debug(str.toString());
    }
}

