/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.ui.handlers.AbstractSelectionBasedHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.IEditorOperation;
import org.eclipse.jubula.client.ui.rcp.dialogs.InputDialog;
import org.eclipse.jubula.client.ui.rcp.editors.ObjectMappingMultiPageEditor;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.handlers.HandlerUtil;

public class OMNewCategoryHandler
extends AbstractSelectionBasedHandler {
    public Object executeImpl(ExecutionEvent event) throws ExecutionException {
        ObjectMappingMultiPageEditor editor = (ObjectMappingMultiPageEditor)HandlerUtil.getActivePartChecked((ExecutionEvent)event);
        IStructuredSelection selection = this.getSelection();
        if (selection.size() == 1) {
            ISelectionProvider selectionProvider = HandlerUtil.getActiveSiteChecked((ExecutionEvent)event).getSelectionProvider();
            this.createNewCategory(selection.getFirstElement(), editor, selectionProvider);
        }
        return null;
    }

    private void createNewCategory(Object selElement, final ObjectMappingMultiPageEditor editor, final ISelectionProvider selectionProvider) {
        IObjectMappingCategoryPO category = null;
        if (selElement instanceof IObjectMappingCategoryPO) {
            category = (IObjectMappingCategoryPO)selElement;
        } else if (selElement instanceof IObjectMappingAssoziationPO) {
            category = ((IObjectMappingAssoziationPO)selElement).getCategory();
        } else if (selElement instanceof IComponentNamePO) {
            category = editor.getOmEditorBP().getCategory((IComponentNamePO)selElement);
        }
        final IObjectMappingCategoryPO node = category;
        if (node != null) {
            editor.getEditorHelper().doEditorOperation(new IEditorOperation(){

                @Override
                public void run(IPersistentObject workingPo) {
                    InputDialog dialog = new InputDialog(OMNewCategoryHandler.this.getActiveShell(), Messages.OMNewCategoryActionTitle, Messages.OMNewCategoryActionName, Messages.OMNewCategoryActionMessage, Messages.OMNewCategoryActionLabel, Messages.OMNewCategoryActionError1, Messages.OMNewCategoryActionDoubleCatName, "newCategoryDialog.gif", Messages.OMNewCategoryActionShell, false){

                        @Override
                        protected boolean isInputAllowed() {
                            return !editor.getOmEditorBP().existCategory(node, this.getInputFieldText());
                        }
                    };
                    dialog.setHelpAvailable(true);
                    dialog.create();
                    DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
                    Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.dialogOMCategoryNewContextId");
                    if (dialog.open() == 0) {
                        IObjectMappingCategoryPO newCategory = PoMaker.createObjectMappingCategoryPO((String)dialog.getName(), (IAUTMainPO)editor.getAut());
                        node.addCategory(newCategory);
                        editor.getEditorHelper().setDirty(true);
                        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)node, DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
                        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)newCategory, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.onlyInEditor);
                        StructuredSelection newSel = new StructuredSelection((Object)newCategory);
                        if (selectionProvider != null) {
                            selectionProvider.setSelection((ISelection)newSel);
                        }
                    }
                }
            });
        }
    }
}

