/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.rename;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jubula.client.core.businessprocess.CompNameManager;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.handlers.rename.AbstractRenameComponentNameHandler;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;

public class RenameComponentNameInViewHandler
extends AbstractRenameComponentNameHandler {
    public Object executeImpl(ExecutionEvent event) {
        IComponentNamePO compName = this.getSelectedComponentName();
        if (compName != null) {
            try {
                String newName = this.getNewName(event, compName);
                if (newName != null) {
                    CompNameManager.getInstance().renameCompName(compName, newName);
                    IComponentNamePO eventCompName = CompNameManager.getInstance().getResCompNamePOByGuid(compName.getGuid());
                    DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)eventCompName, DataEventDispatcher.DataState.Renamed, DataEventDispatcher.UpdateState.all);
                }
            }
            catch (PMException e) {
                PMExceptionHandler.handlePMExceptionForMasterSession(e);
            }
            catch (ProjectDeletedException projectDeletedException) {
                PMExceptionHandler.handleProjectDeletedException();
            }
        }
        return null;
    }
}

