/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.rcp.e3.gef.util;

import java.util.Map;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.jubula.rc.rcp.e3.gef.factory.DefaultEditPartAdapterFactory;
import org.eclipse.jubula.rc.rcp.e3.gef.identifier.IEditPartIdentifier;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FigureCanvasUtil {
    private FigureCanvasUtil() {
    }

    public static GraphicalViewer getViewer(FigureCanvas figureCanvas) {
        FigureCanvas parent = figureCanvas;
        while (parent != null && !(parent.getData("TEST_GEF_VIEWER") instanceof GraphicalViewer)) {
            parent = parent.getParent();
        }
        if (parent != null) {
            return (GraphicalViewer)parent.getData("TEST_GEF_VIEWER");
        }
        return null;
    }

    public static EditPart findAtCurrentMousePosition(Display display, EditPartViewer viewer) {
        Point cursorLocation = new Point(display.map(null, viewer.getControl(), display.getCursorLocation()));
        EditPart editPart = viewer.findObjectAt(cursorLocation);
        EditPart primaryEditPart = FigureCanvasUtil.getPrimaryEditPart(editPart, viewer.getRootEditPart());
        return primaryEditPart;
    }

    public static EditPart getPrimaryEditPart(EditPart editPart, RootEditPart root) {
        EditPart currentEditPart = editPart;
        while (currentEditPart != root.getContents() && currentEditPart != null) {
            IEditPartIdentifier identifier = DefaultEditPartAdapterFactory.loadFigureIdentifier(currentEditPart);
            if (identifier != null) {
                return currentEditPart;
            }
            currentEditPart = currentEditPart.getParent();
        }
        return null;
    }

    public static IFigure findFigure(GraphicalEditPart editPart) {
        IFigure figure;
        if (editPart != null && (figure = editPart.getFigure()).isShowing()) {
            return figure;
        }
        return null;
    }

    public static Map.Entry<String, ConnectionAnchor> getConnectionAnchor(ConnectionEditPart connection) {
        if (connection != null) {
            DefaultEditPartAdapterFactory.loadFigureIdentifier((EditPart)connection);
            EditPart source = connection.getSource();
            if (source instanceof GraphicalEditPart) {
                GraphicalEditPart graphEditPart = (GraphicalEditPart)source;
                IEditPartIdentifier editPartIdentifier = DefaultEditPartAdapterFactory.loadFigureIdentifier(source);
                if (graphEditPart instanceof NodeEditPart) {
                    NodeEditPart nodeEditPart = (NodeEditPart)graphEditPart;
                    ConnectionAnchor anchor = nodeEditPart.getSourceConnectionAnchor(connection);
                    editPartIdentifier.getConnectionAnchors();
                    for (Map.Entry<String, ConnectionAnchor> entry : editPartIdentifier.getConnectionAnchors().entrySet()) {
                        if (!anchor.equals(entry.getValue())) continue;
                        return entry;
                    }
                    return new SimpleEntry<String, ConnectionAnchor>(anchor.getClass().getName(), anchor);
                }
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleEntry<K, V>
    implements Map.Entry<K, V> {
        private K m_key;
        private V m_value;

        public SimpleEntry(K key, V value) {
            this.m_key = key;
            this.m_value = value;
        }

        @Override
        public K getKey() {
            return this.m_key;
        }

        @Override
        public V getValue() {
            return this.m_value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = value;
            this.m_value = value;
            return oldValue;
        }
    }
}

