/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.businessprocess;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jubula.client.core.preferences.database.DatabaseConnection;
import org.eclipse.jubula.client.core.preferences.database.DatabaseConnectionConverter;
import org.eclipse.jubula.client.ui.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurePreferenceBP {
    private static final Logger LOG = LoggerFactory.getLogger(SecurePreferenceBP.class);
    private static SecurePreferenceBP instance;

    private SecurePreferenceBP() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.jubula.client.core");
        prefs.addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                String[] oldProfileName = SecurePreferenceBP.this.getProfileName(event, true);
                String[] newProfileName = SecurePreferenceBP.this.getProfileName(event, false);
                if (oldProfileName.length != 0 && newProfileName.length != 0) {
                    String oldName = "";
                    String newName = "";
                    int i = 0;
                    while (i < oldProfileName.length) {
                        oldName = oldProfileName[i];
                        newName = newProfileName[i];
                        if (oldName != null && newName != null) {
                            SecurePreferenceBP.this.renameProfile(oldName, newName);
                            IPreferenceStore store = Plugin.getDefault().getPreferenceStore();
                            if (store.getString("AUTOMATIC_DATABASE_CONNECTION_KEY").equals(oldName)) {
                                store.setValue("AUTOMATIC_DATABASE_CONNECTION_KEY", newName);
                            }
                        }
                        ++i;
                    }
                }
            }
        });
    }

    public static SecurePreferenceBP getInstance() {
        if (instance == null) {
            instance = new SecurePreferenceBP();
        }
        return instance;
    }

    public boolean isSaveCredentialsActive(String profileName) {
        boolean saveProfile = false;
        Set<Object> setProfiles = new HashSet();
        setProfiles.clear();
        setProfiles = this.splitProfileString("SAVE_PROFILE_NAMES_KEY");
        if (!setProfiles.isEmpty()) {
            int i = 0;
            while (i < setProfiles.size()) {
                if (setProfiles.contains(profileName)) {
                    saveProfile = true;
                }
                ++i;
            }
        }
        return saveProfile;
    }

    public void setSaveCredentialStatus(String profileName, boolean status) {
        IPreferenceStore store = Plugin.getDefault().getPreferenceStore();
        Set<Object> setProfiles = new HashSet();
        setProfiles.clear();
        setProfiles = this.splitProfileString("SAVE_PROFILE_NAMES_KEY");
        StringBuffer bufferProfiles = new StringBuffer();
        if (status) {
            setProfiles.add(profileName);
            bufferProfiles.append(";");
            for (String string : setProfiles) {
                bufferProfiles.append(string).append(";");
            }
            store.setValue("SAVE_PROFILE_NAMES_KEY", bufferProfiles.toString());
        } else if (setProfiles.contains(profileName)) {
            setProfiles.remove(profileName);
            for (String string : setProfiles) {
                bufferProfiles.append(string).append(";");
            }
            store.setValue("SAVE_PROFILE_NAMES_KEY", bufferProfiles.toString());
        }
    }

    private Set<String> splitProfileString(String preferenceKey) {
        IPreferenceStore store = Plugin.getDefault().getPreferenceStore();
        String profileNames = store.getString(preferenceKey);
        String[] arrayProfiles = profileNames.split(";");
        HashSet<String> setProfiles = new HashSet<String>();
        String[] stringArray = arrayProfiles;
        int n = arrayProfiles.length;
        int n2 = 0;
        while (n2 < n) {
            String profile = stringArray[n2];
            setProfiles.add(profile);
            ++n2;
        }
        return setProfiles;
    }

    public void saveProfile(String profileName, String userName) {
        ISecurePreferences node = this.getNodeForProfile(profileName);
        if (node != null) {
            try {
                node.put("Username", userName, false);
            }
            catch (StorageException e1) {
                LOG.error(e1.getLocalizedMessage(), (Throwable)e1);
            }
        }
    }

    public void saveProfilePassword(String profileName, String password) {
        ISecurePreferences node = this.getNodeForProfile(profileName);
        if (node != null) {
            try {
                node.put("Password", password, true);
            }
            catch (StorageException e2) {
                LOG.error(e2.getLocalizedMessage(), (Throwable)e2);
            }
        }
    }

    public void removeProfile(String profileName) {
        ISecurePreferences node = this.getNodeForProfile(profileName);
        if (node != null && !this.isSaveCredentialsActive(profileName)) {
            node.removeNode();
        }
    }

    private void renameProfile(String oldProfileName, String newProfileName) {
        ISecurePreferences root = SecurePreferencesFactory.getDefault();
        if (root == null) {
            LOG.error("No root node found");
        }
        if (oldProfileName != null) {
            ISecurePreferences node = root.node(this.getSecureStorageProfilePath(oldProfileName));
            String userName = this.getUserName(oldProfileName);
            String password = this.getPassword(oldProfileName);
            node.removeNode();
            try {
                node = root.node(this.getSecureStorageProfilePath(newProfileName));
                node.put("Username", userName, false);
            }
            catch (StorageException e1) {
                LOG.error(e1.getLocalizedMessage(), (Throwable)e1);
            }
            if (this.isSaveCredentialsActive(oldProfileName)) {
                try {
                    node.put("Password", password, true);
                }
                catch (StorageException e2) {
                    LOG.error(e2.getLocalizedMessage(), (Throwable)e2);
                }
            }
            if (this.isSaveCredentialsActive(oldProfileName)) {
                this.setSaveCredentialStatus(oldProfileName, false);
                this.setSaveCredentialStatus(newProfileName, true);
            }
        }
    }

    public String[] getProfileName(IEclipsePreferences.PreferenceChangeEvent event, boolean oldName) {
        String[] profileName = new String[]{};
        if (event.getOldValue() != null) {
            List oldConnectionList = DatabaseConnectionConverter.convert((String)event.getOldValue().toString());
            if (event.getNewValue() != null) {
                List newConnectionList = DatabaseConnectionConverter.convert((String)event.getNewValue().toString());
                profileName = new String[oldConnectionList.size()];
                if (oldConnectionList.size() == newConnectionList.size()) {
                    int i = 0;
                    while (i < oldConnectionList.size()) {
                        String newProfileName;
                        String oldProfileName = ((DatabaseConnection)oldConnectionList.get(i)).getName();
                        if (!oldProfileName.equals(newProfileName = ((DatabaseConnection)newConnectionList.get(i)).getName())) {
                            profileName[i] = oldName ? oldProfileName : newProfileName;
                        }
                        ++i;
                    }
                }
            }
        }
        return profileName;
    }

    public String getUserName(String profileName) {
        String userName = "";
        ISecurePreferences secureStorage = SecurePreferencesFactory.getDefault();
        try {
            userName = secureStorage.node(this.getSecureStorageProfilePath(profileName)).get("Username", "");
        }
        catch (StorageException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return userName;
    }

    public String getPassword(String profileName) {
        String dbPwd = "";
        ISecurePreferences secureStorage = SecurePreferencesFactory.getDefault();
        try {
            dbPwd = secureStorage.node(this.getSecureStorageProfilePath(profileName)).get("Password", "");
        }
        catch (StorageException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return dbPwd;
    }

    public void removePassword(String profileName) {
        ISecurePreferences node = this.getNodeForProfile(profileName);
        if (node != null) {
            node.remove("Password");
        }
    }

    public String getSecureStorageProfilePath(String dbProfileName) {
        return new StringBuffer().append("org.eclipse.jubula.DatabaseProfile").append("/").append(dbProfileName).toString();
    }

    private ISecurePreferences getNodeForProfile(String profileName) {
        ISecurePreferences root;
        ISecurePreferences node = root = SecurePreferencesFactory.getDefault();
        if (root == null) {
            LOG.error("No root node found");
        } else if (profileName != null) {
            node = root.node(this.getSecureStorageProfilePath(profileName));
        }
        return node;
    }
}

