/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.internal.commands;

import org.eclipse.jubula.client.core.ClientTest;
import org.eclipse.jubula.client.core.IClientTest;
import org.eclipse.jubula.client.core.events.AUTEvent;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.communication.internal.APICommand;
import org.eclipse.jubula.communication.internal.message.AUTStartStateMessage;
import org.eclipse.jubula.communication.internal.message.AUTStateMessage;
import org.eclipse.jubula.communication.internal.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AUTStartedCommand
implements APICommand {
    private static Logger log = LoggerFactory.getLogger(AUTStartedCommand.class);
    private AUTStartStateMessage m_message;
    private AUTStateMessage m_stateMessage;
    private boolean m_wasExecuted = false;

    public void setStateMessage(AUTStateMessage stateMessage) {
        this.m_stateMessage = stateMessage;
    }

    private void fireAutStateChanged() {
        int state = this.m_stateMessage.getState();
        IClientTest clientTest = ClientTest.instance();
        switch (state) {
            case 1: {
                log.info(Messages.AUTIsRunning);
                clientTest.fireAUTStateChanged(new AUTEvent(1));
                break;
            }
            case 2: {
                log.error(String.valueOf(Messages.AUTCouldNotStarted) + this.m_stateMessage.getDescription());
                clientTest.fireAUTStateChanged(new AUTEvent(6));
            }
        }
    }

    public Message getMessage() {
        return this.m_message;
    }

    public void setMessage(Message message) {
        this.m_message = (AUTStartStateMessage)message;
    }

    public Message execute() {
        this.fireAutStateChanged();
        this.m_wasExecuted = true;
        return null;
    }

    public boolean wasExecuted() {
        return this.m_wasExecuted;
    }

    public void timeout() {
        log.warn(String.valueOf(this.getClass().getName()) + ".timeout() called");
    }
}

