/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.tester;

import java.awt.Rectangle;
import org.eclipse.jubula.rc.common.driver.CheckWithTimeoutQueuer;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.DragAndDropHelper;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.table.Cell;
import org.eclipse.jubula.rc.common.tester.AbstractTableTester;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IComponent;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.ITableComponent;
import org.eclipse.jubula.rc.common.util.Verifier;
import org.eclipse.jubula.rc.swt.components.ISWTTableComponent;
import org.eclipse.jubula.rc.swt.components.SWTCell;
import org.eclipse.jubula.rc.swt.tester.adapter.ControlAdapter;
import org.eclipse.jubula.rc.swt.tester.adapter.StyledTextAdapter;
import org.eclipse.jubula.rc.swt.tester.adapter.TableAdapter;
import org.eclipse.jubula.rc.swt.tester.adapter.TextComponentAdapter;
import org.eclipse.jubula.rc.swt.tester.adapter.TreeAdapter;
import org.eclipse.jubula.rc.swt.tester.util.CAPUtil;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.toolkit.enums.ValueSets;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;
import org.eclipse.jubula.tools.internal.utils.EnvironmentUtils;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class TableTester
extends AbstractTableTester {
    public TableTester() {
    }

    public TableTester(IComponent adapter) {
        this.setAdapter(adapter);
    }

    private ISWTTableComponent getSWTAdapter() {
        return (ISWTTableComponent)this.getComponent();
    }

    public String[] getTextArrayFromComponent() {
        Item[] itemArray = this.getSWTAdapter().getColumnItems();
        String[] componentTextArray = this.getTextArrayFromItemArray(itemArray);
        return componentTextArray;
    }

    protected Object setEditorToReplaceMode(Object editor, boolean replace) {
        if (replace) {
            ControlAdapter textEditor = null;
            if (editor instanceof Text) {
                textEditor = new TextComponentAdapter(editor);
            }
            if (editor instanceof StyledText) {
                textEditor = new StyledTextAdapter(editor);
            }
            if (EnvironmentUtils.isMacOS()) {
                this.getRobot().clickAtCurrentPosition(editor, 3, ValueSets.InteractionMode.primary.rcIntValue().intValue());
            } else {
                this.getRobot().keyStroke(String.valueOf(this.getRobot().getSystemModifierSpec()) + " A");
            }
            if (textEditor != null && !textEditor.getSelectionText().equals(textEditor.getText())) {
                textEditor.selectAll();
            }
        } else {
            this.getRobot().clickAtCurrentPosition(editor, 2, ValueSets.InteractionMode.primary.rcIntValue().intValue());
        }
        return editor;
    }

    protected Object activateEditor(Cell cell, Rectangle rectangle) {
        TableAdapter table = (TableAdapter)this.getComponent();
        return table.activateEditor(cell);
    }

    protected Cell getCellAtMousePosition() throws StepExecutionException {
        final java.awt.Point awtMousePos = this.getRobot().getCurrentMousePosition();
        Cell returnvalue = (Cell)this.getEventThreadQueuer().invokeAndWait("getCellAtMousePosition", (IRunnable)new IRunnable<Cell>(){

            public Cell run() throws StepExecutionException {
                ITableComponent adapter = (ITableComponent)TableTester.this.getComponent();
                Control comp = (Control)adapter.getRealComponent();
                SWTCell cell = null;
                int itemCount = adapter.getRowCount();
                int rowCount = adapter.getTopIndex();
                while (rowCount < itemCount) {
                    if (cell != null) break;
                    int columnCount = adapter.getColumnCount() == 0 ? 1 : adapter.getColumnCount();
                    int col = 0;
                    while (col < columnCount) {
                        TableTester.this.checkRowColBounds(rowCount, col);
                        Rectangle itemBounds = adapter.getCellBounds(rowCount, col, false);
                        if (col == 0 && (comp.getStyle() & 0x20) == 32) {
                            itemBounds.width += itemBounds.x;
                            itemBounds.x = 0;
                        }
                        Point absItemBounds = comp.toDisplay(itemBounds.x, itemBounds.y);
                        Rectangle absRect = new Rectangle(absItemBounds.x, absItemBounds.y, itemBounds.width, itemBounds.height);
                        if (absRect.contains(awtMousePos)) {
                            if (comp instanceof Table) {
                                cell = new SWTCell(rowCount, col, ((Table)comp).getItem(rowCount));
                                break;
                            }
                            if (!(comp instanceof Tree)) break;
                            cell = new SWTCell(rowCount, col, ((TreeAdapter)TableTester.this.getComponent()).getRow(rowCount));
                            break;
                        }
                        ++col;
                    }
                    ++rowCount;
                }
                if (cell == null) {
                    throw new StepExecutionException("No cell under mouse position found!", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
                }
                return cell;
            }
        });
        return returnvalue;
    }

    protected boolean isMouseOnHeader() {
        final ITableComponent adapter = (ITableComponent)this.getComponent();
        if (!adapter.isHeaderVisible()) {
            return false;
        }
        Boolean isOnHeader = new Boolean(false);
        isOnHeader = (Boolean)this.getEventThreadQueuer().invokeAndWait("isMouseOnHeader", (IRunnable)new IRunnable<Boolean>(){

            public Boolean run() {
                java.awt.Point awtMousePos = TableTester.this.getRobot().getCurrentMousePosition();
                Point mousePos = new Point(awtMousePos.x, awtMousePos.y);
                int j = 0;
                while (j < adapter.getColumnCount()) {
                    Rectangle constraints = adapter.getHeaderBounds(j);
                    org.eclipse.swt.graphics.Rectangle bounds = SwtUtils.getWidgetBounds((Widget)((Control)adapter.getRealComponent()));
                    if (constraints != null) {
                        Point convertedLocation = TableTester.this.getConvertedLocation(constraints);
                        bounds.x = convertedLocation.x;
                        bounds.y = convertedLocation.y;
                        bounds.height = constraints.height;
                        bounds.width = constraints.width;
                    }
                    if (bounds.contains(mousePos)) {
                        return true;
                    }
                    ++j;
                }
                return false;
            }
        });
        return isOnHeader;
    }

    protected final String[] getTextArrayFromItemArray(Item[] itemArray) {
        String[] itemTextArray;
        if (itemArray == null) {
            itemTextArray = null;
        } else {
            itemTextArray = new String[itemArray.length];
            int i = 0;
            while (i < itemArray.length) {
                Item item = itemArray[i];
                if (item == null) {
                    itemTextArray[i] = null;
                } else {
                    String fallback = SwtUtils.removeMnemonics(item.getText());
                    itemTextArray[i] = CAPUtil.getWidgetText((Widget)item, fallback);
                }
                ++i;
            }
        }
        return itemTextArray;
    }

    private Point getConvertedLocation(final Rectangle constraints) {
        return (Point)this.getEventThreadQueuer().invokeAndWait("toDisplay", (IRunnable)new IRunnable<Point>(){

            public Point run() throws StepExecutionException {
                Control cont = (Control)TableTester.this.getComponent().getRealComponent();
                return cont.toDisplay(constraints.x, constraints.y);
            }
        });
    }

    protected Object getSpecificRectangle(Rectangle rectangle) {
        return new org.eclipse.swt.graphics.Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void rcClickDirect(int count, int button, int xPos, String xUnits, int yPos, String yUnits) throws StepExecutionException {
        int correctedYPos = this.correctYPos(yPos, yUnits);
        super.rcClickDirect(count, button, xPos, xUnits, correctedYPos, yUnits);
    }

    private int correctYPos(int pos, String units) {
        int correctedPos = pos;
        int headerHeight = (Integer)this.getEventThreadQueuer().invokeAndWait("getHeaderHeight", (IRunnable)new IRunnable<Integer>(){

            public Integer run() throws StepExecutionException {
                return ((Table)TableTester.this.getComponent().getRealComponent()).getHeaderHeight();
            }
        });
        if (ValueSets.Unit.pixel.rcValue().equalsIgnoreCase(units)) {
            correctedPos += headerHeight;
        } else {
            int totalHeight = (Integer)this.getEventThreadQueuer().invokeAndWait("getWidgetBounds", (IRunnable)new IRunnable<Integer>(){

                public Integer run() throws StepExecutionException {
                    return SwtUtils.getWidgetBounds((Widget)((Widget)TableTester.this.getComponent().getRealComponent())).height;
                }
            });
            long targetHeight = totalHeight - headerHeight;
            long targetPos = Math.round((double)targetHeight * (double)pos / 100.0);
            double heightPercentage = (double)(targetPos += (long)headerHeight) / (double)totalHeight * 100.0;
            correctedPos = (int)Math.round(heightPercentage);
            if (correctedPos > 100) {
                correctedPos = 100;
            }
        }
        return correctedPos;
    }

    public void rcDragCell(int mouseButton, String modifier, String row, String rowOperator, String col, String colOperator, int xPos, String xUnits, int yPos, String yUnits) throws StepExecutionException {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setModifier(modifier);
        dndHelper.setDragComponent(null);
        this.rcSelectCell(row, rowOperator, col, colOperator, 0, xPos, xUnits, yPos, yUnits, ValueSets.BinaryChoice.no.rcValue(), 1);
    }

    public void rcDropCell(final String row, final String rowOperator, final String col, final String colOperator, final int xPos, final String xUnits, final int yPos, final String yUnits, int delayBeforeDrop) throws StepExecutionException {
        final DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        final IRobot robot = this.getRobot();
        this.pressOrReleaseModifiers(dndHelper.getModifier(), true);
        try {
            this.getEventThreadQueuer().invokeAndWait("rcDropCell", (IRunnable)new IRunnable<Void>(){

                public Void run() throws StepExecutionException {
                    robot.mousePress(dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
                    robot.shakeMouse();
                    TableTester.this.rcSelectCell(row, rowOperator, col, colOperator, 0, xPos, xUnits, yPos, yUnits, ValueSets.BinaryChoice.no.rcValue(), 1);
                    return null;
                }
            });
            TableTester.waitBeforeDrop((int)delayBeforeDrop);
        }
        finally {
            robot.mouseRelease(dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
        }
    }

    public void rcDragRowByValue(int mouseButton, String modifier, String col, String colOperator, String value, String regexOp, String searchType) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setModifier(modifier);
        dndHelper.setDragComponent(null);
        this.rcSelectRowByValue(col, colOperator, value, regexOp, 1, ValueSets.BinaryChoice.no.rcValue(), searchType, 1);
    }

    public void rcDropRowByValue(final String col, final String colOperator, final String value, final String regexOp, final String searchType, int delayBeforeDrop) {
        final DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        final IRobot robot = this.getRobot();
        this.pressOrReleaseModifiers(dndHelper.getModifier(), true);
        try {
            this.getEventThreadQueuer().invokeAndWait("rcDropRowByValue", (IRunnable)new IRunnable<Void>(){

                public Void run() throws StepExecutionException {
                    robot.mousePress(dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
                    robot.shakeMouse();
                    TableTester.this.selectRowByValue(col, colOperator, value, regexOp, ValueSets.BinaryChoice.no.rcValue(), searchType, ClickOptions.create().setClickCount(0));
                    return null;
                }
            });
            TableTester.waitBeforeDrop((int)delayBeforeDrop);
        }
        finally {
            robot.mouseRelease(dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
        }
    }

    public void rcDragCellByColValue(int mouseButton, String modifier, String row, String rowOperator, String value, String regex, String searchType) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setModifier(modifier);
        dndHelper.setDragComponent(null);
        this.selectCellByColValue(row, rowOperator, value, regex, ValueSets.BinaryChoice.no.rcValue(), searchType, ClickOptions.create().setClickCount(0));
    }

    public void rcDropCellByColValue(final String row, final String rowOperator, final String value, final String regex, final String searchType, int delayBeforeDrop) {
        final DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        final IRobot robot = this.getRobot();
        this.pressOrReleaseModifiers(dndHelper.getModifier(), true);
        try {
            this.getEventThreadQueuer().invokeAndWait("rcDropCellByColValue", (IRunnable)new IRunnable<Void>(){

                public Void run() throws StepExecutionException {
                    robot.mousePress(dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
                    robot.shakeMouse();
                    TableTester.this.selectCellByColValue(row, rowOperator, value, regex, ValueSets.BinaryChoice.no.rcValue(), searchType, ClickOptions.create().setClickCount(0));
                    return null;
                }
            });
            TableTester.waitBeforeDrop((int)delayBeforeDrop);
        }
        finally {
            robot.mouseRelease(dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
        }
    }

    public void rcVerifyCheckboxInSelectedRow(final boolean checked, int timeout) throws StepExecutionException {
        CheckWithTimeoutQueuer.invokeAndWait((String)"rcVerifyCheckBoxInSelectedRow", (long)timeout, (Runnable)new Runnable(){

            public void run() {
                int row = ((ITableComponent)TableTester.this.getComponent()).getSelectedCell().getRow();
                TableTester.this.verifyCheckboxInRow(checked, row);
            }
        });
    }

    public void rcVerifyCheckboxInRowAtMousePosition(final boolean checked, int timeout) {
        CheckWithTimeoutQueuer.invokeAndWait((String)"rcVerifyCheckboxInRowAtMousePosition", (long)timeout, (Runnable)new Runnable(){

            public void run() {
                int row = TableTester.this.getCellAtMousePosition().getRow();
                TableTester.this.verifyCheckboxInRow(checked, row);
            }
        });
    }

    private void verifyCheckboxInRow(boolean checked, final int row) {
        Boolean checkIndex = (Boolean)this.getEventThreadQueuer().invokeAndWait("rcVerifyTableCheckboxIndex", (IRunnable)new IRunnable<Boolean>(){

            public Boolean run() throws StepExecutionException {
                Control cont = (Control)TableTester.this.getComponent().getRealComponent();
                if ((cont.getStyle() & 0x20) == 0) {
                    throw new StepExecutionException("No checkbox found", EventFactory.createActionError((String)"TestErrorEvent.CheckboxNotFound"));
                }
                return TableTester.this.getSWTAdapter().isChecked(row);
            }
        });
        Verifier.equals((boolean)checked, (boolean)checkIndex);
    }

    public void rcToggleCheckboxInRowAtMousePosition() {
        this.toggleCheckboxInRow(this.getCellAtMousePosition().getRow());
    }

    public void rcToggleCheckboxInSelectedRow() {
        int row = (Integer)this.getEventThreadQueuer().invokeAndWait("get Selection index", (IRunnable)new IRunnable<Integer>(){

            public Integer run() throws StepExecutionException {
                return TableTester.this.getSWTAdapter().getSelectionIndex();
            }
        });
        this.toggleCheckboxInRow(row);
    }

    public void rcReplaceText(String text) throws StepExecutionException {
        super.rcReplaceText(text);
        this.getRobot().keyType(null, 13);
    }

    public void rcReplaceText(String text, String row, String rowOperator, String col, String colOperator) {
        super.rcReplaceText(text, row, rowOperator, col, colOperator);
        this.getRobot().keyType(null, 13);
    }

    private void toggleCheckboxInRow(final int row) {
        if (row == -1) {
            this.getEventThreadQueuer().invokeAndWait("No Selection", (IRunnable)new IRunnable<Void>(){

                public Void run() throws StepExecutionException {
                    throw new StepExecutionException("No Selection found ", EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
                }
            });
        }
        Rectangle rect = ((ITableComponent)this.getComponent()).scrollCellToVisible(row, 0);
        org.eclipse.swt.graphics.Rectangle itemBounds = (org.eclipse.swt.graphics.Rectangle)this.getEventThreadQueuer().invokeAndWait("getTableItem", (IRunnable)new IRunnable<org.eclipse.swt.graphics.Rectangle>(){

            public org.eclipse.swt.graphics.Rectangle run() throws StepExecutionException {
                Control comp = (Control)TableTester.this.getRealComponent();
                if (comp instanceof Table) {
                    return ((Table)comp).getItem(row).getBounds();
                }
                if (comp instanceof Tree) {
                    return ((Tree)comp).getItem(row).getBounds();
                }
                return null;
            }
        });
        org.eclipse.swt.graphics.Rectangle cbxBounds = new org.eclipse.swt.graphics.Rectangle(0, itemBounds.y, rect.x, itemBounds.height);
        this.getRobot().click(this.getComponent().getRealComponent(), (Object)cbxBounds, ClickOptions.create().left().setScrollToVisible(false), rect.x / 2, true, itemBounds.height / 2, true);
    }

    protected Object getNodeAtMousePosition() throws StepExecutionException {
        return this.getCellAtMousePosition();
    }

    public void setAdapter(TableAdapter adapter) {
        this.setAdapter(adapter);
    }
}

