/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the Application component from the concrete toolkit.
 * 
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ComponentClassGenerator", 
           date =  "2022-01-21T11:44:44.790Z")
public class Application implements org.eclipse.jubula.toolkit.concrete.components.Application {
            public Application() {
                super();
            }
    
    protected IComponentIdentifier getPseudoComponentIdentifier() {
        return null;
    }
    
        /**
         * Performs arbitrary clicks into the currently active AUT window
         * @param numberOfClicks 
         *        the amount of interactions
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP clickInActiveWindow(@NonNull Integer numberOfClicks,@NonNull InteractionMode mouseButton,@NonNull Integer xPosition,@NonNull Unit xUnits,@NonNull Integer yPosition,@NonNull Unit yUnits
        ) throws IllegalArgumentException {
            Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcClickDirect")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(numberOfClicks)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(xPosition)
                        .addParameter(xUnits.rcValue())
                        .addParameter(yPosition)
                        .addParameter(yUnits.rcValue())
                        .build();
        }
        
        /**
         * 
         * @param activationMethod 
         *        the AUT activation method to use
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP activate(@NonNull AUTActivationMethod activationMethod
        ) throws IllegalArgumentException {
            Validate.notNull(activationMethod, "Argument 'activationMethod' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcActivate")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(activationMethod.rcValue())
                        .build();
        }
        
        /**
         * 
         * @param text 
         *        the text to use
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP inputText(@NonNull String text
        ) throws IllegalArgumentException {
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcInputText")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(text)
                        .build();
        }
        
        /**
         * 
         * @param modifierKeys 
         *        the modifier keys
         * @param baseKey 
         *        the base key to use
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP keyCombination(@NonNull Modifier[] modifierKeys,@NonNull String baseKey
        ) throws IllegalArgumentException {
            Validate.notNull(modifierKeys, "Argument 'modifierKeys' must not be null"); //$NON-NLS-1$
            Validate.noNullElements(modifierKeys, "Elements of argument 'modifierKeys' must not be null"); //$NON-NLS-1$
            Validate.notNull(baseKey, "Argument 'baseKey' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcKeyStroke")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(StringUtils.join(modifierKeys, TestDataConstants.COMBI_VALUE_SEPARATOR))
                        .addParameter(baseKey)
                        .build();
        }
        
        /**
         * 
         * @param key 
         *        the toggle key
         * @param activateKey 
         *        the activate key
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP setToggleKey(@NonNull Integer key,@NonNull Boolean activateKey
        ) throws IllegalArgumentException {
            Validate.notNull(key, "Argument 'key' must not be null"); //$NON-NLS-1$
            Validate.notNull(activateKey, "Argument 'activateKey' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcToggle")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(key)
                        .addParameter(activateKey)
                        .build();
        }
        
        /**
         * 
         * @param millisecs 
         *        the amount of milliseconds
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP delay(@NonNull Integer millisecs
        ) throws IllegalArgumentException {
            Validate.notNull(millisecs, "Argument 'millisecs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcWait")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(millisecs)
                        .build();
        }
        
        /**
         * 
         * 
         */
        @NonNull public CAP pauseTestExecution(
        )  {
            
            return new CapBuilder("rcPause")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .build();
        }
        
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @param delayAfterVisibility 
         *        the static delay after the component became visible
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP waitForWindow(@NonNull String title,@NonNull Operator operator,@NonNull Integer timeoutInMs,@NonNull Integer delayAfterVisibility
        ) throws IllegalArgumentException {
            Validate.notNull(title, "Argument 'title' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            Validate.notNull(delayAfterVisibility, "Argument 'delayAfterVisibility' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcWaitForWindow")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(title)
                        .addParameter(operator.rcValue())
                        .addParameter(timeoutInMs)
                        .addParameter(delayAfterVisibility)
                        .build();
        }
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param delayAfterVisibility 
         *        the static delay after the component became visible
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP waitForWindow(@NonNull String title,@NonNull Operator operator,@NonNull Integer delayAfterVisibility
        ) throws IllegalArgumentException {
            Validate.notNull(title, "Argument 'title' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(delayAfterVisibility, "Argument 'delayAfterVisibility' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcWaitForWindow")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(title)
                        .addParameter(operator.rcValue())
                        .addParameter(1000)
                        .addParameter(delayAfterVisibility)
                        .build();
        }
        
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @param delayAfterVisibility 
         *        the static delay after the component became visible
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP waitForWindowActivation(@NonNull String title,@NonNull Operator operator,@NonNull Integer timeoutInMs,@NonNull Integer delayAfterVisibility
        ) throws IllegalArgumentException {
            Validate.notNull(title, "Argument 'title' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            Validate.notNull(delayAfterVisibility, "Argument 'delayAfterVisibility' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcWaitForWindowActivation")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(title)
                        .addParameter(operator.rcValue())
                        .addParameter(timeoutInMs)
                        .addParameter(delayAfterVisibility)
                        .build();
        }
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param delayAfterVisibility 
         *        the static delay after the component became visible
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP waitForWindowActivation(@NonNull String title,@NonNull Operator operator,@NonNull Integer delayAfterVisibility
        ) throws IllegalArgumentException {
            Validate.notNull(title, "Argument 'title' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(delayAfterVisibility, "Argument 'delayAfterVisibility' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcWaitForWindowActivation")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(title)
                        .addParameter(operator.rcValue())
                        .addParameter(1000)
                        .addParameter(delayAfterVisibility)
                        .build();
        }
        
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @param delayAfterClosure 
         *        the static delay after closure
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP waitForWindowToClose(@NonNull String title,@NonNull Operator operator,@NonNull Integer timeoutInMs,@NonNull Integer delayAfterClosure
        ) throws IllegalArgumentException {
            Validate.notNull(title, "Argument 'title' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            Validate.notNull(delayAfterClosure, "Argument 'delayAfterClosure' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcWaitForWindowToClose")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(title)
                        .addParameter(operator.rcValue())
                        .addParameter(timeoutInMs)
                        .addParameter(delayAfterClosure)
                        .build();
        }
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param delayAfterClosure 
         *        the static delay after closure
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP waitForWindowToClose(@NonNull String title,@NonNull Operator operator,@NonNull Integer delayAfterClosure
        ) throws IllegalArgumentException {
            Validate.notNull(title, "Argument 'title' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(delayAfterClosure, "Argument 'delayAfterClosure' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcWaitForWindowToClose")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(title)
                        .addParameter(operator.rcValue())
                        .addParameter(1000)
                        .addParameter(delayAfterClosure)
                        .build();
        }
        
        
        
        
        /**
         * 
         * @param destination 
         *        the destination to use
         * @param delay 
         *        the static delay
         * @param fileAccess 
         *        the file access type
         * @param scalingFactor 
         *        the scaling factor
         * @param createDirectories 
         *        whether to implicitly create directories
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP takeScreenshot(@NonNull String destination,@NonNull Integer delay,@NonNull String fileAccess,@NonNull Integer scalingFactor,@NonNull Boolean createDirectories
        ) throws IllegalArgumentException {
            Validate.notNull(destination, "Argument 'destination' must not be null"); //$NON-NLS-1$
            Validate.notNull(delay, "Argument 'delay' must not be null"); //$NON-NLS-1$
            Validate.notNull(fileAccess, "Argument 'fileAccess' must not be null"); //$NON-NLS-1$
            Validate.notNull(scalingFactor, "Argument 'scalingFactor' must not be null"); //$NON-NLS-1$
            Validate.notNull(createDirectories, "Argument 'createDirectories' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcTakeScreenshot")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(destination)
                        .addParameter(delay)
                        .addParameter(fileAccess)
                        .addParameter(scalingFactor)
                        .addParameter(createDirectories)
                        .build();
        }
        
        
        /**
         * 
         * @param modifierKeys 
         *        the modifier keys
         * @param baseKey 
         *        the base key to use
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP externalKeyCombination(@NonNull Modifier[] modifierKeys,@NonNull String baseKey
        ) throws IllegalArgumentException {
            Validate.notNull(modifierKeys, "Argument 'modifierKeys' must not be null"); //$NON-NLS-1$
            Validate.noNullElements(modifierKeys, "Elements of argument 'modifierKeys' must not be null"); //$NON-NLS-1$
            Validate.notNull(baseKey, "Argument 'baseKey' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcNativeKeyStroke")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(StringUtils.join(modifierKeys, TestDataConstants.COMBI_VALUE_SEPARATOR))
                        .addParameter(baseKey)
                        .build();
        }
        
        /**
         * 
         * @param text 
         *        the text to use
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP externalInputText(@NonNull String text
        ) throws IllegalArgumentException {
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcNativeInputText")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(text)
                        .build();
        }
        
        
        
        
        /**
         * 
         * @param text 
         *        the text to use
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP copyTextToClipboard(@NonNull String text
        ) throws IllegalArgumentException {
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcCopyToClipboard")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(text)
                        .build();
        }
        
        
        
        /**
         * 
         * @param value1 
         *        the first value
         * @param comparisonMethod 
         *        the comparison method
         * @param value2 
         *        the second value
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.0
         */
        @NonNull public CAP checkNumericValues(@NonNull String value1,@NonNull NumberComparisonOperator comparisonMethod,@NonNull String value2
        ) throws IllegalArgumentException {
            Validate.notNull(value1, "Argument 'value1' must not be null"); //$NON-NLS-1$
            Validate.notNull(comparisonMethod, "Argument 'comparisonMethod' must not be null"); //$NON-NLS-1$
            Validate.notNull(value2, "Argument 'value2' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcCheckValues")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(value1)
                        .addParameter(comparisonMethod.rcValue())
                        .addParameter(value2)
                        .build();
        }
        
        /**
         * 
         * @param destination 
         *        the destination to use
         * @param delay 
         *        the static delay
         * @param fileAccess 
         *        the file access type
         * @param scalingFactor 
         *        the scaling factor
         * @param createDirectories 
         *        whether to implicitly create directories
         * @param marginTop 
         *        the top margin
         * @param marginRight 
         *        the right margin
         * @param marginBottom 
         *        the bottom margin
         * @param marginLeft 
         *        the left margin
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP takeScreenshotOfActiveWindow(@NonNull String destination,@NonNull Integer delay,@NonNull String fileAccess,@NonNull Integer scalingFactor,@NonNull Boolean createDirectories,@NonNull Integer marginTop,@NonNull Integer marginRight,@NonNull Integer marginBottom,@NonNull Integer marginLeft
        ) throws IllegalArgumentException {
            Validate.notNull(destination, "Argument 'destination' must not be null"); //$NON-NLS-1$
            Validate.notNull(delay, "Argument 'delay' must not be null"); //$NON-NLS-1$
            Validate.notNull(fileAccess, "Argument 'fileAccess' must not be null"); //$NON-NLS-1$
            Validate.notNull(scalingFactor, "Argument 'scalingFactor' must not be null"); //$NON-NLS-1$
            Validate.notNull(createDirectories, "Argument 'createDirectories' must not be null"); //$NON-NLS-1$
            Validate.notNull(marginTop, "Argument 'marginTop' must not be null"); //$NON-NLS-1$
            Validate.notNull(marginRight, "Argument 'marginRight' must not be null"); //$NON-NLS-1$
            Validate.notNull(marginBottom, "Argument 'marginBottom' must not be null"); //$NON-NLS-1$
            Validate.notNull(marginLeft, "Argument 'marginLeft' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcTakeScreenshotOfActiveWindow")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(destination)
                        .addParameter(delay)
                        .addParameter(fileAccess)
                        .addParameter(scalingFactor)
                        .addParameter(createDirectories)
                        .addParameter(marginTop)
                        .addParameter(marginRight)
                        .addParameter(marginBottom)
                        .addParameter(marginLeft)
                        .build();
        }
        
        /**
         * 
         * @param value1 
         *        the first value
         * @param value2Operator 
         *        the operator used for comparison with value 2
         * @param value2 
         *        the second value
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP checkStringValues(@NonNull String value1,@NonNull String value2Operator,@NonNull String value2
        ) throws IllegalArgumentException {
            Validate.notNull(value1, "Argument 'value1' must not be null"); //$NON-NLS-1$
            Validate.notNull(value2Operator, "Argument 'value2Operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(value2, "Argument 'value2' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcCheckStringValues")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(value1)
                        .addParameter(value2Operator)
                        .addParameter(value2)
                        .build();
        }
        
        /**
         * 
         * @param operator 
         *        the operator used for comparison
         * @param text 
         *        the text to use
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkTextInClipboard(@NonNull Operator operator,@NonNull String text
        ) throws IllegalArgumentException {
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcCheckClipboard")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(operator.rcValue())
                        .addParameter(text)
                        .build();
        }
        
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether the component is expected to exist or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkExistenceOfWindow(@NonNull String title,@NonNull Operator operator,@NonNull Boolean exists,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(title, "Argument 'title' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcCheckExistenceOfWindow")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(title)
                        .addParameter(operator.rcValue())
                        .addParameter(exists)
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether the component is expected to exist or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkExistenceOfWindow(@NonNull String title,@NonNull Operator operator,@NonNull Boolean exists
        ) throws IllegalArgumentException {
            Validate.notNull(title, "Argument 'title' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcCheckExistenceOfWindow")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(title)
                        .addParameter(operator.rcValue())
                        .addParameter(exists)
                        .addParameter(0)
                        .build();
        }
        
        
} 