/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.internal.impl.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Class representing the ReflectionComponentActionHandler component from the concrete toolkit.
 * @since 4.0
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2022-01-21T11:44:44.882Z")
public class ReflectionComponentActionHandler implements org.eclipse.jubula.toolkit.concrete.components.handler.ReflectionComponentActionHandler {
            public ReflectionComponentActionHandler() {
                super();
            }
    
    protected IComponentIdentifier getPseudoComponentIdentifier() {
        return null;
    }
    
        
        /**
         * 
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result invokeMethodStoreReturnValue(
            @Nullable String fullyQualifiedClassName,
            @Nullable String methodName,
            @Nullable String methodSignature,
            @Nullable String methodArguments,
            @Nullable String methodArgumentSeparator,
            @Nullable Integer timeoutInMs
        )  {
            if (fullyQualifiedClassName == null) return null;
            
            if (methodName == null) return null;
            
            
            
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcInvokeMethodStoreReturnApi")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(fullyQualifiedClassName)
                            .addParameter(methodName)
                            .addOptionalParameter(methodSignature)
                            .addOptionalParameter(methodArguments)
                            .addOptionalParameter(methodArgumentSeparator)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @since 4.1
         */
        public Result invokeMethodStoreReturnValue(
            @Nullable String fullyQualifiedClassName,
            @Nullable String methodName,
            @Nullable String methodSignature,
            @Nullable String methodArguments,
            @Nullable String methodArgumentSeparator
        )  {
            if (fullyQualifiedClassName == null) return null;
            
            if (methodName == null) return null;
            
            
            
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcInvokeMethodStoreReturnApi")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(fullyQualifiedClassName)
                            .addParameter(methodName)
                            .addOptionalParameter(methodSignature)
                            .addOptionalParameter(methodArguments)
                            .addOptionalParameter(methodArgumentSeparator)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result invokeMethod(
            @Nullable String fullyQualifiedClassName,
            @Nullable String methodName,
            @Nullable String methodSignature,
            @Nullable String methodArguments,
            @Nullable String methodArgumentSeparator,
            @Nullable Integer timeoutInMs
        )  {
            if (fullyQualifiedClassName == null) return null;
            
            if (methodName == null) return null;
            
            
            
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcInvokeMethod")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(fullyQualifiedClassName)
                            .addParameter(methodName)
                            .addOptionalParameter(methodSignature)
                            .addOptionalParameter(methodArguments)
                            .addOptionalParameter(methodArgumentSeparator)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @since 4.1
         */
        public Result invokeMethod(
            @Nullable String fullyQualifiedClassName,
            @Nullable String methodName,
            @Nullable String methodSignature,
            @Nullable String methodArguments,
            @Nullable String methodArgumentSeparator
        )  {
            if (fullyQualifiedClassName == null) return null;
            
            if (methodName == null) return null;
            
            
            
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcInvokeMethod")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(fullyQualifiedClassName)
                            .addParameter(methodName)
                            .addOptionalParameter(methodSignature)
                            .addOptionalParameter(methodArguments)
                            .addOptionalParameter(methodArgumentSeparator)
                            .addParameter(0)
                            .build(), null);
        }
        
        
        /**
         * 
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result invokeExternalMethodStoreReturnValue(
            @Nullable String fullyQualifiedClassName,
            @Nullable String methodName,
            @Nullable String methodSignature,
            @Nullable String methodArguments,
            @Nullable String methodArgumentSeparator,
            @Nullable Integer timeoutInMs
        )  {
            if (fullyQualifiedClassName == null) return null;
            
            if (methodName == null) return null;
            
            
            
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcInvokeExternalMethodStoreReturnApi")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(fullyQualifiedClassName)
                            .addParameter(methodName)
                            .addOptionalParameter(methodSignature)
                            .addOptionalParameter(methodArguments)
                            .addOptionalParameter(methodArgumentSeparator)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @since 4.1
         */
        public Result invokeExternalMethodStoreReturnValue(
            @Nullable String fullyQualifiedClassName,
            @Nullable String methodName,
            @Nullable String methodSignature,
            @Nullable String methodArguments,
            @Nullable String methodArgumentSeparator
        )  {
            if (fullyQualifiedClassName == null) return null;
            
            if (methodName == null) return null;
            
            
            
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcInvokeExternalMethodStoreReturnApi")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(fullyQualifiedClassName)
                            .addParameter(methodName)
                            .addOptionalParameter(methodSignature)
                            .addOptionalParameter(methodArguments)
                            .addOptionalParameter(methodArgumentSeparator)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result invokeExternalMethod(
            @Nullable String fullyQualifiedClassName,
            @Nullable String methodName,
            @Nullable String methodSignature,
            @Nullable String methodArguments,
            @Nullable String methodArgumentSeparator,
            @Nullable Integer timeoutInMs
        )  {
            if (fullyQualifiedClassName == null) return null;
            
            if (methodName == null) return null;
            
            
            
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcInvokeExternalMethod")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(fullyQualifiedClassName)
                            .addParameter(methodName)
                            .addOptionalParameter(methodSignature)
                            .addOptionalParameter(methodArguments)
                            .addOptionalParameter(methodArgumentSeparator)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @since 4.1
         */
        public Result invokeExternalMethod(
            @Nullable String fullyQualifiedClassName,
            @Nullable String methodName,
            @Nullable String methodSignature,
            @Nullable String methodArguments,
            @Nullable String methodArgumentSeparator
        )  {
            if (fullyQualifiedClassName == null) return null;
            
            if (methodName == null) return null;
            
            
            
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcInvokeExternalMethod")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(fullyQualifiedClassName)
                            .addParameter(methodName)
                            .addOptionalParameter(methodSignature)
                            .addOptionalParameter(methodArguments)
                            .addOptionalParameter(methodArgumentSeparator)
                            .addParameter(0)
                            .build(), null);
        }
        
} 