/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.components.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Interface representing the TabComponentActionHandler component from the concrete toolkit.
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 * @since 4.0
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2022-01-21T11:44:44.835Z")
public interface TabComponentActionHandler extends org.eclipse.jubula.toolkit.base.components.handler.GraphicsComponentActionHandler {
    
    
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkSelectionOfTabByValue(
            @Nullable String title,
            @Nullable Operator operator,
            @Nullable Boolean selected,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param selected 
         *        whether the component is expected to be selected or not
         * @since 4.1
         */
        public Result checkSelectionOfTabByValue(
            @Nullable String title,
            @Nullable Operator operator,
            @Nullable Boolean selected
        ) ;
        
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * 
         */
        public Result selectTabByValue(
            @Nullable String title,
            @Nullable Operator operator
        ) ;
        
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkEnablementOfTabByValue(
            @Nullable String title,
            @Nullable Operator operator,
            @Nullable Boolean enabled,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @since 4.1
         */
        public Result checkEnablementOfTabByValue(
            @Nullable String title,
            @Nullable Operator operator,
            @Nullable Boolean enabled
        ) ;
        
        /**
         * 
         * @param index 
         *        the 1-based index
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkSelectionOfTabByIndex(
            @Nullable Integer index,
            @Nullable Boolean selected,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param index 
         *        the 1-based index
         * @param selected 
         *        whether the component is expected to be selected or not
         * @since 4.1
         */
        public Result checkSelectionOfTabByIndex(
            @Nullable Integer index,
            @Nullable Boolean selected
        ) ;
        
        /**
         * 
         * @param index 
         *        the 1-based index
         * 
         */
        public Result selectTabByIndex(
            @Nullable Integer index
        ) ;
        
        /**
         * 
         * @param index 
         *        the 1-based index
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkEnablementOfTabByIndex(
            @Nullable Integer index,
            @Nullable Boolean enabled,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param index 
         *        the 1-based index
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @since 4.1
         */
        public Result checkEnablementOfTabByIndex(
            @Nullable Integer index,
            @Nullable Boolean enabled
        ) ;
        
        /**
         * 
         * @param index 
         *        the 1-based index
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkTextOfTabByIndex(
            @Nullable Integer index,
            @Nullable String title,
            @Nullable Operator operator,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param index 
         *        the 1-based index
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @since 4.1
         */
        public Result checkTextOfTabByIndex(
            @Nullable Integer index,
            @Nullable String title,
            @Nullable Operator operator
        ) ;
        
        /**
         * 
         * @param tab 
         *        the tab
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkExistenceOfTab(
            @Nullable String tab,
            @Nullable Operator operator,
            @Nullable Boolean exists,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param tab 
         *        the tab
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @since 4.1
         */
        public Result checkExistenceOfTab(
            @Nullable String tab,
            @Nullable Operator operator,
            @Nullable Boolean exists
        ) ;
        
} 