/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

public class DoubleList {
    private double[] _array;
    private int _limit;
    private static final int _default_size = 128;

    public DoubleList() {
        this(128);
    }

    public DoubleList(DoubleList list) {
        this(list._array.length);
        System.arraycopy(list._array, 0, this._array, 0, this._array.length);
        this._limit = list._limit;
    }

    public DoubleList(int initialCapacity) {
        this._array = new double[initialCapacity];
        this._limit = 0;
    }

    public void add(int index, double value) {
        if (index > this._limit) {
            throw new IndexOutOfBoundsException();
        }
        if (index == this._limit) {
            this.add(value);
        } else {
            if (this._limit == this._array.length) {
                this.growArray(this._limit * 2);
            }
            System.arraycopy(this._array, index, this._array, index + 1, this._limit - index);
            this._array[index] = value;
            ++this._limit;
        }
    }

    public boolean add(double value) {
        if (this._limit == this._array.length) {
            this.growArray(this._limit * 2);
        }
        this._array[this._limit++] = value;
        return true;
    }

    public boolean addAll(DoubleList c) {
        if (c._limit != 0) {
            if (this._limit + c._limit > this._array.length) {
                this.growArray(this._limit + c._limit);
            }
            System.arraycopy(c._array, 0, this._array, this._limit, c._limit);
            this._limit += c._limit;
        }
        return true;
    }

    public boolean addAll(int index, DoubleList c) {
        if (index > this._limit) {
            throw new IndexOutOfBoundsException();
        }
        if (c._limit != 0) {
            if (this._limit + c._limit > this._array.length) {
                this.growArray(this._limit + c._limit);
            }
            System.arraycopy(this._array, index, this._array, index + c._limit, this._limit - index);
            System.arraycopy(c._array, 0, this._array, index, c._limit);
            this._limit += c._limit;
        }
        return true;
    }

    public void clear() {
        this._limit = 0;
    }

    public boolean contains(double o) {
        boolean rval = false;
        int j = 0;
        while (!rval && j < this._limit) {
            if (this._array[j] == o) {
                rval = true;
            }
            ++j;
        }
        return rval;
    }

    public boolean containsAll(DoubleList c) {
        boolean rval = true;
        if (this != c) {
            int j = 0;
            while (rval && j < c._limit) {
                if (!this.contains(c._array[j])) {
                    rval = false;
                }
                ++j;
            }
        }
        return rval;
    }

    public boolean equals(Object o) {
        boolean rval;
        boolean bl = rval = this == o;
        if (!rval && o != null && o.getClass() == this.getClass()) {
            DoubleList other = (DoubleList)o;
            if (other._limit == this._limit) {
                rval = true;
                int j = 0;
                while (rval && j < this._limit) {
                    rval = this._array[j] == other._array[j];
                    ++j;
                }
            }
        }
        return rval;
    }

    public double get(int index) {
        if (index >= this._limit) {
            throw new IndexOutOfBoundsException();
        }
        return this._array[index];
    }

    public int hashCode() {
        int hash = 0;
        int j = 0;
        while (j < this._limit) {
            hash = 31 * hash + (int)this._array[j];
            ++j;
        }
        return hash;
    }

    public int indexOf(double o) {
        int rval = 0;
        while (rval < this._limit) {
            if (o == this._array[rval]) break;
            ++rval;
        }
        if (rval == this._limit) {
            rval = -1;
        }
        return rval;
    }

    public boolean isEmpty() {
        return this._limit == 0;
    }

    public int lastIndexOf(double o) {
        int rval = this._limit - 1;
        while (rval >= 0) {
            if (o == this._array[rval]) break;
            --rval;
        }
        return rval;
    }

    public double remove(int index) {
        if (index >= this._limit) {
            throw new IndexOutOfBoundsException();
        }
        double rval = this._array[index];
        System.arraycopy(this._array, index + 1, this._array, index, this._limit - index);
        --this._limit;
        return rval;
    }

    public boolean removeValue(double o) {
        boolean rval = false;
        int j = 0;
        while (!rval && j < this._limit) {
            if (o == this._array[j]) {
                System.arraycopy(this._array, j + 1, this._array, j, this._limit - j);
                --this._limit;
                rval = true;
            }
            ++j;
        }
        return rval;
    }

    public boolean removeAll(DoubleList c) {
        boolean rval = false;
        int j = 0;
        while (j < c._limit) {
            if (this.removeValue(c._array[j])) {
                rval = true;
            }
            ++j;
        }
        return rval;
    }

    public boolean retainAll(DoubleList c) {
        boolean rval = false;
        int j = 0;
        while (j < this._limit) {
            if (!c.contains(this._array[j])) {
                this.remove(j);
                rval = true;
                continue;
            }
            ++j;
        }
        return rval;
    }

    public double set(int index, double element) {
        if (index >= this._limit) {
            throw new IndexOutOfBoundsException();
        }
        double rval = this._array[index];
        this._array[index] = element;
        return rval;
    }

    public int size() {
        return this._limit;
    }

    public double[] toArray() {
        double[] rval = new double[this._limit];
        System.arraycopy(this._array, 0, rval, 0, this._limit);
        return rval;
    }

    public double[] toArray(double[] a) {
        double[] rval;
        if (a.length == this._limit) {
            System.arraycopy(this._array, 0, a, 0, this._limit);
            rval = a;
        } else {
            rval = this.toArray();
        }
        return rval;
    }

    private void growArray(int new_size) {
        int size = new_size == this._array.length ? new_size + 1 : new_size;
        double[] new_array = new double[size];
        System.arraycopy(this._array, 0, new_array, 0, this._limit);
        this._array = new_array;
    }
}

