/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.commands;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jubula.autagent.commands.AbstractStartToolkitAut;
import org.eclipse.jubula.autagent.monitoring.IMonitoring;
import org.eclipse.jubula.autagent.monitoring.MonitoringDataStore;
import org.eclipse.jubula.communication.message.StartAUTServerStateMessage;
import org.eclipse.jubula.tools.jarutils.MainClassLocator;
import org.eclipse.jubula.tools.utils.MonitoringUtil;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStartJavaAut
extends AbstractStartToolkitAut {
    protected static final String JAVA_OPTIONS_INTRO = "_JAVA_OPTIONS=";
    private static final String JAVA_LANGUAGE_PROPERTY = "-Duser.language=";
    private static final String JAVA_COUNTRY_PROPERTY = "-Duser.country=";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractStartJavaAut.class);

    @Override
    protected String createBaseCmd(Map parameters) throws IOException {
        String executableFileName = (String)parameters.get("EXECUTABLE");
        if (executableFileName != null && executableFileName.length() > 0) {
            File exe = new File(executableFileName);
            if (!exe.isAbsolute()) {
                exe = new File((String)parameters.get("WORKING_DIR"), executableFileName);
            }
            if (exe.isFile() && exe.exists()) {
                return exe.getCanonicalPath();
            }
            String errorMsg = String.valueOf(executableFileName) + " does not point to a valid executable.";
            LOG.warn(errorMsg);
            return executableFileName;
        }
        String java = "";
        String jre = (String)parameters.get("JRE_BINARY");
        if (jre == null) {
            jre = "";
        }
        File jreFile = new File(jre);
        if (jre.length() == 0) {
            java = "java";
        } else {
            if (!jreFile.isAbsolute()) {
                jreFile = new File(this.getWorkingDir(parameters), jre);
            }
            if (jreFile.isFile() && jreFile.exists()) {
                java = jreFile.getCanonicalPath();
            } else {
                String errorMsg = jreFile + " does not point to a valid JRE executable.";
                LOG.error(errorMsg);
                throw new FileNotFoundException(errorMsg);
            }
        }
        return java;
    }

    protected String getAUTMainClass(Map parameters) {
        String autClassName = (String)parameters.get("CLASSNAME");
        if (autClassName != null && autClassName.length() > 0) {
            return autClassName;
        }
        String jarFile = (String)parameters.get("JAR_FILE");
        String mainClass = this.getMainClassFromManifest(parameters);
        if (mainClass != null) {
            return mainClass;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("neither main class transmitted nor found in the manifest, searching in jar: '" + String.valueOf(jarFile) + "'");
        }
        if (jarFile != null && jarFile.length() > 0) {
            List mains;
            block10: {
                block9: {
                    mains = MainClassLocator.getMainClass((File)new File(jarFile));
                    if (mains.size() != 0) break block9;
                    String message = "no main class found in '" + jarFile + "'";
                    LOG.error(message);
                    this.setErrorMessage(new StartAUTServerStateMessage(6, message));
                    return null;
                }
                if (mains.size() == 1) break block10;
                String message = "more than on main class found";
                LOG.error(message);
                this.setErrorMessage(new StartAUTServerStateMessage(7, message));
                return null;
            }
            try {
                return ((String)mains.get(0)).replace('/', '.');
            }
            catch (NullPointerException npe) {
                String message = "no jar given as classpath";
                LOG.error(message, (Throwable)npe);
                this.setErrorMessage(new StartAUTServerStateMessage(8, message));
                return null;
            }
            catch (IOException ioe) {
                String message = "scanning '" + String.valueOf(jarFile) + "' for main class failed";
                LOG.error(message, (Throwable)ioe);
                this.setErrorMessage(new StartAUTServerStateMessage(9, message));
                return null;
            }
        }
        return null;
    }

    private String getMainClassFromManifest(Map parameters) {
        String jarFile = this.createAbsoluteJarPath(parameters);
        return this.getAttributeFromManifest("main-class", jarFile);
    }

    private String getAttributeFromManifest(String attributeName, String jarFile) {
        if (jarFile == null || jarFile.length() < 1) {
            return null;
        }
        String attribute = null;
        try {
            JarFile jar = new JarFile(jarFile);
            Manifest manifest = jar.getManifest();
            if (manifest != null) {
                attribute = manifest.getMainAttributes().getValue(attributeName);
            }
        }
        catch (FileNotFoundException e) {
            LOG.error("File not found: " + jarFile, (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Error reading jar file: " + jarFile, (Throwable)e);
        }
        return attribute;
    }

    private String createAbsoluteJarPath(Map parameters) {
        File jarFile;
        File workingDir = this.getWorkingDir(parameters);
        String jarPath = (String)parameters.get("JAR_FILE");
        if (jarPath != null && jarPath.length() > 0 && workingDir != null && !(jarFile = new File(jarPath)).isAbsolute()) {
            jarPath = workingDir + FILE_SEPARATOR + jarPath;
        }
        return jarPath;
    }

    protected abstract String getServerClassName();

    protected void addLocale(List cmds, Locale locale) {
        if (locale != null) {
            if (locale.getCountry() != null && locale.getCountry().length() > 0) {
                cmds.add(JAVA_COUNTRY_PROPERTY + locale.getCountry());
            }
            if (locale.getLanguage() != null && locale.getLanguage().length() > 0) {
                cmds.add(JAVA_LANGUAGE_PROPERTY + locale.getLanguage());
            }
        }
    }

    protected String getClassPathFromManifest(Map parameters) {
        String jarFile = this.createAbsoluteJarPath(parameters);
        String classPath = this.getAttributeFromManifest("class-path", jarFile);
        if (classPath == null) {
            return "";
        }
        classPath = classPath.trim();
        return classPath.replace(' ', PATH_SEPARATOR.charAt(0));
    }

    protected String convertClientSeparator(String clientPath) {
        return clientPath.replaceAll(";", PATH_SEPARATOR);
    }

    @Override
    protected abstract String[] createCmdArray(String var1, Map var2);

    protected boolean isRunningFromExecutable(Map parameters) {
        return parameters.containsKey("EXECUTABLE");
    }

    protected String setJavaOptions(Map parameters) {
        String monAgent;
        StringBuffer sb = new StringBuffer();
        if (this.isRunningFromExecutable(parameters)) {
            String monAgent2;
            Locale locale = (Locale)parameters.get("LOCALE");
            sb.append(JAVA_OPTIONS_INTRO);
            if (MonitoringUtil.shouldAndCanRunWithMonitoring((Map)parameters) && (monAgent2 = this.getMonitoringAgent(parameters)) != null) {
                sb.append(monAgent2).append(" ");
            }
            sb.append("\"").append("-javaagent:").append(this.getAbsoluteAgentJarPath()).append("\"");
            if (locale != null) {
                sb.append(" ").append(JAVA_COUNTRY_PROPERTY).append(locale.getCountry());
                sb.append(" ").append(JAVA_LANGUAGE_PROPERTY).append(locale.getLanguage());
            }
        } else if (MonitoringUtil.shouldAndCanRunWithMonitoring((Map)parameters) && (monAgent = this.getMonitoringAgent(parameters)) != null) {
            sb.append(JAVA_OPTIONS_INTRO).append(monAgent);
        }
        return sb.toString();
    }

    protected String getAbsoluteAgentJarPath() {
        return AbstractStartToolkitAut.getClasspathForBundleId("org.eclipse.jubula.rc.common.agent");
    }

    public static File getInstallDir() {
        Location installLoc = Platform.getInstallLocation();
        String installDir = installLoc.getURL().getFile();
        return new File(installDir);
    }

    protected String getMonitoringAgent(Map parameters) {
        Bundle bundle;
        String monitoringImplClass;
        String agentString;
        boolean duplicate;
        MonitoringDataStore mds;
        String autId;
        block12: {
            autId = (String)parameters.get("AUT_ID");
            mds = MonitoringDataStore.getInstance();
            duplicate = org.eclipse.jubula.autagent.monitoring.MonitoringUtil.checkForDuplicateAutID(autId);
            if (!duplicate) {
                mds.putConfigMap(autId, parameters);
            }
            agentString = null;
            monitoringImplClass = (String)parameters.get("AGENT_CLASS");
            String bundleId = (String)parameters.get("BUNDLE_ID");
            bundle = Platform.getBundle((String)bundleId);
            if (bundle != null) break block12;
            LOG.error("No bundle was found for the given bundleId");
            return null;
        }
        try {
            Class monitoringClass = bundle.loadClass(monitoringImplClass);
            Constructor constructor = monitoringClass.getConstructor(new Class[0]);
            IMonitoring agentInstance = (IMonitoring)constructor.newInstance(new Object[0]);
            agentInstance.setAutId(autId);
            agentInstance.setInstallDir(FileLocator.getBundleFile((Bundle)bundle));
            agentString = agentInstance.createAgent();
            if (!duplicate) {
                mds.putMonitoringAgent(autId, agentInstance);
            }
        }
        catch (InstantiationException e) {
            LOG.error("The instantiation of the monitoring class failed ", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error("Access to the monitoring class failed ", (Throwable)e);
        }
        catch (SecurityException e) {
            LOG.error("Access to the monitoring class failed ", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            LOG.error("A method in the monitoring class could not be found", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOG.error("A argument which is passed to monitoring class is invalide", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOG.error("The method call of 'getAgent' failed, you have to implement the interface IMonitoring", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            LOG.error("The monitoring class can not be found", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("IOException while searching for the given bundle", (Throwable)e);
        }
        return agentString;
    }
}

