/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.analyze.ui.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jubula.client.analyze.definition.IAnalyze;
import org.eclipse.jubula.client.analyze.internal.Analyze;
import org.eclipse.jubula.client.analyze.internal.AnalyzeResult;
import org.eclipse.jubula.client.analyze.internal.AnalyzeRun;
import org.eclipse.jubula.client.analyze.ui.i18n.Messages;
import org.eclipse.jubula.client.analyze.ui.internal.QueryResult;
import org.eclipse.jubula.client.analyze.ui.internal.helper.ContextHelper;
import org.eclipse.jubula.client.ui.rcp.search.query.AbstractSearchQuery;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;

public class Query
extends AbstractSearchQuery
implements ISearchQuery {
    private QueryResult m_queryResult;
    private AnalyzeRun m_analyzeRun;

    public Query(AnalyzeRun analyzeRun) {
        this.setAnalyzeRun(analyzeRun);
    }

    protected void setQueryResult(QueryResult queryResult) {
        this.m_queryResult = queryResult;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        try {
            this.calculate(monitor);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
    }

    public void calculate(IProgressMonitor monitor) throws InterruptedException {
        Object node = ContextHelper.getSelection();
        QueryResult qr = new QueryResult(this);
        int workAmount = this.getAnalyzeRun().getAnalyzeRunList().size();
        monitor.beginTask(Messages.RunningAnalyzes, workAmount);
        ArrayList anaList = new ArrayList(this.getAnalyzeRun().getAnalyzeRunList());
        int i = 0;
        while (i < anaList.size()) {
            IAnalyze executableExtension = (IAnalyze)((Analyze)anaList.get(i)).getExecutableExtension();
            monitor.subTask(String.valueOf(Messages.Running) + ((Analyze)anaList.get(i)).getName());
            AnalyzeResult res = executableExtension.execute(node, (IProgressMonitor)new SubProgressMonitor(monitor, 1), ((Analyze)anaList.get(i)).getResultType(), ((Analyze)anaList.get(i)).getAnalyzeParameter(), ((Analyze)anaList.get(i)).getName());
            qr.getResultMap().put((Analyze)anaList.get(i), res);
            ++i;
        }
        this.setQueryResult(qr);
        monitor.done();
    }

    public String getLabel() {
        if (this.getAnalyzeRun().getAnalyzeRunList().size() == 1) {
            return String.valueOf(this.getTimestamp()) + ": " + ((Analyze)this.getAnalyzeRun().getAnalyzeRunList().get(0)).getName();
        }
        return "";
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return false;
    }

    public ISearchResult getSearchResult() {
        return this.m_queryResult;
    }

    public AnalyzeRun getAnalyzeRun() {
        return this.m_analyzeRun;
    }

    public void setAnalyzeRun(AnalyzeRun analyzeRun) {
        this.m_analyzeRun = analyzeRun;
    }
}

