/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.Basic;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.MapKeyColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestDataPO;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="TEST_DATA")
class TestDataPO
implements ITestDataPO,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject {
    public static final int DEFAULT_NUMBER_OF_LANGUAGES = 2;
    private transient Long m_id = null;
    private Map<String, String> m_map = new HashMap<String, String>(2);
    private transient Integer m_version = null;
    private Long m_parentProjectId = null;
    static final long serialVersionUID = 2134415814152748468L;
    protected transient Object _persistence_primaryKey;

    TestDataPO(Map<Locale, String> languageToValue) {
        for (Locale language : languageToValue.keySet()) {
            this.setValue(language, languageToValue.get(language));
        }
    }

    TestDataPO() {
    }

    @Override
    @Id
    @GeneratedValue
    public Long getId() {
        return this.m_id;
    }

    void setId(Long id) {
        this.m_id = id;
    }

    @Override
    @Transient
    public Long getParentProjectId() {
        return this.getHbmParentProjectId();
    }

    @Override
    public void setParentProjectId(Long projectId) {
        this.setHbmParentProjectId(projectId);
    }

    @Basic
    @Column(name="PARENT_PROJ")
    Long getHbmParentProjectId() {
        return this.m_parentProjectId;
    }

    void setHbmParentProjectId(Long projectId) {
        this.m_parentProjectId = projectId;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TestDataPO) {
            TestDataPO otherTestData = (TestDataPO)obj;
            return this.getMap().equals(otherTestData.getMap());
        }
        return false;
    }

    public int hashCode() {
        return this.getMap().hashCode();
    }

    @Override
    @Version
    public Integer getVersion() {
        return this.m_version;
    }

    private void setVersion(Integer version) {
        this.m_version = version;
    }

    @Override
    @Transient
    public String getName() {
        return "";
    }

    @Override
    public ITestDataPO deepCopy() {
        TestDataPO td = new TestDataPO();
        td.getMap().putAll(this.getMap());
        td.setParentProjectId(this.getParentProjectId());
        return td;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="LOCALE_TO_TD")
    @MapKeyColumn(name="LOCALE")
    @Column(name="TD_VALUE", length=4000, nullable=false)
    @JoinColumn(name="I18N_STR")
    private Map<String, String> getMap() {
        return this.m_map;
    }

    void setMap(Map<String, String> map) {
        this.m_map = map;
    }

    @Override
    public void setValue(Locale lang, String value, IProjectPO project) {
        if (this.validateLang(lang, project)) {
            this.setValue(lang, value);
            this.setParentProjectId(project.getId());
        }
    }

    private void setValue(Locale lang, String value) {
        if (value != null && value.length() != 0) {
            this.getMap().put(lang.toString(), value);
        } else {
            this.getMap().remove(lang.toString());
        }
    }

    private boolean validateLang(Locale lang, IProjectPO project) {
        return project.getLangHelper().containsItem(lang);
    }

    @Override
    public String getValue(Locale lang) {
        Validate.notNull((Object)lang);
        return this.getMap().get(lang.toString());
    }

    @Override
    @Transient
    public Set<Locale> getLanguages() {
        HashSet<Locale> supportedLocales = new HashSet<Locale>();
        for (String localeCode : this.getMap().keySet()) {
            supportedLocales.add(LocaleUtils.toLocale((String)localeCode));
        }
        return supportedLocales;
    }

    public String toString() {
        TreeSet<String> sorter = new TreeSet<String>();
        for (Map.Entry<String, String> entry : this.getMap().entrySet()) {
            sorter.add(String.valueOf(entry.getKey()) + ":" + entry.getValue());
        }
        StringBuilder result = new StringBuilder(sorter.size() * 100);
        for (String line : sorter) {
            result.append(line);
            result.append("\n");
        }
        return result.toString();
    }

    @Override
    public void setData(ITestDataPO testData) {
        for (Locale language : testData.getLanguages()) {
            this.setValue(language, testData.getValue(language));
        }
    }

    @Override
    public void clear() {
        this.m_map.clear();
    }

    public Object _persistence_post_clone() {
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new TestDataPO();
    }

    public Object _persistence_get(String string) {
        if (string == "id") {
            return this.id;
        }
        if (string == "hbmParentProjectId") {
            return this.hbmParentProjectId;
        }
        if (string == "map") {
            return this.map;
        }
        if (string == "version") {
            return this.version;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "id") {
            this.id = (Long)object;
            return;
        }
        if (string == "hbmParentProjectId") {
            this.hbmParentProjectId = (Long)object;
            return;
        }
        if (string == "map") {
            this.map = (Map)object;
            return;
        }
        if (string == "version") {
            this.version = (Integer)object;
            return;
        }
    }
}

