/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.persistence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang.Validate;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecObjContPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ISpecObjContPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.IExecPersistable;
import org.eclipse.jubula.client.core.persistence.ISpecPersistable;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMDirtyVersionException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMSaveException;
import org.eclipse.jubula.client.core.persistence.PersistenceManager;
import org.eclipse.jubula.client.core.persistence.PersistenceUtil;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.tools.exception.InvalidDataException;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.exception.JBFatalException;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodePM
extends PersistenceManager {
    private static NodePM nodePersManager = null;
    private static Logger log = LoggerFactory.getLogger(NodePM.class);
    private Map<String, Long> m_projectIDCache = null;
    private Map<String, Object> m_specTCCache = null;
    private EntityManager m_lastSession = null;
    private boolean m_useCache = false;

    public static NodePM getInstance() {
        if (nodePersManager == null) {
            nodePersManager = new NodePM();
        }
        return nodePersManager;
    }

    public static AbstractCmdHandleChild getCmdHandleChild(INodePO parent, INodePO child) {
        Class parentNodePoClass = Persistor.getClass(parent);
        Class childNodePoClass = Persistor.getClass(child);
        if (parent == ISpecObjContPO.TCB_ROOT_NODE) {
            return new CmdHandleChildIntoSpecList();
        }
        if (parent == IExecObjContPO.TSB_ROOT_NODE) {
            return new CmdHandleChildIntoExecList();
        }
        if (Persistor.isPoClassSubclass(parentNodePoClass, ICategoryPO.class)) {
            return new CmdHandleChildIntoNodeList();
        }
        if (Persistor.isPoClassSubclass(parentNodePoClass, ITestSuitePO.class)) {
            return new CmdHandleChildIntoNodeList();
        }
        if (Persistor.isPoClassSubclass(parentNodePoClass, ISpecTestCasePO.class)) {
            if (Persistor.isPoClassSubclass(childNodePoClass, IEventExecTestCasePO.class)) {
                return new CmdHandleEventHandlerIntoMap();
            }
            return new CmdHandleChildIntoNodeList();
        }
        String msg = Messages.UnsupportedINodePOSubclass;
        log.error(msg);
        throw new JBFatalException(msg, MessageIDs.E_UNSUPPORTED_NODE);
    }

    public static void addAndPersistChildNode(INodePO parent, INodePO child, Integer pos, AbstractCmdHandleChild handler) throws PMSaveException, PMAlreadyLockedException, PMException, ProjectDeletedException {
        NodePM.processAndPersistChildNode(parent, child, pos, handler, true);
    }

    private static void processAndPersistChildNode(INodePO parent, INodePO child, Integer pos, AbstractCmdHandleChild handler, boolean doAdd) throws PMException, ProjectDeletedException {
        EntityTransaction tx = null;
        IPersistentObject lockedObj = null;
        GeneralStorage gs = GeneralStorage.getInstance();
        EntityManager sess = gs.getMasterSession();
        IProjectPO currentProject = gs.getProject();
        Persistor persistor = Persistor.instance();
        lockedObj = parent == ISpecObjContPO.TCB_ROOT_NODE ? currentProject.getSpecObjCont() : (parent == IExecObjContPO.TSB_ROOT_NODE ? currentProject.getExecObjCont() : parent);
        try {
            tx = persistor.getTransaction(sess);
            persistor.lockPO(sess, lockedObj);
            if (!doAdd) {
                lockedObj = child;
                persistor.lockPO(sess, lockedObj);
            }
        }
        catch (PersistenceException e) {
            PersistenceManager.handleDBExceptionForMasterSession(lockedObj, e);
        }
        if (doAdd) {
            handler.add(parent, child, pos);
        } else {
            handler.delete(parent, child);
        }
        try {
            if (!doAdd) {
                sess.remove((Object)child);
            }
            persistor.commitTransaction(sess, tx);
        }
        catch (PersistenceException e) {
            PersistenceManager.handleDBExceptionForMasterSession(null, e);
        }
    }

    public static void renameNode(INodePO node, String newName) throws PMDirtyVersionException, PMAlreadyLockedException, PMSaveException, PMException, ProjectDeletedException {
        EntityManager sess = GeneralStorage.getInstance().getMasterSession();
        EntityTransaction tx = null;
        try {
            Persistor persistor = Persistor.instance();
            tx = persistor.getTransaction(sess);
            persistor.lockPO(sess, node);
            node.setName(newName);
            persistor.commitTransaction(sess, tx);
        }
        catch (PersistenceException e) {
            PersistenceManager.handleDBExceptionForMasterSession(node, e);
        }
    }

    public static void addImportedTestCases(ICategoryPO cat, List<? extends INodePO> specObjList) throws PMException, ProjectDeletedException {
        GeneralStorage genStorage = GeneralStorage.getInstance();
        IProjectPO currentProject = genStorage.getProject();
        for (INodePO iNodePO : specObjList) {
            cat.addNode(iNodePO);
        }
        AbstractCmdHandleChild abstractCmdHandleChild = NodePM.getCmdHandleChild(currentProject, cat);
        NodePM.addAndPersistChildNode(currentProject, cat, null, abstractCmdHandleChild);
    }

    public static List<? extends INodePO> computeListOfNodes(Class type, Long parentProjectId, EntityManager s) {
        Assert.isNotNull((Object)type);
        Assert.isNotNull((Object)s);
        CriteriaQuery query = s.getCriteriaBuilder().createQuery();
        Root from = query.from(type);
        query.select((Selection)from).where((Expression)s.getCriteriaBuilder().equal((Expression)from.get("hbmParentProjectId"), (Object)parentProjectId));
        List queryResult = s.createQuery(query).getResultList();
        return queryResult;
    }

    public static List<IExecTestCasePO> getInternalExecTestCases(String specTcGuid, long parentProjectId) {
        if (specTcGuid == null) {
            return new ArrayList<IExecTestCasePO>(0);
        }
        ArrayList<Long> parentProjectIds = new ArrayList<Long>();
        parentProjectIds.add(parentProjectId);
        return NodePM.getExecTestCasesFor(specTcGuid, parentProjectIds, GeneralStorage.getInstance().getMasterSession());
    }

    public static List<IRefTestSuitePO> getInternalRefTestSuites(String tsGuid, long parentProjectId) {
        if (tsGuid == null) {
            return new ArrayList<IRefTestSuitePO>(0);
        }
        ArrayList<Long> parentProjectIds = new ArrayList<Long>();
        parentProjectIds.add(parentProjectId);
        return NodePM.getRefTestSuitesFor(tsGuid, parentProjectIds, GeneralStorage.getInstance().getMasterSession());
    }

    private static synchronized List<IRefTestSuitePO> getRefTestSuitesFor(String tsGuid, List<Long> parentProjectIds, EntityManager s) {
        StringBuffer queryBuffer = new StringBuffer("select ref from RefTestSuitePO as ref where ref.testSuiteGuid = :tsGuid and (");
        for (long id : parentProjectIds) {
            queryBuffer.append("ref.hbmParentProjectId = " + id + " or ");
        }
        queryBuffer.delete(queryBuffer.length() - 4, queryBuffer.length());
        queryBuffer.append(")");
        Query q = s.createQuery(queryBuffer.toString());
        q.setParameter("tsGuid", (Object)tsGuid);
        List execTcList = q.getResultList();
        return execTcList;
    }

    public static List<IExecTestCasePO> getExecTestCases(String specTcGuid, List<Long> parentProjectIds) {
        if (specTcGuid == null) {
            return new ArrayList<IExecTestCasePO>(0);
        }
        return NodePM.getExecTestCasesFor(specTcGuid, parentProjectIds, GeneralStorage.getInstance().getMasterSession());
    }

    public static boolean isReused(ISpecTestCasePO specTc, EntityManager s) {
        boolean result = false;
        Long id = specTc.getId();
        Long parentProj = specTc.getParentProjectId();
        if (id != null) {
            Query query;
            List list;
            if (parentProj == null) {
                parentProj = GeneralStorage.getInstance().getProject().getId();
            }
            result = !(list = (query = s.createNativeQuery("select ID from Node where ID IN (select parent from Node_List where Child IN (select ID from Node where PARENT_PROJ = " + parentProj + " AND SPEC_TC_GUID = " + "(select GUID from Node where id= " + id + "))) AND " + "classid='S'")).setMaxResults(1).getResultList()).isEmpty();
        }
        return result;
    }

    public static List<IExecTestCasePO> getExternalExecTestCases(String specTcGuid, long parentProjectId) throws JBException {
        if (specTcGuid == null) {
            return new ArrayList<IExecTestCasePO>(0);
        }
        EntityManager s = Persistor.instance().openSession();
        try {
            EntityTransaction tx = Persistor.instance().getTransaction(s);
            IProjectPO parentProject = (IProjectPO)s.find(NodeMaker.getProjectPOClass(), (Object)parentProjectId);
            if (parentProject == null) {
                String error = String.valueOf(Messages.ParentProjectDoesNotExistWithID) + ":" + " " + parentProjectId;
                log.error(error);
                throw new JBException(error, MessageIDs.E_DATABASE_GENERAL);
            }
            List<Long> projectsThatReuse = ProjectPM.findIdsThatReuse(parentProject.getGuid(), parentProject.getMajorProjectVersion(), parentProject.getMinorProjectVersion());
            List<IExecTestCasePO> tcList = NodePM.getExecTestCasesFor(specTcGuid, projectsThatReuse, s);
            Persistor.instance().commitTransaction(s, tx);
            List<IExecTestCasePO> list = tcList;
            return list;
        }
        finally {
            Persistor.instance().dropSessionWithoutLockRelease(s);
        }
    }

    private static synchronized List<IExecTestCasePO> getExecTestCasesFor(String specTcGuid, List<Long> parentProjectIds, EntityManager s) {
        StringBuffer queryBuffer = new StringBuffer("select ref from ExecTestCasePO as ref where ref.specTestCaseGuid = :specTcGuid and (");
        for (long id : parentProjectIds) {
            queryBuffer.append("ref.hbmParentProjectId = " + id + " or ");
        }
        queryBuffer.delete(queryBuffer.length() - 4, queryBuffer.length());
        queryBuffer.append(")");
        Query q = s.createQuery(queryBuffer.toString());
        q.setParameter("specTcGuid", (Object)specTcGuid);
        List execTcList = q.getResultList();
        return execTcList;
    }

    public static List<IExecTestCasePO> getAllExecTestCases(String specTcGuid, long parentProjectId) throws JBException {
        if (specTcGuid == null) {
            return new ArrayList<IExecTestCasePO>(0);
        }
        EntityManager s = Persistor.instance().openSession();
        try {
            EntityTransaction tx = Persistor.instance().getTransaction(s);
            IProjectPO parentProject = (IProjectPO)s.find(NodeMaker.getProjectPOClass(), (Object)parentProjectId);
            if (parentProject == null) {
                String error = String.valueOf(Messages.ParentProjectDoesNotExistWithID) + ":" + " " + parentProjectId;
                log.error(error);
                throw new JBException(error, MessageIDs.E_DATABASE_GENERAL);
            }
            List<Long> projectsThatReuse = ProjectPM.findIdsThatReuse(parentProject.getGuid(), parentProject.getMajorProjectVersion(), parentProject.getMinorProjectVersion());
            projectsThatReuse.add(parentProjectId);
            List<IExecTestCasePO> tcList = NodePM.getExecTestCasesFor(specTcGuid, projectsThatReuse, s);
            Persistor.instance().commitTransaction(s, tx);
            List<IExecTestCasePO> list = tcList;
            return list;
        }
        finally {
            Persistor.instance().dropSessionWithoutLockRelease(s);
        }
    }

    public static synchronized List<IExecTestCasePO> getUsedTestCaseNames(IProjectPO project, IReusedProjectPO reused) {
        if (project == null) {
            return new ArrayList<IExecTestCasePO>();
        }
        EntityManager s = GeneralStorage.getInstance().getMasterSession();
        Query q = s.createQuery("select ref from ExecTestCasePO as ref where ref.hbmParentProjectId = :parentProjectId and ref.projectGuid = :projectGuid");
        q.setParameter("parentProjectId", (Object)project.getId());
        q.setParameter("projectGuid", (Object)reused.getProjectGuid());
        List result = q.getResultList();
        return result;
    }

    public static synchronized List<ISpecPersistable> loadSpecObjList(IProjectPO project) {
        if (project == null) {
            return new ArrayList<ISpecPersistable>();
        }
        EntityManager s = GeneralStorage.getInstance().getMasterSession();
        Query q = s.createQuery("select cont from SpecObjContPO as cont where cont.hbmParentProjectId = :parentProjectId");
        q.setParameter("parentProjectId", (Object)project.getId());
        try {
            return ((ISpecObjContPO)q.getSingleResult()).getSpecObjList();
        }
        catch (NoResultException noResultException) {
            return new ArrayList<ISpecPersistable>();
        }
    }

    public static synchronized ISpecTestCasePO getSpecTestCase(Set<IReusedProjectPO> reusedProjects, String projectGuid, String specTcGuid) {
        Integer majorNumber = null;
        Integer minorNumber = null;
        for (IReusedProjectPO reusedProj : reusedProjects) {
            if (!reusedProj.getProjectGuid().equals(projectGuid)) continue;
            majorNumber = reusedProj.getMajorNumber();
            minorNumber = reusedProj.getMinorNumber();
            break;
        }
        if (majorNumber == null) {
            return null;
        }
        EntityManager s = GeneralStorage.getInstance().getMasterSession();
        Long projectId = NodePM.getInstance().findProjectID(s, projectGuid, majorNumber, minorNumber);
        if (projectId == null) {
            return null;
        }
        Object result = NodePM.getInstance().findSpecTC(s, specTcGuid, projectId);
        if (result instanceof ISpecTestCasePO) {
            return (ISpecTestCasePO)result;
        }
        return null;
    }

    private Object findSpecTC(EntityManager s, String specTcGuid, Long projectId) {
        Object cached;
        this.validateSession(s);
        StringBuilder idBuilder = new StringBuilder(50);
        idBuilder.append(specTcGuid);
        idBuilder.append(':');
        idBuilder.append(projectId);
        String key = idBuilder.toString();
        if (this.m_useCache && (cached = this.m_specTCCache.get(key)) != null) {
            if (cached instanceof INodePO) {
                return cached;
            }
            return null;
        }
        Query specTcQuery = s.createQuery("select node from SpecTestCasePO as node where node.guid = :guid and node.hbmParentProjectId = :projectId");
        specTcQuery.setParameter("guid", (Object)specTcGuid);
        specTcQuery.setParameter("projectId", (Object)projectId);
        Object result = null;
        try {
            result = specTcQuery.getSingleResult();
        }
        catch (NoResultException noResultException) {}
        if (this.m_useCache) {
            if (result != null) {
                this.m_specTCCache.put(key, result);
            } else {
                this.m_specTCCache.put(key, new Object());
            }
        }
        return result;
    }

    private Long findProjectID(EntityManager s, String projectGuid, Integer majorNumber, Integer minorNumber) {
        Long id;
        this.validateSession(s);
        String key = NodePM.buildProjectKey(projectGuid, majorNumber, minorNumber);
        if (this.m_useCache && (id = this.m_projectIDCache.get(key)) != null) {
            if (id != -1L) {
                return id;
            }
            return null;
        }
        Query projIdQuery = s.createQuery("select project from ProjectPO as project inner join fetch project.properties where project.guid = :guid and project.properties.majorNumber = :majorNumber and project.properties.minorNumber = :minorNumber");
        projIdQuery.setParameter("guid", (Object)projectGuid);
        projIdQuery.setParameter("majorNumber", (Object)majorNumber);
        projIdQuery.setParameter("minorNumber", (Object)minorNumber);
        try {
            Object uniqueResult = projIdQuery.getSingleResult();
            Long projectId = ((IProjectPO)uniqueResult).getId();
            if (this.m_useCache) {
                this.m_projectIDCache.put(key, projectId);
            }
            return projectId;
        }
        catch (NoResultException noResultException) {
            if (this.m_useCache) {
                this.m_projectIDCache.put(key, new Long(-1L));
            }
            return null;
        }
    }

    private void validateSession(EntityManager s) {
        if (this.m_useCache && this.m_lastSession != s) {
            this.resetCaching();
            this.m_lastSession = s;
        }
    }

    private void resetCaching() {
        if (this.m_projectIDCache != null) {
            this.m_projectIDCache.clear();
            this.m_projectIDCache = null;
        }
        if (this.m_specTCCache != null) {
            this.m_specTCCache.clear();
            this.m_specTCCache = null;
        }
        this.m_lastSession = null;
        if (this.m_useCache) {
            this.m_projectIDCache = new HashMap<String, Long>(20);
            this.m_specTCCache = new HashMap<String, Object>(500);
        }
    }

    private static String buildProjectKey(String projectGuid, Integer majorNumber, Integer minorNumber) {
        StringBuilder idBuilder = new StringBuilder(200);
        idBuilder.append(projectGuid);
        idBuilder.append(":");
        idBuilder.append(majorNumber);
        idBuilder.append(":");
        idBuilder.append(minorNumber);
        return idBuilder.toString();
    }

    public static synchronized ISpecTestCasePO getSpecTestCase(Long projectId, String specTcGuid) {
        EntityManager s = GeneralStorage.getInstance().getMasterSession();
        return (ISpecTestCasePO)NodePM.getInstance().findSpecTC(s, specTcGuid, projectId);
    }

    public static synchronized ITestSuitePO getTestSuite(String testSuiteGuid) {
        IProjectPO currentProject = GeneralStorage.getInstance().getProject();
        if (currentProject != null) {
            EntityManager s = GeneralStorage.getInstance().getMasterSession();
            CriteriaBuilder builder = s.getCriteriaBuilder();
            CriteriaQuery query = builder.createQuery();
            Root from = query.from(NodeMaker.getTestSuitePOClass());
            query.select((Selection)from).where(new Predicate[]{builder.like((Expression)from.get("guid"), testSuiteGuid), builder.equal((Expression)from.get("hbmParentProjectId"), (Object)currentProject.getId())});
            try {
                Object result = s.createQuery(query).getSingleResult();
                if (result instanceof ITestSuitePO) {
                    return (ITestSuitePO)result;
                }
            }
            catch (NoResultException noResultException) {}
        }
        return null;
    }

    public static synchronized INodePO getNode(Long projectId, String nodeGuid) {
        return NodePM.getNode(projectId, nodeGuid, GeneralStorage.getInstance().getMasterSession());
    }

    public static synchronized INodePO getNode(Long projectId, String nodeGuid, EntityManager session) {
        Validate.notNull((Object)session);
        Query specTcQuery = session.createQuery("select node from NodePO node where node.guid = :guid and node.hbmParentProjectId = :projectId");
        specTcQuery.setParameter("guid", (Object)nodeGuid);
        specTcQuery.setParameter("projectId", (Object)projectId);
        try {
            Object result = specTcQuery.getSingleResult();
            if (result instanceof INodePO) {
                return (INodePO)result;
            }
        }
        catch (NoResultException noResultException) {}
        return null;
    }

    public static synchronized Map<String, INodePO> getNodes(Long projectId, Collection<String> guids, EntityManager session) {
        CriteriaQuery query = session.getCriteriaBuilder().createQuery();
        Root from = query.from(NodeMaker.getNodePOClass());
        Predicate parentProjectPred = session.getCriteriaBuilder().equal((Expression)from.get("hbmParentProjectId"), (Object)projectId);
        Predicate guidDisjunction = PersistenceUtil.getExpressionDisjunction(guids, from.get("guid"), session.getCriteriaBuilder());
        query.select((Selection)from).where(new Predicate[]{parentProjectPred, guidDisjunction});
        List nodeList = session.createQuery(query).getResultList();
        HashMap<String, INodePO> guidToNodeMap = new HashMap<String, INodePO>();
        for (INodePO node : nodeList) {
            String guid = node.getGuid();
            if (guidToNodeMap.containsKey(guid)) continue;
            guidToNodeMap.put(guid, node);
        }
        return guidToNodeMap;
    }

    public static long getNumNodes(long parentProjectId, EntityManager sess) {
        Query specTcQuery = sess.createQuery("select count(node) from NodePO as node where node.hbmParentProjectId = :parentProjectId");
        specTcQuery.setParameter("parentProjectId", (Object)parentProjectId);
        try {
            return (Long)specTcQuery.getSingleResult();
        }
        catch (NoResultException noResultException) {
            return 0L;
        }
    }

    public static long getNumTestDataManagers(long parentProjectId, EntityManager sess) {
        Query tdManQuery = sess.createQuery("select count(tdMan) from TDManagerPO tdMan where tdMan.hbmParentProjectId = :parentProjectId");
        tdManQuery.setParameter("parentProjectId", (Object)parentProjectId);
        try {
            return (Long)tdManQuery.getSingleResult();
        }
        catch (NoResultException noResultException) {
            return 0L;
        }
    }

    public static long getNumExecTestCases(long parentProjectId, EntityManager sess) {
        Query execTcQuery = sess.createQuery("select count(execTc) from ExecTestCasePO as execTc where execTc.hbmParentProjectId = :parentProjectId");
        execTcQuery.setParameter("parentProjectId", (Object)parentProjectId);
        try {
            return (Long)execTcQuery.getSingleResult();
        }
        catch (NoResultException noResultException) {
            return 0L;
        }
    }

    public static long getNumExecTestCasesWithRefTd(long parentProjectId, EntityManager sess) {
        Query execTcQuery = sess.createQuery("select count(execTc) from ExecTestCasePO as execTc where execTc.hbmParentProjectId = :parentProjectId and execTc.hasReferencedTD = :hasReferencedTD");
        execTcQuery.setParameter("parentProjectId", (Object)parentProjectId);
        execTcQuery.setParameter("hasReferencedTD", (Object)true);
        try {
            return (Long)execTcQuery.getSingleResult();
        }
        catch (NoResultException noResultException) {
            return 0L;
        }
    }

    public void setUseCache(boolean useCache) {
        this.m_useCache = useCache;
        this.resetCaching();
    }

    public boolean isUseCache() {
        return this.m_useCache;
    }

    public static abstract class AbstractCmdHandleChild {
        public abstract void add(INodePO var1, INodePO var2, Integer var3);

        public void delete(INodePO parent, INodePO child) {
            this.remove(parent, child);
        }

        public abstract void remove(INodePO var1, INodePO var2);

        public void setParentProjectId(INodePO child, INodePO parent) {
            Long parentProjectId = parent.getParentProjectId();
            if (parentProjectId == null) {
                parentProjectId = GeneralStorage.getInstance().getProject().getId();
            }
            child.setParentProjectId(parentProjectId);
        }
    }

    public static class CmdHandleChildIntoExecList
    extends AbstractCmdHandleChild {
        public void add(INodePO parent, INodePO child, Integer pos) {
            IProjectPO proj = GeneralStorage.getInstance().getProject();
            proj.getExecObjCont().addExecObject((IExecPersistable)child);
            this.setParentProjectId(child, parent);
        }

        public void remove(INodePO parent, INodePO child) {
            IProjectPO proj = GeneralStorage.getInstance().getProject();
            proj.getExecObjCont().removeExecObject((IExecPersistable)child);
        }
    }

    public static class CmdHandleChildIntoNodeList
    extends AbstractCmdHandleChild {
        public void add(INodePO parent, INodePO child, Integer pos) {
            parent.addNode(pos == null ? -1 : pos, child);
            this.setParentProjectId(child, parent);
        }

        public void remove(INodePO parent, INodePO child) {
            parent.removeNode(child);
        }
    }

    public static class CmdHandleChildIntoSpecList
    extends AbstractCmdHandleChild {
        public void add(INodePO parent, INodePO child, Integer pos) {
            IProjectPO proj = GeneralStorage.getInstance().getProject();
            proj.getSpecObjCont().addSpecObject((ISpecPersistable)child);
            this.setParentProjectId(child, parent);
        }

        public void remove(INodePO parent, INodePO child) {
            IProjectPO proj = GeneralStorage.getInstance().getProject();
            proj.getSpecObjCont().removeSpecObject((ISpecPersistable)child);
        }
    }

    public static class CmdHandleEventHandlerIntoMap
    extends AbstractCmdHandleChild {
        public void add(INodePO assocNode, INodePO evHandler, Integer pos) {
            if (assocNode instanceof ISpecTestCasePO && evHandler instanceof IEventExecTestCasePO) {
                ISpecTestCasePO usingSpecTc = (ISpecTestCasePO)assocNode;
                try {
                    usingSpecTc.addEventTestCase((IEventExecTestCasePO)evHandler);
                    this.setParentProjectId(usingSpecTc, evHandler);
                }
                catch (InvalidDataException e) {
                    log.error(Messages.AttemptToAddAnEventhandlerTwice, (Throwable)e);
                }
            } else {
                throw new JBFatalException(Messages.WrongTypeForAdditionOfEventhandler, MessageIDs.E_UNEXPECTED_EXCEPTION);
            }
        }

        public void remove(INodePO assocNode, INodePO evHandler) {
            if (!(assocNode instanceof ISpecTestCasePO) || !(evHandler instanceof IEventExecTestCasePO)) {
                throw new JBFatalException(Messages.WrongTypeForRemovalOfEventhandler, MessageIDs.E_UNEXPECTED_EXCEPTION);
            }
            ISpecTestCasePO usingSpecTc = (ISpecTestCasePO)assocNode;
            usingSpecTc.removeNode(evHandler);
        }
    }
}

