/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.list.UnmodifiableList;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.eclipse.jubula.client.core.businessprocess.ExternalTestDataBP;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.IDataSetPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IEventStackModificationListener;
import org.eclipse.jubula.client.core.model.IExecStackModificationListener;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.ITDManager;
import org.eclipse.jubula.client.core.model.ITestDataPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.ReentryProperty;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.utils.DefaultEventHandler;
import org.eclipse.jubula.client.core.utils.ExecObject;
import org.eclipse.jubula.client.core.utils.ModelParamValueConverter;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.jubula.tools.exception.IncompleteDataException;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Traverser {
    public static final int NO_DATASET = -1;
    public static final int NO_INDEX = -1;
    private static final Logger LOG = LoggerFactory.getLogger(Traverser.class);
    private INodePO m_root;
    private Stack<ExecObject> m_execStack = new Stack();
    private List<IExecStackModificationListener> m_execListenerList = new ArrayList<IExecStackModificationListener>();
    private List<IEventStackModificationListener> m_eventListenerList = new ArrayList<IEventStackModificationListener>();
    private Stack<EventObject> m_eventStack = new Stack();
    private Locale m_locale = null;
    private Map<ExecStackMarker, Integer> m_markerToNumRetriesMap = new HashMap<ExecStackMarker, Integer>();
    private ExternalTestDataBP m_externalTestDataBP;

    public Traverser(INodePO root, Locale locale) {
        this.m_root = root;
        this.m_locale = locale;
        this.m_externalTestDataBP = new ExternalTestDataBP();
        this.m_execStack.push(new ExecObject(root, -1, 0));
        this.executeLogging();
    }

    public ICapPO next() throws JBException {
        if (!this.m_execStack.isEmpty()) {
            ExecObject stackObj = this.m_execStack.peek();
            INodePO node = stackObj.getExecNode();
            ITDManager tdManager = null;
            if (Persistor.isPoSubclass(node, IParamNodePO.class)) {
                tdManager = this.m_externalTestDataBP.getExternalCheckedTDManager((IParamNodePO)node);
            }
            if (stackObj.getIndex() < node.getNodeListSize() - 1) {
                stackObj.incrementIndex();
                List nodeList = IteratorUtils.toList(node.getNodeListIterator());
                INodePO childNode = (INodePO)nodeList.get(stackObj.getIndex());
                if (!childNode.isActive()) {
                    return this.next();
                }
                if (Persistor.isPoSubclass(childNode, ICapPO.class)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.valueOf(Messages.ActualExecutedCap) + ":" + " " + childNode.getName());
                    }
                    this.fireNextCap((ICapPO)childNode);
                    return (ICapPO)childNode;
                }
                if (Persistor.isPoSubclass(childNode, IExecTestCasePO.class)) {
                    if (((IExecTestCasePO)childNode).getSpecTestCase() == null) {
                        throw new IncompleteDataException(Messages.ExecTestCasePOMissingReference, MessageIDs.E_DATASOURCE_CONTAIN_EMPTY_DATA);
                    }
                    this.processExecTestCase(stackObj, (IExecTestCasePO)childNode);
                    return this.next();
                }
                Assert.notReached((String)Messages.ErrorInTestExecutionTree);
                return null;
            }
            if (!Persistor.isPoSubclass(stackObj.getExecNode(), ITestSuitePO.class) && tdManager != null) {
                int maxDsNumber = tdManager.getDataSetCount();
                if (stackObj.getNumberDs() < maxDsNumber - 1) {
                    stackObj.incrementDataSetNumber();
                    stackObj.setIndex(-1);
                    this.fireNextDataSetIteration();
                    return this.next();
                }
                ReentryProperty prop = this.decrementStack(node);
                return prop == null ? this.next() : this.next(prop);
            }
            ReentryProperty prop = this.decrementStack(node);
            return prop == null ? this.next() : this.next(prop);
        }
        return null;
    }

    private void processExecTestCase(ExecObject stackObj, IExecTestCasePO childNode) throws JBException {
        IExecTestCasePO exTc = childNode;
        ITDManager tdManager = null;
        tdManager = this.m_externalTestDataBP.getExternalCheckedTDManager(exTc);
        ITestDataPO td = null;
        IDataSetPO dataSet = null;
        if (tdManager.getDataSetCount() > 0) {
            dataSet = tdManager.getDataSet(0);
        }
        if (dataSet != null && dataSet.getColumnCount() > 0) {
            td = dataSet.getColumn(0);
        }
        if (tdManager.getDataSetCount() > 1) {
            this.m_execStack.push(new ExecObject(childNode, -1, this.getFirstDataSetNumber(childNode)));
        } else if (tdManager.getDataSetCount() == 1) {
            String uniqueId = tdManager.getUniqueIds().get(0);
            IParamDescriptionPO desc = exTc.getParameterForUniqueId(uniqueId);
            ModelParamValueConverter conv = new ModelParamValueConverter(td, (IParameterInterfacePO)exTc, this.m_locale, desc);
            if (td != null && conv.containsReferences()) {
                this.m_execStack.push(new ExecObject(childNode, -1, stackObj.getNumberDs()));
            } else if (td != null) {
                this.m_execStack.push(new ExecObject(childNode, -1, 0));
            }
        } else {
            this.m_execStack.push(new ExecObject(childNode, -1, -1));
        }
        this.executeLogging();
        this.fireExecStackIncremented(childNode);
    }

    private ReentryProperty decrementStack(INodePO node) {
        ReentryProperty prop = null;
        if (this.isEventHandler(node)) {
            IEventExecTestCasePO eventExec = (IEventExecTestCasePO)node;
            prop = eventExec.getReentryProp();
        }
        if (!this.m_execStack.isEmpty()) {
            this.m_execStack.pop();
            this.executeLogging();
            this.fireExecStackDecremented();
        }
        return prop;
    }

    private void executeLogging() {
        if (LOG.isDebugEnabled() && !this.m_execStack.isEmpty()) {
            LOG.debug(String.valueOf(Messages.ActualPeekObjectOnStack) + ":" + " " + this.m_execStack.peek().getExecNode().getName());
        }
    }

    private int getFirstDataSetNumber(INodePO node) throws JBException {
        IParamNodePO paramNode;
        ITDManager tdManager;
        int ds;
        int firstDs = -1;
        if (Persistor.isPoSubclass(node, IParamNodePO.class) && ((IParamNodePO)node).getDataManager() != null && (ds = (tdManager = this.m_externalTestDataBP.getExternalCheckedTDManager(paramNode = (IParamNodePO)node)).getDataSetCount()) > 0) {
            firstDs = 0;
        }
        return firstDs;
    }

    public List<ExecObject> getExecStackAsList() {
        return Collections.unmodifiableList(new ArrayList<ExecObject>(this.m_execStack));
    }

    public List<INodePO> getExecStackAsNodeList() {
        ArrayList<INodePO> nodes = new ArrayList<INodePO>(this.m_execStack.size());
        for (ExecObject execObject : this.m_execStack) {
            nodes.add(execObject.getExecNode());
        }
        return nodes;
    }

    public INodePO getRoot() {
        return this.m_root;
    }

    public void addExecStackModificationListener(IExecStackModificationListener listener) {
        if (!this.m_execListenerList.contains(listener)) {
            this.m_execListenerList.add(listener);
        }
    }

    public void removeExecStackModificationListener(IExecStackModificationListener listener) {
        this.m_execListenerList.remove(listener);
    }

    public void addEventStackModificationListener(IEventStackModificationListener listener) {
        if (!this.m_eventListenerList.contains(listener)) {
            this.m_eventListenerList.add(listener);
        }
    }

    public void removeEventStackModificationListener(IEventStackModificationListener listener) {
        this.m_eventListenerList.remove(listener);
    }

    private void fireExecStackIncremented(INodePO node) {
        for (IExecStackModificationListener l : this.m_execListenerList) {
            try {
                l.stackIncremented(node);
            }
            catch (Throwable t) {
                LOG.error(Messages.ErrorWhileNotifyingListeners, t);
            }
        }
    }

    private void fireExecStackDecremented() {
        for (IExecStackModificationListener l : this.m_execListenerList) {
            try {
                l.stackDecremented();
            }
            catch (Throwable t) {
                LOG.error(Messages.ErrorWhileNotifyingListeners, t);
            }
        }
    }

    private void fireEventStackIncremented() {
        for (IEventStackModificationListener l : this.m_eventListenerList) {
            try {
                l.eventStackIncremented();
            }
            catch (Throwable t) {
                LOG.error(Messages.ErrorWhileNotifyingListeners, t);
            }
        }
    }

    private void fireEventStackDecremented() {
        for (IEventStackModificationListener l : this.m_eventListenerList) {
            try {
                l.eventStackDecremented();
            }
            catch (Throwable t) {
                LOG.error(Messages.ErrorWhileNotifyingListeners, t);
            }
        }
    }

    private void fireNextDataSetIteration() {
        for (IExecStackModificationListener l : this.m_execListenerList) {
            try {
                l.nextDataSetIteration();
            }
            catch (Throwable t) {
                LOG.error(Messages.ErrorWhileNotifyingListeners, t);
            }
        }
    }

    private void fireNextCap(ICapPO cap) {
        for (IExecStackModificationListener l : this.m_execListenerList) {
            try {
                l.nextCap(cap);
            }
            catch (Throwable t) {
                LOG.error(Messages.ErrorWhileNotifyingListeners, t);
            }
        }
    }

    public int getDataSetNumber() {
        int ds = 0;
        if (!this.m_execStack.isEmpty()) {
            ExecObject obj = this.m_execStack.peek();
            ds = obj.getNumberDs();
        }
        return ds;
    }

    private ICapPO next(ReentryProperty reentryProp) throws JBException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ReentryProperty: " + String.valueOf(reentryProp));
        }
        if (!this.m_execStack.isEmpty()) {
            if (reentryProp.equals(ReentryProperty.CONTINUE)) {
                this.popEventStack();
            } else if (reentryProp.equals(ReentryProperty.REPEAT)) {
                ExecObject obj = this.m_execStack.peek();
                obj.decrementIndex();
                this.popEventStack();
            } else if (reentryProp.equals(ReentryProperty.BREAK)) {
                int i = this.m_eventStack.size();
                while (i > 0 && !this.m_execStack.isEmpty()) {
                    this.m_execStack.pop();
                    this.executeLogging();
                    this.fireExecStackDecremented();
                    --i;
                }
                this.popEventStackNested();
            } else if (reentryProp.equals(ReentryProperty.RETURN)) {
                int stackPos = this.popEventStackNested();
                while (this.m_execStack.size() > stackPos) {
                    this.m_execStack.pop();
                    this.executeLogging();
                    this.fireExecStackDecremented();
                }
            } else if (reentryProp.equals(ReentryProperty.EXIT)) {
                int i = this.m_execStack.size() - 1;
                while (i >= 0) {
                    this.m_execStack.pop();
                    this.executeLogging();
                    this.fireExecStackDecremented();
                    --i;
                }
                i = this.m_eventStack.size() - 1;
                while (i >= 0) {
                    this.popEventStack();
                    --i;
                }
            } else if (reentryProp.equals(ReentryProperty.STOP)) {
                TestExecution.getInstance().pauseExecution(TestExecution.PauseMode.PAUSE);
                this.popEventStack();
            } else {
                if (reentryProp.equals(ReentryProperty.RETRY)) {
                    this.popEventStack();
                    return this.retryStep();
                }
                int i = this.m_execStack.size() - 1;
                while (i >= 0) {
                    this.m_execStack.pop();
                    this.executeLogging();
                    this.fireExecStackDecremented();
                    --i;
                }
                i = this.m_eventStack.size() - 1;
                while (i >= 0) {
                    this.popEventStack();
                    --i;
                }
            }
            return this.next();
        }
        return null;
    }

    private int popEventStackNested() {
        int stackPos = 0;
        if (!this.m_eventStack.isEmpty()) {
            stackPos = this.m_eventStack.peek().getStackPos();
        }
        this.popEventStack();
        while (!this.m_eventStack.isEmpty() && this.m_eventStack.peek().getStackPos() >= stackPos) {
            this.popEventStack();
        }
        return stackPos;
    }

    private void popEventStack() {
        this.m_eventStack.pop();
        this.fireEventStackDecremented();
    }

    private ICapPO retryStep() {
        ExecObject execObj = this.m_execStack.peek();
        List nodeList = IteratorUtils.toList(execObj.getExecNode().getNodeListIterator());
        INodePO childNode = (INodePO)nodeList.get(execObj.getIndex());
        if (childNode instanceof ICapPO) {
            ICapPO cap = (ICapPO)childNode;
            ExecStackMarker marker = new ExecStackMarker(this.m_execStack, cap);
            if (this.m_markerToNumRetriesMap.containsKey(marker)) {
                this.m_markerToNumRetriesMap.put(marker, this.m_markerToNumRetriesMap.get(marker) + 1);
            } else {
                this.m_markerToNumRetriesMap.put(marker, 1);
            }
            this.fireRetryStep(cap);
            return cap;
        }
        return null;
    }

    private void fireRetryStep(ICapPO toRetry) {
        for (IExecStackModificationListener l : this.m_execListenerList) {
            try {
                l.retryCap(toRetry);
            }
            catch (Throwable t) {
                LOG.error(Messages.ErrorWhileNotifyingListeners, t);
            }
        }
    }

    private boolean isEventHandler(INodePO node) {
        return Persistor.isPoSubclass(node, IEventExecTestCasePO.class);
    }

    public ReentryProperty getEventHandlerReentry(String eventType) {
        return this.getEventObject(eventType).getEventExecTc().getReentryProp();
    }

    public ICapPO next(String eventType) throws JBException {
        ExecObject execObj = this.m_execStack.peek();
        EventObject eventObj = this.getEventObject(eventType);
        IEventExecTestCasePO eventExecTC = eventObj.getEventExecTc();
        int startIndex = 0;
        ITDManager mgr = eventExecTC.getDataManager();
        if (mgr.getDataSetCount() > 0) {
            IDataSetPO row = mgr.getDataSet(0);
            int col = 0;
            while (col < row.getColumnCount()) {
                String uniqueId;
                IParamDescriptionPO desc;
                ITestDataPO td = row.getColumn(col);
                ModelParamValueConverter conv = new ModelParamValueConverter(td, (IParameterInterfacePO)eventExecTC, this.m_locale, desc = eventExecTC.getParameterForUniqueId(uniqueId = mgr.getUniqueIds().get(col)));
                if (conv.containsReferences()) {
                    startIndex = execObj.getNumberDs();
                    break;
                }
                ++col;
            }
        }
        this.m_execStack.push(new ExecObject(eventExecTC, -1, startIndex));
        this.m_eventStack.push(eventObj);
        this.fireEventStackIncremented();
        this.fireExecStackIncremented(eventExecTC);
        this.executeLogging();
        return this.next();
    }

    public boolean isHandlingError() {
        return !this.m_eventStack.isEmpty();
    }

    private EventObject getEventObject(String eventType) {
        int startIndex;
        List nodeList = IteratorUtils.toList(this.m_execStack.peek().getExecNode().getNodeListIterator());
        ICapPO cap = (ICapPO)nodeList.get(this.m_execStack.peek().getIndex());
        ExecStackMarker marker = new ExecStackMarker(this.m_execStack, cap);
        EventObject eventObj = null;
        int i = startIndex = this.m_execStack.size() - 1;
        while (i > 0 && i < this.m_execStack.size()) {
            ExecObject obj = (ExecObject)this.m_execStack.get(i);
            IExecTestCasePO execTc = (IExecTestCasePO)obj.getExecNode();
            Map<String, IEventExecTestCasePO> eventMap = execTc.getEventMap();
            if (!this.isHandlingError(i) && eventMap.containsKey(eventType)) {
                IEventExecTestCasePO eventExecTc = eventMap.get(eventType);
                if (!eventExecTc.getReentryProp().equals(ReentryProperty.RETRY) || !this.m_markerToNumRetriesMap.containsKey(marker) || this.m_markerToNumRetriesMap.get(marker) < eventExecTc.getMaxRetries()) {
                    eventObj = new EventObject(eventExecTc, i);
                    break;
                }
                eventExecTc = null;
            }
            --i;
        }
        if (eventObj == null) {
            IEventExecTestCasePO eventExecTc = DefaultEventHandler.getDefaultEventHandler(eventType, this.m_root);
            Validate.notNull((Object)eventExecTc, (String)(String.valueOf(Messages.MissingDefaultEventHandlerForEventType) + eventType + "."));
            eventObj = new EventObject(eventExecTc, 0);
        }
        return eventObj;
    }

    private boolean isHandlingError(int execStackIndex) {
        for (EventObject event : this.m_eventStack) {
            if (event.getStackPos() != execStackIndex) continue;
            return true;
        }
        return false;
    }

    public int getSuccessResult() {
        ExecStackMarker marker;
        INodePO currentNode = this.getCurrentNode();
        if (currentNode instanceof ICapPO && this.m_markerToNumRetriesMap.containsKey(marker = new ExecStackMarker(this.m_execStack, (ICapPO)currentNode))) {
            return 8;
        }
        return 1;
    }

    public int getNumberOfRetriedSteps() {
        int retriedStepCount = 0;
        for (Integer numRetries : this.m_markerToNumRetriesMap.values()) {
            retriedStepCount += numRetries.intValue();
        }
        return retriedStepCount;
    }

    private INodePO getCurrentNode() {
        List nodeList = IteratorUtils.toList(this.m_execStack.peek().getExecNode().getNodeListIterator());
        return (INodePO)nodeList.get(this.m_execStack.peek().getIndex());
    }

    private static class EventObject {
        private IEventExecTestCasePO m_eventExecTc;
        private int m_stackPos;

        private EventObject(IEventExecTestCasePO eventExecTc, int stackPos) {
            this.m_eventExecTc = eventExecTc;
            this.m_stackPos = stackPos;
        }

        public IEventExecTestCasePO getEventExecTc() {
            return this.m_eventExecTc;
        }

        public int getStackPos() {
            return this.m_stackPos;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ExecStackMarker {
        private Vector<ExecObject> m_execStack;
        private ICapPO m_step;

        ExecStackMarker(Stack<ExecObject> execStack, ICapPO step) {
            this.m_execStack = new Vector<ExecObject>(execStack);
            this.m_step = step;
        }

        List<ExecObject> getExecStack() {
            return UnmodifiableList.decorate(this.m_execStack);
        }

        ICapPO getStep() {
            return this.m_step;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ExecStackMarker) {
                ExecStackMarker marker = (ExecStackMarker)obj;
                return new EqualsBuilder().append(this.m_execStack, marker.getExecStack()).append((Object)this.m_step, (Object)marker.getStep()).isEquals();
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.m_execStack).append((Object)this.m_step).toHashCode();
        }
    }
}

