/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeIterator {
    private List<INodePO> m_elements = new LinkedList<INodePO>();
    private Iterator<INodePO> m_iter;

    public TreeIterator(INodePO root) {
        this.m_elements.add(root);
        this.setElements(root);
        this.m_iter = this.m_elements.iterator();
    }

    public TreeIterator(INodePO root, Class[] filter) {
        this(root);
        this.filterElements(filter);
    }

    private void filterElements(Class[] filter) {
        ArrayList<INodePO> filteredElements = new ArrayList<INodePO>(25);
        int filterLength = filter.length;
        int i = 0;
        while (i < filterLength) {
            Class filteredClass = filter[i];
            for (INodePO element : this.m_elements) {
                if (!filteredClass.isInstance(element)) continue;
                filteredElements.add(element);
            }
            ++i;
        }
        this.m_elements = filteredElements;
        this.m_iter = this.m_elements.iterator();
    }

    public INodePO next() {
        return this.m_iter.next();
    }

    public boolean hasNext() {
        return this.m_iter.hasNext();
    }

    protected void setElements(INodePO root) {
        if (root == null) {
            return;
        }
        List nodes = root.getUnmodifiableNodeList();
        for (INodePO nextNode : nodes) {
            if (nextNode != null) {
                ISpecTestCasePO specTestCase;
                this.m_elements.add(nextNode);
                if (nextNode instanceof IExecTestCasePO && (specTestCase = ((IExecTestCasePO)nextNode).getSpecTestCase()) != null) {
                    this.m_elements.add((INodePO)specTestCase);
                }
            }
            this.setElements(nextNode);
        }
    }

    protected List<INodePO> getElements() {
        return this.m_elements;
    }
}

