/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.provider.contentprovider.objectmapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameCache;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IObjectMappingPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.contentprovider.AbstractTreeViewContentProvider;
import org.eclipse.jubula.tools.internal.exception.Assert;

public class OMEditorTreeContentProvider
extends AbstractTreeViewContentProvider {
    private Map<Object, Object> m_childToParentMap = new HashMap<Object, Object>();
    private IComponentNameCache m_compNameCache;
    private DataEventDispatcher.IDataChangedListener m_modelListener;
    private Collection<IObjectMappingCategoryPO> m_categoriesToIgnore;

    public OMEditorTreeContentProvider(IComponentNameCache compNameCache) {
        this.m_compNameCache = compNameCache;
    }

    public OMEditorTreeContentProvider(IComponentNameCache compNameCache, Collection<IObjectMappingCategoryPO> categoriesToIgnore) {
        this.m_compNameCache = compNameCache;
        this.m_categoriesToIgnore = categoriesToIgnore;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IObjectMappingPO) {
            IObjectMappingPO mapping = (IObjectMappingPO)parentElement;
            ArrayList<IObjectMappingCategoryPO> categoryList = new ArrayList<IObjectMappingCategoryPO>();
            categoryList.add(mapping.getMappedCategory());
            categoryList.add(mapping.getUnmappedLogicalCategory());
            categoryList.add(mapping.getUnmappedTechnicalCategory());
            Validate.noNullElements(categoryList);
            return categoryList.toArray();
        }
        if (parentElement instanceof IObjectMappingAssoziationPO) {
            IObjectMappingAssoziationPO assoc = (IObjectMappingAssoziationPO)parentElement;
            ArrayList<Object> componentNamePoList = new ArrayList<Object>();
            for (String string : assoc.getLogicalNames()) {
                IComponentNamePO compNamePo = this.m_compNameCache.getResCompNamePOByGuid(string);
                if (compNamePo != null) {
                    componentNamePoList.add(compNamePo);
                } else {
                    componentNamePoList.add(string);
                }
                this.m_childToParentMap.put(compNamePo, parentElement);
            }
            Validate.noNullElements(componentNamePoList);
            return componentNamePoList.toArray();
        }
        if (parentElement instanceof IComponentNamePO) {
            return ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        if (parentElement instanceof Collection) {
            return ((Collection)parentElement).toArray();
        }
        if (parentElement instanceof IObjectMappingCategoryPO) {
            ArrayList<Object> childList = new ArrayList<Object>();
            IObjectMappingCategoryPO category = (IObjectMappingCategoryPO)parentElement;
            childList.addAll(category.getUnmodifiableCategoryList());
            if (this.m_categoriesToIgnore != null && this.m_categoriesToIgnore.size() > 0) {
                childList.removeAll(this.m_categoriesToIgnore);
            }
            for (IObjectMappingAssoziationPO iObjectMappingAssoziationPO : category.getUnmodifiableAssociationList()) {
                if (iObjectMappingAssoziationPO.getTechnicalName() != null) {
                    childList.add(iObjectMappingAssoziationPO);
                    continue;
                }
                for (String compNameGuid : iObjectMappingAssoziationPO.getLogicalNames()) {
                    IComponentNamePO compName = this.m_compNameCache.getResCompNamePOByGuid(compNameGuid);
                    if (compName == null) continue;
                    childList.add(compName);
                }
            }
            for (Object e : childList) {
                this.m_childToParentMap.put(e, parentElement);
            }
            Validate.noNullElements(childList);
            return childList.toArray();
        }
        if (parentElement instanceof String) {
            return ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        Assert.notReached((String)(String.valueOf(Messages.WrongTypeOfElement) + "!"));
        return ArrayUtils.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public Object getParent(Object element) {
        IObjectMappingCategoryPO parent;
        if (element instanceof IObjectMappingAssoziationPO) {
            return ((IObjectMappingAssoziationPO)element).getCategory();
        }
        if (element instanceof IObjectMappingCategoryPO && (parent = ((IObjectMappingCategoryPO)element).getParent()) != null) {
            return parent;
        }
        return this.m_childToParentMap.get(element);
    }

    @Override
    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    @Override
    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    @Override
    public void dispose() {
        this.m_childToParentMap.clear();
        super.dispose();
    }

    @Override
    public void inputChanged(final Viewer viewer, Object oldInput, final Object newInput) {
        Validate.isTrue((boolean)(viewer instanceof TreeViewer));
        this.m_childToParentMap.clear();
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        if (this.m_modelListener != null) {
            ded.removeDataChangedListener(this.m_modelListener);
            this.m_modelListener = null;
        }
        if (newInput != null) {
            this.m_modelListener = new DataEventDispatcher.IDataChangedListener(){

                public void handleDataChanged(DataChangedEvent ... events) {
                    DataChangedEvent[] dataChangedEventArray = events;
                    int n = events.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DataChangedEvent e = dataChangedEventArray[n2];
                        this.handleDataChanged(e.getPo(), e.getDataState(), e.getUpdateState());
                        ++n2;
                    }
                }

                public void handleDataChanged(IPersistentObject po, DataEventDispatcher.DataState dataState, DataEventDispatcher.UpdateState updateState) {
                    if (updateState != DataEventDispatcher.UpdateState.notInEditor) {
                        StructuredViewer structuredViewer = (StructuredViewer)viewer;
                        if (dataState == DataEventDispatcher.DataState.StructureModified) {
                            boolean objectsAreEqual;
                            boolean bl = objectsAreEqual = structuredViewer.getComparer() != null ? structuredViewer.getComparer().equals(newInput, (Object)po) : newInput.equals(po);
                            if (objectsAreEqual || po instanceof IAUTMainPO || po instanceof IObjectMappingPO) {
                                structuredViewer.refresh();
                            } else {
                                structuredViewer.refresh((Object)po);
                            }
                        } else if (dataState == DataEventDispatcher.DataState.Renamed) {
                            structuredViewer.update((Object)po, null);
                        }
                    }
                }
            };
            ded.addDataChangedListener(this.m_modelListener, false);
        }
    }
}

