/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jubula.client.core.businessprocess.AbstractParamInterfaceBP;
import org.eclipse.jubula.client.core.businessprocess.CapBP;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IParamValueSetPO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.ITcParamDescriptionPO;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.client.core.model.IValueCommentPO;
import org.eclipse.jubula.client.core.utils.IParamValueValidator;
import org.eclipse.jubula.client.core.utils.StringHelper;
import org.eclipse.jubula.client.ui.rcp.controllers.propertydescriptors.ParamComboPropertyDescriptor;
import org.eclipse.jubula.client.ui.rcp.controllers.propertydescriptors.ParamTextPropertyDescriptor;
import org.eclipse.jubula.client.ui.rcp.controllers.propertysources.AbstractNodePropertySource;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.widgets.CheckedParamText;
import org.eclipse.jubula.client.ui.rcp.widgets.CheckedParamTextContentAssisted;
import org.eclipse.jubula.client.ui.rcp.widgets.ParamProposalProvider;
import org.eclipse.jubula.tools.internal.exception.Assert;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Action;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Param;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ParamValueSet;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ValueSetElement;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class TestDataControlFactory {
    public static final String[] BOOLEAN_VALUES = new String[]{"true", "false"};

    private TestDataControlFactory() {
    }

    public static Control createControl(IParameterInterfacePO paramObj, String paramName, Composite parent, int style) {
        String[] values;
        Map map = StringHelper.getInstance().getMap();
        String nameOfParam = paramName;
        IParamDescriptionPO paramDesc = paramObj.getParameterForName(nameOfParam);
        if (paramDesc == null) {
            nameOfParam = (String)map.get(paramName);
            paramDesc = paramObj.getParameterForName(nameOfParam);
        }
        if (paramObj instanceof ICapPO) {
            ICapPO cap = (ICapPO)paramObj;
            Action action = CapBP.getAction((ICapPO)cap);
            values = new ArrayList();
            Param param = action.findParam(paramDesc.getUniqueId());
            Iterator iter = param.valueSetIterator();
            while (iter.hasNext()) {
                values.add((String)map.get(((ValueSetElement)iter.next()).getValue()));
            }
            if (!values.isEmpty()) {
                return new CheckedParamText(parent, style, (IParameterInterfacePO)cap, paramDesc, TestDataControlFactory.createParamValueValidator("java.lang.String", param.getValueSet().isCombinable(), values.toArray(new String[values.size()])));
            }
        }
        if (paramObj instanceof IParamNodePO) {
            IParamNodePO paramNode = (IParamNodePO)paramObj;
            ParamValueSet valueSet = ParamTextPropertyDescriptor.getValuesSet(paramNode, paramDesc.getUniqueId());
            values = ParamTextPropertyDescriptor.getValues(valueSet);
            Map<String, String> valuesWithComment = ParamTextPropertyDescriptor.getValuesWithComment(valueSet);
            if ("java.lang.Boolean".equals(paramDesc.getType())) {
                values = BOOLEAN_VALUES;
                valuesWithComment.clear();
                valuesWithComment.put(BOOLEAN_VALUES[0], "");
                valuesWithComment.put(BOOLEAN_VALUES[1], "");
            }
            return new CheckedParamTextContentAssisted(parent, style, (IParameterInterfacePO)paramNode, paramDesc, TestDataControlFactory.createParamValueValidator(paramDesc.getType(), valueSet != null ? valueSet.isCombinable() : false, values), new ParamProposalProvider(valuesWithComment, (INodePO)paramNode, paramDesc));
        }
        if (paramObj instanceof ITestDataCubePO) {
            ITestDataCubePO tdc = (ITestDataCubePO)paramObj;
            Map<String, String> values2 = TestDataControlFactory.getValuesFromValueSet(paramDesc);
            if ("java.lang.Boolean".equals(paramDesc.getType())) {
                return new CheckedParamTextContentAssisted(parent, style, (IParameterInterfacePO)tdc, paramDesc, TestDataControlFactory.createParamValueValidator(paramDesc.getType(), false, BOOLEAN_VALUES), new ParamProposalProvider(BOOLEAN_VALUES, null, paramDesc));
            }
            return new CheckedParamTextContentAssisted(parent, style, (IParameterInterfacePO)tdc, paramDesc, TestDataControlFactory.createParamValueValidator(paramDesc.getType(), false, values2.keySet().toArray(new String[values2.size()])), new ParamProposalProvider(values2, null, paramDesc));
        }
        Assert.notReached((String)(String.valueOf(Messages.ImplementFor) + " " + paramObj.getClass().getName()));
        return null;
    }

    private static Map<String, String> getValuesFromValueSet(IParamDescriptionPO paramDesc) {
        if (paramDesc instanceof ITcParamDescriptionPO) {
            ITcParamDescriptionPO desc = (ITcParamDescriptionPO)paramDesc;
            IParamValueSetPO valueSet = desc.getValueSet();
            List values = valueSet.getValues();
            if (valueSet != null && values != null && values.size() > 0) {
                return values.stream().collect(Collectors.toMap(IValueCommentPO::getValue, IValueCommentPO::getComment));
            }
        }
        return new HashMap<String, String>();
    }

    public static PropertyDescriptor createValuePropertyDescriptor(AbstractNodePropertySource.AbstractParamValueController paramValController, String displayName, Map<String, String> values, boolean valuesAreCombinable) {
        String paramType = paramValController.getParamDesc().getType();
        if (!values.isEmpty()) {
            return new ParamComboPropertyDescriptor(paramValController, displayName, values, TestDataControlFactory.createParamValueValidator("java.lang.String", valuesAreCombinable, values.keySet().toArray(new String[0])));
        }
        if ("java.lang.Boolean".equals(paramType)) {
            return new ParamTextPropertyDescriptor(paramValController, displayName, TestDataControlFactory.createParamValueValidator("java.lang.String", valuesAreCombinable, BOOLEAN_VALUES));
        }
        return new ParamTextPropertyDescriptor(paramValController, displayName, TestDataControlFactory.createParamValueValidator(paramType, valuesAreCombinable, new String[0]));
    }

    private static IParamValueValidator createParamValueValidator(String type, boolean valuesAreCombinable, String ... values) {
        return AbstractParamInterfaceBP.createParamValueValidator((String)type, (boolean)valuesAreCombinable, (String[])values);
    }
}

