/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.util.CellRangeAddress8Bit;
import org.apache.poi.util.LittleEndian;

public final class SelectionRecord
extends Record {
    public static final short sid = 29;
    private byte field_1_pane;
    private int field_2_row_active_cell;
    private int field_3_col_active_cell;
    private int field_4_active_cell_ref_index;
    private CellRangeAddress8Bit[] field_6_refs;

    public SelectionRecord(int activeCellRow, int activeCellCol) {
        this.field_1_pane = (byte)3;
        this.field_2_row_active_cell = activeCellRow;
        this.field_3_col_active_cell = activeCellCol;
        this.field_4_active_cell_ref_index = 0;
        this.field_6_refs = new CellRangeAddress8Bit[]{new CellRangeAddress8Bit(activeCellRow, activeCellRow, activeCellCol, activeCellCol)};
    }

    public SelectionRecord(RecordInputStream in) {
        this.field_1_pane = in.readByte();
        this.field_2_row_active_cell = in.readUShort();
        this.field_3_col_active_cell = in.readShort();
        this.field_4_active_cell_ref_index = in.readShort();
        int field_5_num_refs = in.readUShort();
        this.field_6_refs = new CellRangeAddress8Bit[field_5_num_refs];
        int i = 0;
        while (i < this.field_6_refs.length) {
            this.field_6_refs[i] = new CellRangeAddress8Bit(in);
            ++i;
        }
    }

    public void setPane(byte pane) {
        this.field_1_pane = pane;
    }

    public void setActiveCellRow(int row) {
        this.field_2_row_active_cell = row;
    }

    public void setActiveCellCol(short col) {
        this.field_3_col_active_cell = col;
    }

    public void setActiveCellRef(short ref) {
        this.field_4_active_cell_ref_index = ref;
    }

    public byte getPane() {
        return this.field_1_pane;
    }

    public int getActiveCellRow() {
        return this.field_2_row_active_cell;
    }

    public int getActiveCellCol() {
        return this.field_3_col_active_cell;
    }

    public int getActiveCellRef() {
        return (short)this.field_4_active_cell_ref_index;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SELECTION]\n");
        buffer.append("    .pane            = ").append(Integer.toHexString(this.getPane())).append("\n");
        buffer.append("    .activecellrow   = ").append(Integer.toHexString(this.getActiveCellRow())).append("\n");
        buffer.append("    .activecellcol   = ").append(Integer.toHexString(this.getActiveCellCol())).append("\n");
        buffer.append("    .activecellref   = ").append(Integer.toHexString(this.getActiveCellRef())).append("\n");
        buffer.append("    .numrefs         = ").append(Integer.toHexString(this.field_6_refs.length)).append("\n");
        buffer.append("[/SELECTION]\n");
        return buffer.toString();
    }

    private int getDataSize() {
        return 9 + CellRangeAddress8Bit.getEncodedSize(this.field_6_refs.length);
    }

    public int serialize(int offset, byte[] data) {
        int dataSize = this.getDataSize();
        LittleEndian.putUShort(data, 0 + offset, 29);
        LittleEndian.putUShort(data, 2 + offset, dataSize);
        LittleEndian.putByte(data, 4 + offset, this.getPane());
        LittleEndian.putUShort(data, 5 + offset, this.getActiveCellRow());
        LittleEndian.putUShort(data, 7 + offset, this.getActiveCellCol());
        LittleEndian.putUShort(data, 9 + offset, this.getActiveCellRef());
        int nRefs = this.field_6_refs.length;
        LittleEndian.putUShort(data, 11 + offset, nRefs);
        int i = 0;
        while (i < this.field_6_refs.length) {
            CellRangeAddress8Bit r = this.field_6_refs[i];
            r.serialize(offset + 13 + i * 6, data);
            ++i;
        }
        return 4 + dataSize;
    }

    public int getRecordSize() {
        return 4 + this.getDataSize();
    }

    public short getSid() {
        return 29;
    }

    public Object clone() {
        SelectionRecord rec = new SelectionRecord(this.field_2_row_active_cell, this.field_3_col_active_cell);
        rec.field_1_pane = this.field_1_pane;
        rec.field_4_active_cell_ref_index = this.field_4_active_cell_ref_index;
        rec.field_6_refs = this.field_6_refs;
        return rec;
    }
}

