/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.ss.formula.EvaluationCache;
import org.apache.poi.ss.formula.IEvaluationListener;
import org.apache.poi.ss.formula.WorkbookEvaluator;

public final class CollaboratingWorkbooksEnvironment {
    public static final CollaboratingWorkbooksEnvironment EMPTY = new CollaboratingWorkbooksEnvironment();
    private final Map _evaluatorsByName;
    private final WorkbookEvaluator[] _evaluators;
    private boolean _unhooked;

    private CollaboratingWorkbooksEnvironment() {
        this._evaluatorsByName = Collections.EMPTY_MAP;
        this._evaluators = new WorkbookEvaluator[0];
    }

    public static void setup(String[] workbookNames, WorkbookEvaluator[] evaluators) {
        int nItems = workbookNames.length;
        if (evaluators.length != nItems) {
            throw new IllegalArgumentException("Number of workbook names is " + nItems + " but number of evaluators is " + evaluators.length);
        }
        if (nItems < 1) {
            throw new IllegalArgumentException("Must provide at least one collaborating worbook");
        }
        new CollaboratingWorkbooksEnvironment(workbookNames, evaluators, nItems);
    }

    private CollaboratingWorkbooksEnvironment(String[] workbookNames, WorkbookEvaluator[] evaluators, int nItems) {
        HashMap<String, WorkbookEvaluator> m = new HashMap<String, WorkbookEvaluator>(nItems * 3 / 2);
        IdentityHashMap<WorkbookEvaluator, String> uniqueEvals = new IdentityHashMap<WorkbookEvaluator, String>(nItems * 3 / 2);
        int i = 0;
        while (i < nItems) {
            String wbName = workbookNames[i];
            WorkbookEvaluator wbEval = evaluators[i];
            if (m.containsKey(wbName)) {
                throw new IllegalArgumentException("Duplicate workbook name '" + wbName + "'");
            }
            if (uniqueEvals.containsKey(wbEval)) {
                String msg = "Attempted to register same workbook under names '" + uniqueEvals.get(wbEval) + "' and '" + wbName + "'";
                throw new IllegalArgumentException(msg);
            }
            uniqueEvals.put(wbEval, wbName);
            m.put(wbName, wbEval);
            ++i;
        }
        this.unhookOldEnvironments(evaluators);
        CollaboratingWorkbooksEnvironment.hookNewEnvironment(evaluators, this);
        this._unhooked = false;
        this._evaluators = evaluators;
        this._evaluatorsByName = m;
    }

    private static void hookNewEnvironment(WorkbookEvaluator[] evaluators, CollaboratingWorkbooksEnvironment env) {
        int nItems = evaluators.length;
        IEvaluationListener evalListener = evaluators[0].getEvaluationListener();
        int i = 0;
        while (i < nItems) {
            if (evalListener != evaluators[i].getEvaluationListener()) {
                throw new RuntimeException("Workbook evaluators must all have the same evaluation listener");
            }
            ++i;
        }
        EvaluationCache cache = new EvaluationCache(evalListener);
        int i2 = 0;
        while (i2 < nItems) {
            evaluators[i2].attachToEnvironment(env, cache, i2);
            ++i2;
        }
    }

    private void unhookOldEnvironments(WorkbookEvaluator[] evaluators) {
        HashSet<CollaboratingWorkbooksEnvironment> oldEnvs = new HashSet<CollaboratingWorkbooksEnvironment>();
        int i = 0;
        while (i < evaluators.length) {
            oldEnvs.add(evaluators[i].getEnvironment());
            ++i;
        }
        CollaboratingWorkbooksEnvironment[] oldCWEs = new CollaboratingWorkbooksEnvironment[oldEnvs.size()];
        oldEnvs.toArray(oldCWEs);
        int i2 = 0;
        while (i2 < oldCWEs.length) {
            oldCWEs[i2].unhook();
            ++i2;
        }
    }

    private void unhook() {
        if (this._evaluators.length < 1) {
            return;
        }
        int i = 0;
        while (i < this._evaluators.length) {
            this._evaluators[i].detachFromEnvironment();
            ++i;
        }
        this._unhooked = true;
    }

    public WorkbookEvaluator getWorkbookEvaluator(String workbookName) {
        if (this._unhooked) {
            throw new IllegalStateException("This environment has been unhooked");
        }
        WorkbookEvaluator result = (WorkbookEvaluator)this._evaluatorsByName.get(workbookName);
        if (result == null) {
            StringBuffer sb = new StringBuffer(256);
            sb.append("Could not resolve external workbook name '").append(workbookName).append("'.");
            if (this._evaluators.length < 1) {
                sb.append(" Workbook environment has not been set up.");
            } else {
                sb.append(" The following workbook names are valid: (");
                Iterator i = this._evaluatorsByName.keySet().iterator();
                int count = 0;
                while (i.hasNext()) {
                    if (count++ > 0) {
                        sb.append(", ");
                    }
                    sb.append("'").append(i.next()).append("'");
                }
                sb.append(")");
            }
            throw new RuntimeException(sb.toString());
        }
        return result;
    }
}

