/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.app.autrun;

import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jubula.app.autrun.AutRunner;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.jubula.tools.registration.AutIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutRunApplication
implements IApplication {
    private static final Logger LOG = LoggerFactory.getLogger(AutRunApplication.class);
    private static final String LAUNCHER_NAME = "autrun";
    private static final String TK_RCP = "rcp";
    private static final String TK_SWT = "swt";
    private static final String TK_SWING = "swing";
    private static final boolean DEFAULT_NAME_TECHNICAL_COMPONENTS = true;
    private static final int DEFAULT_AUT_AGENT_PORT = 60000;
    private static final String DEFAULT_AUT_AGENT_HOST = "localhost";
    private static final String OPT_AUT_AGENT_PORT = "p";
    private static final String OPT_AUT_AGENT_PORT_LONG = "autagentport";
    private static final String OPT_AUT_AGENT_HOST = "a";
    private static final String OPT_AUT_AGENT_HOST_LONG = "autagenthost";
    private static final String OPT_HELP = "h";
    private static final String OPT_HELP_LONG = "help";
    private static final String OPT_AUT_ID = "i";
    private static final String OPT_AUT_ID_LONG = "autid";
    private static final String OPT_NAME_TECHNICAL_COMPONENTS = "g";
    private static final String OPT_NAME_TECHNICAL_COMPONENTS_LONG = "generatenames";
    private static final String OPT_KEYBOARD_LAYOUT = "k";
    private static final String OPT_KEYBOARD_LAYOUT_LONG = "kblayout";
    private static final String OPT_WORKING_DIR = "w";
    private static final String OPT_WORKING_DIR_LONG = "workingdir";
    private static final String OPT_EXECUTABLE = "e";
    private static final String OPT_EXECUTABLE_LONG = "exec";

    private static void printHelp(ParseException pe) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setOptionComparator((Comparator)new OptionComparator());
        if (pe != null) {
            formatter.printHelp(LAUNCHER_NAME, "", AutRunApplication.createCmdLineOptions(), "\n" + pe.getLocalizedMessage(), true);
        } else {
            formatter.printHelp(LAUNCHER_NAME, AutRunApplication.createCmdLineOptions(), true);
        }
    }

    private static Map<String, Object> createAutConfig(CommandLine cmdLine) {
        Object[] autArguments;
        HashMap<String, Object> autConfig = new HashMap<String, Object>();
        if (cmdLine.hasOption(OPT_WORKING_DIR)) {
            autConfig.put("WORKING_DIR", cmdLine.getOptionValue(OPT_WORKING_DIR));
        } else {
            autConfig.put("WORKING_DIR", System.getProperty("user.dir"));
        }
        if (cmdLine.hasOption(OPT_NAME_TECHNICAL_COMPONENTS)) {
            autConfig.put("NAME_TECHNICAL_COMPONENTS", Boolean.valueOf(cmdLine.getOptionValue(OPT_NAME_TECHNICAL_COMPONENTS)));
        } else {
            autConfig.put("NAME_TECHNICAL_COMPONENTS", true);
        }
        autConfig.put("EXECUTABLE", cmdLine.getOptionValue(OPT_EXECUTABLE));
        if (cmdLine.hasOption(OPT_KEYBOARD_LAYOUT)) {
            autConfig.put("KEYBOARD_LAYOUT", cmdLine.getOptionValue(OPT_KEYBOARD_LAYOUT));
        }
        if ((autArguments = cmdLine.getOptionValues(OPT_EXECUTABLE)).length > 1) {
            autConfig.put("AUT_RUN_AUT_ARGUMENTS", ArrayUtils.subarray((Object[])autArguments, (int)1, (int)autArguments.length));
        }
        return autConfig;
    }

    private static Options createCmdLineOptions() {
        Options options = new Options();
        Option autAgentHostOption = new Option(OPT_AUT_AGENT_HOST, true, "AUT Agent Host (default \"localhost\")");
        autAgentHostOption.setLongOpt(OPT_AUT_AGENT_HOST_LONG);
        autAgentHostOption.setArgName("hostname");
        options.addOption(autAgentHostOption);
        Option autAgentPortOption = new Option(OPT_AUT_AGENT_PORT, true, "AUT Agent Port between 1024 and 65536 (default \"60000\")");
        autAgentPortOption.setLongOpt(OPT_AUT_AGENT_PORT_LONG);
        autAgentPortOption.setArgName("port");
        options.addOption(autAgentPortOption);
        OptionGroup autToolkitOptionGroup = new OptionGroup();
        autToolkitOptionGroup.addOption(new Option(TK_SWING, "AUT uses Swing toolkit"));
        autToolkitOptionGroup.addOption(new Option(TK_SWT, "AUT uses SWT toolkit"));
        autToolkitOptionGroup.addOption(new Option(TK_RCP, "AUT uses RCP toolkit"));
        autToolkitOptionGroup.setRequired(true);
        options.addOptionGroup(autToolkitOptionGroup);
        Option autIdOption = new Option(OPT_AUT_ID, true, "AUT ID");
        autIdOption.setLongOpt(OPT_AUT_ID_LONG);
        autIdOption.setArgName("id");
        autIdOption.setRequired(true);
        options.addOption(autIdOption);
        Option nameTechnicalComponentsOption = new Option(OPT_NAME_TECHNICAL_COMPONENTS, true, "Generate Names for Technical Components (true / false)");
        nameTechnicalComponentsOption.setLongOpt(OPT_NAME_TECHNICAL_COMPONENTS_LONG);
        nameTechnicalComponentsOption.setArgName("true / false");
        options.addOption(nameTechnicalComponentsOption);
        Option keyboardLayoutOption = new Option(OPT_KEYBOARD_LAYOUT, true, "Keyboard Layout");
        keyboardLayoutOption.setLongOpt(OPT_KEYBOARD_LAYOUT_LONG);
        keyboardLayoutOption.setArgName("locale");
        options.addOption(keyboardLayoutOption);
        Option workingDirOption = new Option(OPT_WORKING_DIR, true, "AUT Working Directory");
        workingDirOption.setLongOpt(OPT_WORKING_DIR_LONG);
        workingDirOption.setArgName("directory");
        options.addOption(workingDirOption);
        Option helpOption = new Option(OPT_HELP, false, "Displays this help");
        helpOption.setLongOpt(OPT_HELP_LONG);
        options.addOption(helpOption);
        OptionBuilder.hasArgs();
        Option autExecutableFileOption = OptionBuilder.create((String)OPT_EXECUTABLE);
        autExecutableFileOption.setDescription("AUT Executable File");
        autExecutableFileOption.setLongOpt(OPT_EXECUTABLE_LONG);
        autExecutableFileOption.setRequired(true);
        autExecutableFileOption.setArgName("command");
        options.addOption(autExecutableFileOption);
        return options;
    }

    public Object start(IApplicationContext context) throws Exception {
        String[] args = (String[])context.getArguments().get("application.args");
        if (args == null) {
            args = new String[]{};
        }
        Options options = AutRunApplication.createCmdLineOptions();
        BasicParser parser = new BasicParser();
        CommandLine cmdLine = null;
        try {
            cmdLine = parser.parse(options, args, false);
        }
        catch (ParseException pe) {
            AutRunApplication.printHelp(pe);
        }
        if (cmdLine != null && !cmdLine.hasOption(OPT_HELP)) {
            String toolkit = "";
            if (cmdLine.hasOption(TK_SWING)) {
                toolkit = "Swing";
            } else if (cmdLine.hasOption(TK_SWT)) {
                toolkit = "Swt";
            } else if (cmdLine.hasOption(TK_RCP)) {
                toolkit = "Rcp";
            }
            int autAgentPort = 60000;
            if (cmdLine.hasOption(OPT_AUT_AGENT_PORT)) {
                try {
                    autAgentPort = Integer.parseInt(cmdLine.getOptionValue(OPT_AUT_AGENT_PORT));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            String autAgentHost = DEFAULT_AUT_AGENT_HOST;
            if (cmdLine.hasOption(OPT_AUT_AGENT_HOST)) {
                autAgentHost = cmdLine.getOptionValue(OPT_AUT_AGENT_HOST);
            }
            InetSocketAddress agentAddr = new InetSocketAddress(autAgentHost, autAgentPort);
            AutIdentifier autId = new AutIdentifier(cmdLine.getOptionValue(OPT_AUT_ID));
            Map<String, Object> autConfiguration = AutRunApplication.createAutConfig(cmdLine);
            AutRunner runner = new AutRunner(toolkit, autId, agentAddr, autConfiguration);
            try {
                runner.run();
            }
            catch (ConnectException ce) {
                LOG.info("Could not connect to AUT Agent.", (Throwable)ce);
                System.err.println(I18n.getString((String)"InfoDetail.connGuiDancerServerFailed"));
            }
        } else {
            AutRunApplication.printHelp(null);
        }
        return IApplication.EXIT_OK;
    }

    public void stop() {
    }

    private static class OptionComparator
    implements Comparator {
        private OptionComparator() {
        }

        public int compare(Object o1, Object o2) {
            Option opt1 = (Option)o1;
            Option opt2 = (Option)o2;
            if (opt1.getOpt().equals(AutRunApplication.OPT_EXECUTABLE)) {
                return 1;
            }
            if (opt2.getOpt().equals(AutRunApplication.OPT_EXECUTABLE)) {
                return -1;
            }
            return 0;
        }
    }
}

