/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IComponentNameData;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMDirtyVersionException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PersistenceManager;
import org.eclipse.jubula.client.core.persistence.PersistenceUtil;
import org.eclipse.jubula.tools.exception.JBFatalException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.utils.ValueListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentNamesDecorator
implements IWritableComponentNameCache {
    private EntityManager m_session;
    private Map<String, IComponentNamePO> m_added = new HashMap<String, IComponentNamePO>();
    private Map<String, Integer> m_reuseChanged = new HashMap<String, Integer>();
    private Set<IComponentNamePO> m_renamed = new HashSet<IComponentNamePO>();
    private Set<IComponentNamePO> m_deleted = new HashSet<IComponentNamePO>();
    private Map<String, IComponentNamePO> m_cached = new HashMap<String, IComponentNamePO>();

    public ComponentNamesDecorator(EntityManager s) {
        this.m_session = s;
    }

    @Override
    public void addComponentNamePO(IComponentNamePO compNamePo) {
        if (compNamePo != null) {
            this.m_added.put(compNamePo.getGuid(), compNamePo);
            this.m_deleted.remove(compNamePo);
        }
    }

    @Override
    public Collection<IComponentNamePO> getNewNames() {
        return Collections.unmodifiableCollection(this.m_added.values());
    }

    private void updateStandardMapper(Long projectId) throws PMException {
        ComponentNamesBP.getInstance().refreshNames(projectId);
    }

    @Override
    public final void updateStandardMapperAndCleanup(Long projectId) {
        try {
            this.updateStandardMapper(projectId);
            this.clear();
        }
        catch (PMException e) {
            throw new JBFatalException(String.valueOf(Messages.ReadingComponentNamesFailed) + "!", (Throwable)((Object)e), MessageIDs.E_DATABASE_GENERAL);
        }
    }

    @Override
    public String getGuidForName(String name) {
        for (IComponentNamePO compNamePo : this.m_renamed) {
            if (!compNamePo.getName().equals(name)) continue;
            return compNamePo.getGuid();
        }
        for (IComponentNamePO compNamePo : this.m_added.values()) {
            if (!compNamePo.getName().equals(name)) continue;
            return compNamePo.getGuid();
        }
        return ComponentNamesBP.getInstance().getGuidForName(name);
    }

    @Override
    public String getGuidForName(String name, Long parentProjectId) {
        IProjectPO currentProject;
        Long parentProjectIdToUse = parentProjectId;
        if (parentProjectIdToUse == null && (currentProject = GeneralStorage.getInstance().getProject()) != null) {
            parentProjectIdToUse = currentProject.getId();
        }
        if (parentProjectIdToUse == null) {
            return null;
        }
        for (IComponentNamePO compNamePo : this.m_renamed) {
            if (!compNamePo.getName().equals(name) || !parentProjectIdToUse.equals(compNamePo.getParentProjectId())) continue;
            return compNamePo.getGuid();
        }
        for (IComponentNamePO compNamePo : this.m_added.values()) {
            if (!compNamePo.getName().equals(name) || !parentProjectIdToUse.equals(compNamePo.getParentProjectId())) continue;
            return compNamePo.getGuid();
        }
        return ComponentNamesBP.getInstance().getGuidForName(name, parentProjectIdToUse);
    }

    @Override
    public IComponentNamePO createComponentNamePO(String name, String type, ComponentNamesBP.CompNameCreationContext creationContext) {
        return this.createComponentNamePO(null, name, type, creationContext);
    }

    public IComponentNamePO createComponentNamePO(String guid, String name, String type, ComponentNamesBP.CompNameCreationContext creationContext) {
        String nameGuid = guid;
        if (guid == null) {
            nameGuid = PersistenceUtil.generateGuid();
        }
        IComponentNamePO newComponentNamePO = PoMaker.createComponentNamePO(nameGuid, name, type, creationContext, GeneralStorage.getInstance().getProject().getId());
        this.addComponentNamePO(newComponentNamePO);
        return newComponentNamePO;
    }

    @Override
    public void removeReuse(String guid) throws PMException {
        Integer timesReused = this.m_reuseChanged.get(guid);
        if (timesReused == null) {
            this.m_reuseChanged.put(guid, -1);
        } else {
            this.m_reuseChanged.put(guid, timesReused - 1);
        }
        if (this.m_reuseChanged.get(guid) < 1) {
            this.m_added.remove(guid);
        }
    }

    @Override
    public void addReuse(String guid) throws PMException {
        Integer timesReused = this.m_reuseChanged.get(guid);
        if (timesReused == null) {
            this.m_reuseChanged.put(guid, 1);
        } else {
            this.m_reuseChanged.put(guid, timesReused + 1);
        }
        IComponentNamePO compNamePo = this.getCompNamePo(guid);
        try {
            try {
                ComponentNamesBP.handleFirstReference(this.m_session, compNamePo, true);
            }
            catch (PersistenceException e) {
                PersistenceManager.handleDBExceptionForAnySession(compNamePo, e, this.m_session);
            }
        }
        catch (PMDirtyVersionException pMDirtyVersionException) {
        }
        catch (PMException e) {
            throw e;
        }
    }

    @Override
    public void renameComponentName(String guid, String newName) {
        IComponentNamePO compNamePo = this.getCompNamePo(guid);
        if (compNamePo != null) {
            compNamePo.setName(newName);
            this.m_renamed.add(compNamePo);
        }
    }

    @Override
    public void clear() {
        this.m_added.clear();
        this.m_reuseChanged.clear();
        this.m_renamed.clear();
        this.m_deleted.clear();
        this.m_cached.clear();
    }

    @Override
    public IComponentNamePO getCompNamePo(String guid) {
        return this.getCompNamePo(guid, true);
    }

    @Override
    public IComponentNamePO getCompNamePo(String guid, boolean resolveRefs) {
        IComponentNamePO compNamePo = this.findCompNameLocal(guid);
        if (compNamePo != null) {
            if (resolveRefs && compNamePo.getReferencedGuid() != null) {
                return this.getCompNamePo(compNamePo.getReferencedGuid(), resolveRefs);
            }
            return compNamePo;
        }
        IComponentNameData retVal = null;
        IComponentNamePO cnPoFromOtherSession = ComponentNamesBP.getInstance().getCompNamePo(guid, resolveRefs);
        if (cnPoFromOtherSession != null && this.m_session != null && this.m_session.isOpen() && (retVal = (IComponentNamePO)this.m_session.find(cnPoFromOtherSession.getClass(), (Object)cnPoFromOtherSession.getId())) != null) {
            this.m_cached.put(retVal.getGuid(), (IComponentNamePO)retVal);
        }
        if (resolveRefs && retVal != null && retVal.getReferencedGuid() != null) {
            return this.getCompNamePo(retVal.getReferencedGuid(), resolveRefs);
        }
        return retVal;
    }

    private IComponentNamePO findCompNameLocal(String guid) {
        IComponentNamePO res = this.m_added.get(guid);
        if (res == null) {
            res = this.m_cached.get(guid);
        }
        return res;
    }

    @Override
    public String getName(String guid) {
        String retVal = guid;
        IComponentNamePO compNamePo = this.getCompNamePo(guid);
        if (compNamePo != null) {
            retVal = compNamePo.getName();
        }
        return retVal;
    }

    @Override
    public Set<IComponentNameData> getComponentNameData() {
        return new HashSet<IComponentNameData>(this.getComponentNames());
    }

    private Collection<IComponentNamePO> getComponentNames() {
        HashSet<IComponentNamePO> compNames = new HashSet<IComponentNamePO>();
        compNames.addAll(this.getLocalComponentNames());
        compNames.addAll(ComponentNamesBP.getInstance().getAllComponentNamePOs());
        return compNames;
    }

    @Override
    public Set<IComponentNameData> getLocalComponentNameData() {
        return new HashSet<IComponentNameData>(this.getLocalComponentNames());
    }

    private Set<IComponentNamePO> getLocalComponentNames() {
        HashSet<IComponentNamePO> sessionNames = new HashSet<IComponentNamePO>();
        sessionNames.addAll(this.m_added.values());
        sessionNames.addAll(this.m_cached.values());
        return sessionNames;
    }

    @Override
    public Collection<String> getReusedNames() {
        return Collections.unmodifiableCollection(this.m_reuseChanged.keySet());
    }

    @Override
    public Collection<IComponentNamePO> getRenamedNames() {
        return Collections.unmodifiableSet(this.m_renamed);
    }

    @Override
    public Collection<IComponentNamePO> getDeletedNames() {
        return Collections.unmodifiableCollection(this.m_deleted);
    }

    public void addToCache(IComponentNamePO toBeCached) {
        this.m_cached.put(toBeCached.getGuid(), toBeCached);
    }

    @Override
    public void initCache(Set<String> guids) {
        HashSet<Long> ids = new HashSet<Long>();
        for (String guid : guids) {
            IComponentNamePO cnPo = ComponentNamesBP.getInstance().getCompNamePo(guid, true);
            if (cnPo == null) continue;
            ids.add(cnPo.getId());
        }
        Query q = this.m_session.createQuery("select compName from ComponentNamePO as compName where compName.id in :ids");
        ValueListIterator iter = new ValueListIterator(new ArrayList(ids));
        while (iter.hasNext()) {
            q.setParameter("ids", (Object)iter.nextList());
            List list = q.getResultList();
            for (IComponentNamePO cn : list) {
                this.m_cached.put(cn.getGuid(), cn);
            }
        }
    }
}

