/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess.db;

import org.eclipse.jubula.client.core.businessprocess.db.NodeBP;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMDirtyVersionException;
import org.eclipse.jubula.client.core.persistence.PMObjectDeletedException;

public class TestSuiteBP
extends NodeBP {
    private TestSuiteBP() {
    }

    public static IRefTestSuitePO addReferencedTestSuite(EditSupport editSupport, INodePO tj, ITestSuitePO referencedTS, Integer position) throws PMAlreadyLockedException, PMDirtyVersionException, PMObjectDeletedException {
        TestSuiteBP.handleFirstReference(editSupport, referencedTS, false);
        IRefTestSuitePO newRefTs = NodeMaker.createRefTestSuitePO(referencedTS);
        if (position != null) {
            tj.addNode(position, newRefTs);
        } else {
            tj.addNode(newRefTs);
        }
        return newRefTs;
    }

    private static void handleFirstReference(EditSupport editSupport, ITestSuitePO referencedTS, boolean isReferencedByThisAction) throws PMAlreadyLockedException, PMDirtyVersionException, PMObjectDeletedException {
        int minSize = 0;
        if (isReferencedByThisAction) {
            minSize = 1;
        }
        if (NodePM.getInternalRefTestSuites(referencedTS.getGuid(), referencedTS.getParentProjectId()).size() <= minSize) {
            TestSuiteBP.lockPO(editSupport, referencedTS);
        }
    }
}

