/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.commands;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.core.businessprocess.TestResultBP;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.TestResult;
import org.eclipse.jubula.communication.ICommand;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.jubula.communication.message.SendMonitoringReportMessage;
import org.eclipse.jubula.tools.constants.MonitoringConstants;
import org.eclipse.jubula.tools.objects.IMonitoringValue;
import org.eclipse.jubula.tools.objects.MonitoringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetMonitoringReportCommand
implements ICommand {
    private static final Logger LOG = LoggerFactory.getLogger(GetMonitoringReportCommand.class);
    private SendMonitoringReportMessage m_message;

    public Message execute() {
        byte[] report;
        TestResult result = TestResultBP.getInstance().getResultTestModel();
        if (!StringUtils.isEmpty((String)this.m_message.getReportPath())) {
            result.getMonitoringValues().put("Monitoring Report was too large to send", (IMonitoringValue)new MonitoringValue(this.m_message.getReportPath(), "DEFAULT_TYPE"));
        }
        if ((report = this.m_message.getData()) == null) {
            result.setReportData(MonitoringConstants.EMPTY_REPORT);
        } else {
            result.setReportData(this.m_message.getData());
        }
        return null;
    }

    public void setMessage(Message message) {
        this.m_message = (SendMonitoringReportMessage)message;
    }

    public Message getMessage() {
        return this.m_message;
    }

    public void timeout() {
        LOG.error(String.valueOf(this.getClass().getName()) + "." + Messages.TimeoutCalled);
    }
}

