/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.eclipse.jubula.client.core.model.AUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IObjectMappingPO;
import org.eclipse.jubula.client.core.model.LanguageHelper;
import org.eclipse.jubula.client.core.model.ObjectMappingPO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.PersistenceUtil;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="AUT")
class AUTMainPO
implements IAUTMainPO,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject {
    private transient Long m_id = null;
    private transient String m_guid = null;
    private String m_autName;
    private String m_toolkit = null;
    private Set<IAUTConfigPO> m_autConfigSet = new HashSet<IAUTConfigPO>();
    private List<String> m_autIDs = new ArrayList<String>();
    private transient Integer m_version = null;
    private IObjectMappingPO m_objMap = null;
    private Set<String> m_autLanguageSet = new TreeSet<String>();
    private LanguageHelper m_langHelper;
    private Long m_parentProjectId = null;
    private boolean m_generateNames;
    private transient boolean m_isModified = true;
    public static final long serialVersionUID = 7371208876411501519L;
    protected transient Object _persistence_primaryKey;

    AUTMainPO() {
        this.m_langHelper = new LanguageHelper(this);
    }

    AUTMainPO(String autName) {
        this(autName, PersistenceUtil.generateGuid());
    }

    AUTMainPO(String autName, String guid) {
        this.m_autName = autName;
        this.m_objMap = PoMaker.createObjectMappingPO();
        this.m_objMap.setParentProjectId(this.getParentProjectId());
        this.m_langHelper = new LanguageHelper(this);
        this.m_guid = guid;
        this.m_generateNames = false;
    }

    @Override
    @Id
    @GeneratedValue
    public Long getId() {
        return this.m_id;
    }

    void setId(Long id) {
        this.m_id = id;
    }

    @Override
    @Basic
    @Column(name="NAME", length=4000)
    public String getName() {
        return this.m_autName;
    }

    @Override
    public void setName(String autName) {
        this.m_autName = autName;
    }

    @Override
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, targetEntity=AUTConfigPO.class, orphanRemoval=true)
    public Set<IAUTConfigPO> getAutConfigSet() {
        return this.m_autConfigSet;
    }

    void setAutConfigSet(Set<IAUTConfigPO> autConfigSet) {
        this.m_autConfigSet = autConfigSet;
    }

    @Override
    public void addAutConfigToSet(IAUTConfigPO autConfig) {
        this.getAutConfigSet().add(autConfig);
        autConfig.setParentProjectId(this.getParentProjectId());
    }

    @Override
    public void removeAutConfig(IAUTConfigPO autConfig) {
        this.m_autConfigSet.remove(autConfig);
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="AUT_LANGUAGES", joinColumns={@JoinColumn(name="AUT")})
    @Column(name="LANGUAGE")
    @OrderBy
    private Set<String> getAUTLanguageList() {
        return this.m_autLanguageSet;
    }

    @Override
    @Transient
    public Set<String> getHbmLanguageList() {
        return this.getAUTLanguageList();
    }

    private void setAUTLanguageList(Set<String> langList) {
        this.m_autLanguageSet = langList;
        this.m_isModified = true;
    }

    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, targetEntity=ObjectMappingPO.class)
    private IObjectMappingPO getHbmObjMap() {
        return this.m_objMap;
    }

    @Override
    @Transient
    public IObjectMappingPO getObjMap() {
        return this.getHbmObjMap();
    }

    private void setHbmObjMap(IObjectMappingPO objMap) {
        this.m_objMap = objMap;
    }

    @Override
    public void setObjMap(IObjectMappingPO objMap) {
        objMap.setParentProjectId(this.getParentProjectId());
        this.setHbmObjMap(objMap);
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " " + "(" + this.m_autName + ")";
    }

    @Override
    @Version
    public Integer getVersion() {
        return this.m_version;
    }

    private void setVersion(Integer version) {
        this.m_version = version;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AUTMainPO) && !(obj instanceof IAUTMainPO)) {
            return false;
        }
        IAUTMainPO o = (IAUTMainPO)obj;
        return this.getGuid().equals(o.getGuid());
    }

    public int hashCode() {
        return this.getGuid().hashCode();
    }

    @Override
    @Transient
    public LanguageHelper getLangHelper() {
        return this.m_langHelper;
    }

    @Override
    public void addLangToList(String lang) {
        this.getAUTLanguageList().add(lang);
    }

    @Override
    public void clearLangList() {
        this.getAUTLanguageList().clear();
    }

    public void removeLang(String lang) {
        this.getAUTLanguageList().remove(lang);
    }

    @Override
    @Transient
    public boolean isModified() {
        return this.m_isModified;
    }

    @Override
    public void setModified(boolean isModified) {
        this.m_isModified = isModified;
    }

    public int compareTo(Object o) {
        IAUTMainPO aut = (IAUTMainPO)o;
        return this.getName().compareTo(aut.getName());
    }

    @Override
    @Basic
    @Column(name="GUID")
    public String getGuid() {
        return this.m_guid;
    }

    void setGuid(String guid) {
        this.m_guid = guid;
    }

    @Override
    @Transient
    public String getToolkit() {
        return this.getHbmToolkit();
    }

    @Override
    @Transient
    public Long getParentProjectId() {
        return this.getHbmParentProjectId();
    }

    @Override
    public void setParentProjectId(Long projectId) {
        this.setHbmParentProjectId(projectId);
        for (IAUTConfigPO configPO : this.getAutConfigSet()) {
            configPO.setParentProjectId(projectId);
        }
        if (this.getObjMap() != null) {
            this.getObjMap().setParentProjectId(projectId);
        }
    }

    @Basic
    @Column(name="PARENT_PROJ")
    Long getHbmParentProjectId() {
        return this.m_parentProjectId;
    }

    void setHbmParentProjectId(Long projectId) {
        this.m_parentProjectId = projectId;
    }

    @Basic
    @Column(name="TOOLKIT")
    private String getHbmToolkit() {
        return this.m_toolkit;
    }

    @Override
    public void setToolkit(String toolkit) {
        this.setHbmToolkit(toolkit);
    }

    private void setHbmToolkit(String toolkit) {
        this.m_toolkit = toolkit;
    }

    @Override
    public void setGenerateNames(boolean generateNames) {
        this.m_generateNames = generateNames;
    }

    @Override
    @Basic
    @Column(nullable=false)
    public boolean isGenerateNames() {
        return this.m_generateNames;
    }

    @Override
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="AUT_IDS", joinColumns={@JoinColumn(name="FK_AUT")})
    @Column(name="AUT_ID_STRING")
    public List<String> getAutIds() {
        return this.m_autIDs;
    }

    private void setAutIds(List<String> autIds) {
        this.m_autIDs = autIds;
    }

    public Object _persistence_post_clone() {
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new AUTMainPO();
    }

    public Object _persistence_get(String string) {
        if (string == "guid") {
            return this.guid;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "generateNames") {
            return this.generateNames;
        }
        if (string == "hbmToolkit") {
            return this.hbmToolkit;
        }
        if (string == "hbmParentProjectId") {
            return this.hbmParentProjectId;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "hbmObjMap") {
            return this.hbmObjMap;
        }
        if (string == "autConfigSet") {
            return this.autConfigSet;
        }
        if (string == "AUTLanguageList") {
            return this.AUTLanguageList;
        }
        if (string == "autIds") {
            return this.autIds;
        }
        if (string == "version") {
            return this.version;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "guid") {
            this.guid = (String)object;
            return;
        }
        if (string == "id") {
            this.id = (Long)object;
            return;
        }
        if (string == "generateNames") {
            this.generateNames = (Boolean)object;
            return;
        }
        if (string == "hbmToolkit") {
            this.hbmToolkit = (String)object;
            return;
        }
        if (string == "hbmParentProjectId") {
            this.hbmParentProjectId = (Long)object;
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "hbmObjMap") {
            this.hbmObjMap = (IObjectMappingPO)object;
            return;
        }
        if (string == "autConfigSet") {
            this.autConfigSet = (Set)object;
            return;
        }
        if (string == "AUTLanguageList") {
            this.AUTLanguageList = (Set)object;
            return;
        }
        if (string == "autIds") {
            this.autIds = (List)object;
            return;
        }
        if (string == "version") {
            this.version = (Integer)object;
            return;
        }
    }
}

