/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.jubula.client.core.model.ILangSupport;
import org.eclipse.jubula.client.core.utils.LocaleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageHelper {
    private ILangSupport m_supportedObj = null;
    private List<Locale> m_languageList = new ArrayList<Locale>();

    public LanguageHelper(ILangSupport obj) {
        this.m_supportedObj = obj;
    }

    public List<Locale> getLanguageList() {
        return Collections.unmodifiableList(this.getInternalLangList());
    }

    private List<Locale> getInternalLangList() {
        if (this.m_supportedObj.isModified()) {
            this.setLanguageList(this.m_supportedObj.getHbmLanguageList());
            this.m_supportedObj.setModified(false);
        }
        return this.m_languageList;
    }

    public void addLanguageToList(Locale lang) {
        this.getInternalLangList().add(lang);
        this.m_supportedObj.addLangToList(lang.toString());
    }

    public void clearLangList() {
        this.getInternalLangList().clear();
        this.m_supportedObj.clearLangList();
    }

    void setLanguageList(Set<String> languageSet) {
        this.m_languageList.clear();
        for (String lang : languageSet) {
            this.m_languageList.add(LocaleUtil.convertStrToLocale(lang));
        }
    }

    public Iterator<Locale> getLangListIterator() {
        return this.getLanguageList().iterator();
    }

    public boolean containsItem(Locale lang) {
        return this.getInternalLangList().contains(lang);
    }
}

