/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyFinderOp
implements ITreeNodeOperation<INodePO> {
    private INodePO m_parentCandidate;
    private Set<INodePO> m_dependentNodes = new HashSet<INodePO>();

    public DependencyFinderOp(INodePO node) {
        this.m_parentCandidate = node;
    }

    @Override
    public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
        if (node instanceof IExecTestCasePO) {
            IExecTestCasePO execTC = (IExecTestCasePO)node;
            if (this.m_parentCandidate.equals(execTC.getSpecTestCase())) {
                this.m_dependentNodes.add(node);
                for (INodePO pathNode : ctx.getCurrentTreePath()) {
                    if (!(pathNode instanceof ISpecTestCasePO)) continue;
                    this.m_dependentNodes.add(pathNode);
                }
            }
        } else if (node.equals(this.m_parentCandidate)) {
            this.m_dependentNodes.add(node);
        }
        return true;
    }

    @Override
    public void postOperate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
    }

    public Set<INodePO> getDependentNodes() {
        return this.m_dependentNodes;
    }
}

