/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.util.List;
import java.util.Locale;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.utils.ExecObject;
import org.eclipse.jubula.client.core.utils.IParamValueToken;
import org.eclipse.jubula.client.core.utils.ParamValueConverter;
import org.eclipse.jubula.tools.exception.InvalidDataException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VariableToken
implements IParamValueToken {
    private static final String VARIABLE = "guidancer.datatype.Variable";
    private String m_value = null;
    private String m_variableName = null;
    private int m_startPos = 0;
    private Integer m_errorKey = null;
    private IParamDescriptionPO m_desc;

    public VariableToken(String s, int pos, String variableName, IParamDescriptionPO desc) {
        this.m_value = s;
        this.m_variableName = variableName;
        this.m_startPos = pos;
        this.m_desc = desc;
    }

    @Override
    public ParamValueConverter.ConvValidationState validate() {
        ParamValueConverter.ConvValidationState state = ParamValueConverter.ConvValidationState.notSet;
        if (VARIABLE.equals(this.m_desc.getType())) {
            state = ParamValueConverter.ConvValidationState.invalid;
            this.setErrorKey(MessageIDs.E_INVALID_VAR_NAME);
        }
        return state;
    }

    @Override
    public boolean isI18Nrelevant() {
        return false;
    }

    @Override
    public Integer getErrorKey() {
        return this.m_errorKey;
    }

    @Override
    public int getEndIndex() {
        return this.m_startPos + this.m_value.length();
    }

    @Override
    public int getStartIndex() {
        return this.m_startPos;
    }

    @Override
    public String getGuiString() {
        return this.m_value;
    }

    @Override
    public String getExecutionString(List<ExecObject> stack, Locale locale) throws InvalidDataException {
        String resolvedVar = TestExecution.getInstance().getVariableStore().getValue(this.m_variableName);
        if (resolvedVar == null) {
            throw new InvalidDataException(String.valueOf(Messages.VariableWithName) + " " + this.m_value + " " + Messages.IsNotResolvable, MessageIDs.E_UNRESOLV_VAR_ERROR);
        }
        return resolvedVar;
    }

    @Override
    public String getModelString() {
        return this.m_value;
    }

    @Override
    public void setErrorKey(Integer errorKey) {
        this.m_errorKey = errorKey;
    }
}

