/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.actions;

import java.util.SortedSet;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.ui.actions.AbstractAction;
import org.eclipse.jubula.client.ui.actions.StartServerAction;
import org.eclipse.jubula.client.ui.businessprocess.AbstractActionBP;
import org.eclipse.jubula.client.ui.businessprocess.ConnectServerBP;
import org.eclipse.jubula.client.ui.controllers.TestExecutionGUIController;
import org.eclipse.jubula.client.ui.utils.ServerManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.IMenuService;

public class ChooseServerAction
extends AbstractAction
implements IWorkbenchWindowPulldownDelegate {
    public static final String PULLDOWN_MENU_ID = "menu:org.eclipse.jubula.client.ui.actions.ChooseServerAction.dropdown";

    public void runWithEvent(IAction action, Event event) {
        if (action != null && !action.isEnabled()) {
            return;
        }
        ServerManager.Server server = ConnectServerBP.getInstance().getWorkingServer();
        if (server == null) {
            return;
        }
        DataEventDispatcher.getInstance().fireServerConnectionChanged(DataEventDispatcher.ServerState.Connecting);
        TestExecutionGUIController.connectToServer(server);
        ConnectServerBP.getInstance().setCurrentServer(server);
    }

    public Menu getMenu(Control parent) {
        String serverName = "";
        ServerManager.Server workingServer = ConnectServerBP.getInstance().getWorkingServer();
        MenuManager menuManager = new MenuManager();
        IMenuService menuService = (IMenuService)PlatformUI.getWorkbench().getService(IMenuService.class);
        menuService.populateContributionManager((ContributionManager)menuManager, PULLDOWN_MENU_ID);
        Menu fMenu = menuManager.createContextMenu(parent);
        ServerManager serverMgr = ServerManager.getInstance();
        SortedSet<ServerManager.Server> servers = serverMgr.getServers();
        for (ServerManager.Server server : servers) {
            StartServerAction action = new StartServerAction(server, 2);
            if (workingServer != null && workingServer.equals(server)) {
                action.setChecked(true);
            } else {
                action.setChecked(false);
            }
            if (serverName != null && !serverName.equals("") && !serverName.equals(server.getName())) {
                menuManager.add((IContributionItem)new Separator());
            }
            menuManager.add((IAction)action);
            serverName = server.getName();
        }
        return fMenu;
    }

    protected AbstractActionBP getActionBP() {
        return ConnectServerBP.getInstance();
    }
}

