/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.attribute;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jubula.client.core.model.IDocAttributeDescriptionPO;
import org.eclipse.jubula.client.core.model.IDocAttributePO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.attribute.AbstractAttributeRenderer;
import org.eclipse.jubula.client.ui.attribute.IAttributeRenderer;
import org.eclipse.jubula.client.ui.constants.Layout;
import org.eclipse.jubula.client.ui.factory.AttributeRendererFactory;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class DefaultListRenderer
extends AbstractAttributeRenderer {
    private static final int NUM_COLUMNS_1 = 1;
    private static final int NUM_COLUMNS_2 = 2;
    private static final int LINES = 15;
    private Button m_addButton = null;
    private Button m_removeButton = null;
    private Button m_editButton = null;
    private org.eclipse.swt.widgets.List m_textList = null;
    private List<IDocAttributePO> m_attrList = new ArrayList<IDocAttributePO>();
    private IDocAttributeDescriptionPO m_desc;
    private WidgetSelectionListener m_selectionListener = new WidgetSelectionListener();

    public void renderAttribute(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        GridData compositeData = new GridData(1808);
        this.createCompositeLayout(composite, compositeLayout, compositeData);
        composite.setLayoutData((Object)compositeData);
        this.createCompositeLayout(composite, compositeLayout, compositeData);
        this.createAUTList(composite);
        this.createButtons(composite);
        this.initFields();
        this.addListeners();
        Plugin.getHelpSystem().setHelp((Control)composite, "org.eclipse.jubula.client.ua.help.autSettingsPageContextId");
    }

    private void initFields() {
        this.m_textList.removeAll();
        this.m_attrList.clear();
        Iterator iterator = this.getAttribute().getDocAttributeTypes().iterator();
        while (iterator.hasNext()) {
            IDocAttributeDescriptionPO docAttrDesc;
            this.m_desc = docAttrDesc = (IDocAttributeDescriptionPO)iterator.next();
            for (IDocAttributePO attr : this.getAttribute().getDocAttributeList(docAttrDesc).getAttributes()) {
                this.m_attrList.add(attr);
                this.m_textList.add(StringUtils.defaultString((String)attr.getValue()));
            }
        }
    }

    private void addListeners() {
        this.m_addButton.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_editButton.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_removeButton.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_textList.addSelectionListener((SelectionListener)this.m_selectionListener);
    }

    private void createCompositeLayout(Composite composite, GridLayout compositeLayout, GridData compositeData) {
        compositeData.grabExcessHorizontalSpace = false;
        compositeLayout.horizontalSpacing = 10;
        compositeLayout.verticalSpacing = 10;
        compositeLayout.numColumns = 2;
        compositeLayout.marginHeight = 10;
        compositeLayout.marginWidth = 10;
        composite.setLayout((org.eclipse.swt.widgets.Layout)compositeLayout);
    }

    void handleAddButtonEvent() {
        IDocAttributePO attr = PoMaker.createDocAttribute((IDocAttributeDescriptionPO)this.m_desc);
        IAttributeRenderer renderer = AttributeRendererFactory.getRenderer(this.m_desc);
        renderer.init(this.m_desc, attr);
        if (this.openAttributeDialog(renderer) == 0) {
            this.getAttribute().getDocAttributeList(this.m_desc).addAttribute(attr);
            this.initFields();
        }
    }

    void handleEditButtonEvent() {
        int idx = this.m_textList.getSelectionIndex();
        if (idx == -1) {
            return;
        }
        IDocAttributePO attr = this.m_attrList.get(idx);
        IAttributeRenderer renderer = AttributeRendererFactory.getRenderer(this.m_desc);
        renderer.init(this.m_desc, attr);
        if (this.openAttributeDialog(renderer) == 0) {
            this.initFields();
        }
    }

    private int openAttributeDialog(IAttributeRenderer renderer) {
        AttributeDialog dialog = new AttributeDialog(this.m_textList.getShell(), renderer);
        dialog.create();
        dialog.getShell().setText(I18n.getString((String)this.m_desc.getLabelKey()));
        return dialog.open();
    }

    void handleRemoveButtonEvent() {
        int idx = this.m_textList.getSelectionIndex();
        if (idx != -1) {
            IDocAttributePO toRemove = this.m_attrList.get(idx);
            this.m_textList.remove(idx);
            this.m_attrList.remove(idx);
            this.getAttribute().getDocAttributeList(this.m_desc).removeAttribute(toRemove);
        }
    }

    void handleListEvent() {
        String[] selection;
        if (this.m_textList.getItemCount() == 0) {
            this.m_editButton.setEnabled(false);
            this.m_removeButton.setEnabled(false);
            return;
        }
        if (this.m_textList.getSelectionCount() > 0 && !"".equals((selection = this.m_textList.getSelection())[0])) {
            this.m_editButton.setEnabled(true);
            this.m_removeButton.setEnabled(true);
        }
    }

    private void createAUTList(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = 1;
        composite.setLayout((org.eclipse.swt.widgets.Layout)compositeLayout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        this.newLabel(composite, I18n.getString((String)this.getDescription().getLabelKey()));
        this.m_textList = new org.eclipse.swt.widgets.List(composite, 2822);
        GridData textGridData = new GridData();
        textGridData.horizontalAlignment = 4;
        textGridData.grabExcessHorizontalSpace = true;
        textGridData.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)Layout.getFontMetrics((Control)this.m_textList), (int)15);
        Layout.addToolTipAndMaxWidth(textGridData, (Control)this.m_textList);
        this.m_textList.setLayoutData((Object)textGridData);
    }

    private Label newLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        GridData labelGrid = new GridData(1, 2, false, false, 1, 1);
        label.setLayoutData((Object)labelGrid);
        return label;
    }

    private void createButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = 1;
        composite.setLayout((org.eclipse.swt.widgets.Layout)compositeLayout);
        GridData data = new GridData();
        data.verticalAlignment = 1;
        data.horizontalAlignment = 3;
        composite.setLayoutData((Object)data);
        new Label(composite, 0);
        this.m_addButton = new Button(composite, 8);
        this.m_addButton.setText(Messages.AUTPropertyPageAdd);
        this.m_addButton.setLayoutData((Object)this.buttonGrid());
        this.m_editButton = new Button(composite, 8);
        this.m_editButton.setText(Messages.AUTPropertyPageEdit);
        this.m_editButton.setLayoutData((Object)this.buttonGrid());
        this.m_editButton.setEnabled(false);
        this.m_removeButton = new Button(composite, 8);
        this.m_removeButton.setText(Messages.AUTPropertyPageRemove);
        this.m_removeButton.setLayoutData((Object)this.buttonGrid());
        this.m_removeButton.setEnabled(false);
    }

    private GridData buttonGrid() {
        GridData buttonData = new GridData();
        buttonData.horizontalAlignment = 4;
        return buttonData;
    }

    private class AttributeDialog
    extends Dialog {
        private IAttributeRenderer m_renderer;

        protected AttributeDialog(Shell parentShell, IAttributeRenderer renderer) {
            super(parentShell);
            this.m_renderer = renderer;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.m_renderer.renderAttribute(composite);
            return composite;
        }
    }

    private class WidgetSelectionListener
    implements SelectionListener {
        private WidgetSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object o = e.getSource();
            if (o == DefaultListRenderer.this.m_addButton) {
                DefaultListRenderer.this.handleAddButtonEvent();
                return;
            }
            if (o == DefaultListRenderer.this.m_editButton) {
                DefaultListRenderer.this.handleEditButtonEvent();
                return;
            }
            if (o == DefaultListRenderer.this.m_removeButton) {
                DefaultListRenderer.this.handleRemoveButtonEvent();
                return;
            }
            if (o == DefaultListRenderer.this.m_textList) {
                DefaultListRenderer.this.handleListEvent();
                return;
            }
            Assert.notReached((String)Messages.EventWasCreatedByAnUnknownWidget);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            Object o = e.getSource();
            if (o == DefaultListRenderer.this.m_textList) {
                DefaultListRenderer.this.handleEditButtonEvent();
                return;
            }
            Assert.notReached((String)Messages.DoubleClickEventWasCreatedByAnUnknownWidget);
        }
    }
}

