/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.businessprocess;

import java.util.ConcurrentModificationException;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jubula.client.core.businessprocess.CompletenessGuard;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IObjectMappingPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.businessprocess.WorkingLanguageBP;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.osgi.util.NLS;

public class CompletenessBP
implements DataEventDispatcher.IDataChangedListener,
DataEventDispatcher.IProjectLoadedListener,
DataEventDispatcher.ILanguageChangedListener {
    private static CompletenessBP instance;

    private CompletenessBP() {
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.addDataChangedListener((DataEventDispatcher.IDataChangedListener)this, false);
        ded.addLanguageChangedListener((DataEventDispatcher.ILanguageChangedListener)this, false);
        ded.addProjectLoadedListener((DataEventDispatcher.IProjectLoadedListener)this, false);
    }

    public static CompletenessBP getInstance() {
        if (instance == null) {
            instance = new CompletenessBP();
        }
        return instance;
    }

    public void handleDataChanged(DataChangedEvent ... events) {
        DataChangedEvent[] dataChangedEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DataChangedEvent e = dataChangedEventArray[n2];
            this.handleDataChanged(e.getPo(), e.getDataState(), e.getUpdateState());
            ++n2;
        }
    }

    public void handleDataChanged(IPersistentObject po, DataEventDispatcher.DataState dataState, DataEventDispatcher.UpdateState updateState) {
        switch (updateState) {
            case onlyInEditor: {
                return;
            }
        }
        switch (dataState) {
            case Renamed: 
            case Deleted: {
                return;
            }
            case Added: {
                if (po instanceof IProjectPO || po instanceof ITestSuitePO) break;
                return;
            }
        }
        IProjectPO root = GeneralStorage.getInstance().getProject();
        if (po instanceof ICategoryPO) {
            return;
        }
        if (po instanceof ISpecTestCasePO) {
            if (dataState != DataEventDispatcher.DataState.StructureModified) {
                return;
            }
        } else if (po instanceof ITestSuitePO) {
            root = (INodePO)po;
        } else if (po instanceof IAUTMainPO || po instanceof IObjectMappingPO) {
            CompletenessGuard.checkOM((INodePO)root);
            this.fireCompletenessCheckFinished();
            return;
        }
        Locale wl = WorkingLanguageBP.getInstance().getWorkingLanguage();
        this.runCheck(false, (INodePO)root, wl);
    }

    public void handleProjectLoaded() {
        this.checkProject(false);
    }

    public void checkProject(boolean runInJob) {
        IProjectPO root = GeneralStorage.getInstance().getProject();
        if (root != null) {
            Locale wl = WorkingLanguageBP.getInstance().getWorkingLanguage();
            this.runCheck(runInJob, (INodePO)root, wl);
        }
    }

    private void runCheck(boolean runInJob, final INodePO root, final Locale wl) {
        if (runInJob) {
            final String jobName = NLS.bind((String)Messages.UIJobRunCompletenessCheck, (Object)root.getName());
            Job job = new Job(jobName){

                public IStatus run(IProgressMonitor monitor) {
                    IStatus result = Status.OK_STATUS;
                    monitor.beginTask(jobName, -1);
                    try {
                        CompletenessGuard.checkAll((Locale)wl, (INodePO)root);
                        CompletenessBP.this.fireCompletenessCheckFinished();
                        monitor.done();
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                        result = Status.CANCEL_STATUS;
                        monitor.setCanceled(true);
                        CompletenessBP.this.runCheck(true, root, wl);
                    }
                    monitor.done();
                    return result;
                }
            };
            job.schedule();
        } else {
            CompletenessGuard.checkAll((Locale)wl, (INodePO)root);
            this.fireCompletenessCheckFinished();
        }
    }

    public void handleLanguageChanged(Locale locale) {
        IProjectPO root = GeneralStorage.getInstance().getProject();
        Locale wl = WorkingLanguageBP.getInstance().getWorkingLanguage();
        CompletenessGuard.checkTD((Locale)wl, (INodePO)root);
        this.fireCompletenessCheckFinished();
    }

    private void fireCompletenessCheckFinished() {
        DataEventDispatcher.getInstance().fireCompletenessCheckFinished();
    }
}

