/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.businessprocess;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;

public class ComponentNameReuseBP
implements DataEventDispatcher.IDataChangedListener,
DataEventDispatcher.IProjectLoadedListener {
    private static ComponentNameReuseBP instance = null;
    private Map<String, Boolean> m_compNameGuidToIsReusedMap = new HashMap<String, Boolean>();

    private ComponentNameReuseBP() {
        DataEventDispatcher.getInstance().addDataChangedListener((DataEventDispatcher.IDataChangedListener)this, false);
        DataEventDispatcher.getInstance().addProjectLoadedListener((DataEventDispatcher.IProjectLoadedListener)this, false);
    }

    public boolean isCompNameReused(String compNameGuid) {
        if (this.m_compNameGuidToIsReusedMap.get(compNameGuid) != null) {
            return this.m_compNameGuidToIsReusedMap.get(compNameGuid);
        }
        IProjectPO currentProject = GeneralStorage.getInstance().getProject();
        if (currentProject != null) {
            List specsToSearch = currentProject.getSpecObjCont().getSpecObjList();
            Set autsToSearch = currentProject.getAutMainList();
            boolean isReused = ComponentNamesBP.getInstance().isCompNameReused((Collection)specsToSearch, (Collection)currentProject.getTestSuiteCont().getTestSuiteList(), (Collection)autsToSearch, compNameGuid);
            this.m_compNameGuidToIsReusedMap.put(compNameGuid, isReused);
            return isReused;
        }
        return false;
    }

    public void handleDataChanged(DataChangedEvent ... events) {
        DataChangedEvent[] dataChangedEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DataChangedEvent e = dataChangedEventArray[n2];
            if (e.getPo() instanceof IComponentNamePO) {
                IComponentNamePO compName = (IComponentNamePO)e.getPo();
                switch (e.getDataState()) {
                    case ReuseChanged: {
                        this.m_compNameGuidToIsReusedMap.remove(compName.getGuid());
                        break;
                    }
                }
            }
            ++n2;
        }
    }

    public void handleProjectLoaded() {
        this.m_compNameGuidToIsReusedMap.clear();
    }

    public static ComponentNameReuseBP getInstance() {
        if (instance == null) {
            instance = new ComponentNameReuseBP();
        }
        return instance;
    }
}

