/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.controllers.dnd;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.controllers.dnd.AbstractNodeViewerDropAdapter;
import org.eclipse.jubula.client.ui.controllers.dnd.LocalSelectionTransfer;
import org.eclipse.jubula.client.ui.controllers.dnd.TCEditorDndSupport;
import org.eclipse.jubula.client.ui.editors.AbstractTestCaseEditor;
import org.eclipse.swt.dnd.TransferData;

public class TCEditorDropTargetListener
extends AbstractNodeViewerDropAdapter {
    private AbstractTestCaseEditor m_editor;

    public TCEditorDropTargetListener(AbstractTestCaseEditor editor) {
        super((Viewer)editor.getTreeViewer());
        this.m_editor = editor;
        boolean scrollExpand = Plugin.getDefault().getPreferenceStore().getBoolean("TREEAUTOSCROLL_PREF_KEY");
        this.setScrollExpandEnabled(scrollExpand);
    }

    public boolean performDrop(Object data) {
        LocalSelectionTransfer transfer = LocalSelectionTransfer.getInstance();
        IStructuredSelection selection = transfer.getSelection();
        Object target = this.getCurrentTarget();
        if (selection instanceof StructuredSelection) {
            int location = this.getCurrentLocation();
            if (target == null) {
                target = this.getFallbackTarget(this.getViewer());
                location = 2;
            }
            if (target instanceof INodePO) {
                return TCEditorDndSupport.performDrop(this.m_editor, selection, (INodePO)target, location);
            }
        }
        return false;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        LocalSelectionTransfer transfer = LocalSelectionTransfer.getInstance();
        IStructuredSelection selection = transfer.getSelection();
        if (selection instanceof StructuredSelection) {
            Object targetObject = target;
            if (targetObject == null) {
                targetObject = this.m_editor.getEditorHelper().getEditSupport().getWorkVersion();
            }
            if (targetObject instanceof INodePO) {
                return TCEditorDndSupport.validateDrop(transfer.getSource(), this.getViewer(), selection, (INodePO)targetObject, true);
            }
        }
        return false;
    }
}

